/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.internal.localstore.FileStoreRoot;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.ObjectMap;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.internal.watson.IElementTreeData;
import org.eclipse.core.runtime.QualifiedName;

public class ResourceInfo
implements IElementTreeData,
ICoreConstants,
IStringPoolParticipant {
    protected static final int LOWER = 65535;
    protected static final int UPPER = -65536;
    protected volatile int charsetAndContentId = 0;
    protected FileStoreRoot fileStoreRoot;
    protected int flags = 0;
    protected volatile long localInfo = -1L;
    protected volatile int markerAndSyncStamp;
    protected MarkerSet markers = null;
    protected long modStamp = 0L;
    protected volatile long nodeId = 0L;
    protected ObjectMap sessionProperties = null;
    protected ObjectMap syncInfo = null;

    protected static int getBits(int n, int n2, int n3) {
        return (n & n2) >> n3;
    }

    public static int getType(int n) {
        return ResourceInfo.getBits(n, 3840, 8);
    }

    public static boolean isSet(int n, int n2) {
        return (n & n2) == n2;
    }

    public void clear(int n) {
        this.flags &= ~n;
    }

    public void clearModificationStamp() {
        this.modStamp = -1L;
    }

    public synchronized void clearSessionProperties() {
        this.sessionProperties = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getCharsetGenerationCount() {
        return this.charsetAndContentId >> 16;
    }

    public int getContentId() {
        return this.charsetAndContentId & 0xFFFF;
    }

    public FileStoreRoot getFileStoreRoot() {
        return this.fileStoreRoot;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getLocalSyncInfo() {
        return this.localInfo;
    }

    public int getMarkerGenerationCount() {
        return this.markerAndSyncStamp >> 16;
    }

    public MarkerSet getMarkers() {
        return this.getMarkers(true);
    }

    public MarkerSet getMarkers(boolean bl) {
        if (this.markers == null) {
            return null;
        }
        return bl ? (MarkerSet)this.markers.clone() : this.markers;
    }

    public long getModificationStamp() {
        return this.modStamp;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Object getPropertyStore() {
        return null;
    }

    public Map getSessionProperties() {
        ObjectMap objectMap = this.sessionProperties;
        objectMap = objectMap == null ? new ObjectMap(5) : (ObjectMap)this.sessionProperties.clone();
        return objectMap;
    }

    public Object getSessionProperty(QualifiedName qualifiedName) {
        ObjectMap objectMap = this.sessionProperties;
        if (objectMap == null) {
            return null;
        }
        return objectMap.get(qualifiedName);
    }

    public synchronized ObjectMap getSyncInfo(boolean bl) {
        if (this.syncInfo == null) {
            return null;
        }
        return bl ? (ObjectMap)this.syncInfo.clone() : this.syncInfo;
    }

    public synchronized byte[] getSyncInfo(QualifiedName qualifiedName, boolean bl) {
        if (this.syncInfo == null) {
            return null;
        }
        byte[] byArray = (byte[])this.syncInfo.get(qualifiedName);
        return byArray == null ? null : (bl ? (byte[])byArray.clone() : byArray);
    }

    public int getSyncInfoGenerationCount() {
        return this.markerAndSyncStamp & 0xFFFF;
    }

    public int getType() {
        return ResourceInfo.getType(this.flags);
    }

    public void incrementCharsetGenerationCount() {
        this.charsetAndContentId = (this.charsetAndContentId + 65535 + 1 & 0xFFFF0000) + (this.charsetAndContentId & 0xFFFF);
    }

    public void incrementContentId() {
        this.charsetAndContentId = (this.charsetAndContentId & 0xFFFF0000) + (this.charsetAndContentId + 1 & 0xFFFF);
    }

    public void incrementMarkerGenerationCount() {
        this.markerAndSyncStamp = (this.markerAndSyncStamp + 65535 + 1 & 0xFFFF0000) + (this.markerAndSyncStamp & 0xFFFF);
    }

    public void incrementModificationStamp() {
        ++this.modStamp;
    }

    public void incrementSyncInfoGenerationCount() {
        this.markerAndSyncStamp = (this.markerAndSyncStamp & 0xFFFF0000) + (this.markerAndSyncStamp + 1 & 0xFFFF);
    }

    public boolean isSet(int n) {
        return (this.flags & n) == n;
    }

    public void readFrom(int n, DataInput dataInput) throws IOException {
        this.flags = n;
        this.localInfo = dataInput.readLong();
        this.nodeId = dataInput.readLong();
        this.charsetAndContentId = dataInput.readInt() & 0xFFFF;
        this.modStamp = dataInput.readLong();
    }

    public void set(int n) {
        this.flags |= n;
    }

    protected void setBits(int n, int n2, int n3) {
        int n4 = n >> n2;
        int n5 = (n3 & n4) << n2;
        int n6 = this.flags;
        n6 &= ~n;
        this.flags = n6 |= n5;
    }

    public void setFileStoreRoot(FileStoreRoot fileStoreRoot) {
        this.fileStoreRoot = fileStoreRoot;
    }

    protected void setFlags(int n) {
        this.flags = n;
    }

    public void setLocalSyncInfo(long l) {
        this.localInfo = l;
    }

    public void setMarkers(MarkerSet markerSet) {
        this.markers = markerSet;
    }

    public void setModificationStamp(long l) {
        this.modStamp = l;
    }

    public void setNodeId(long l) {
        this.nodeId = l;
    }

    public void setPropertyStore(Object object) {
    }

    public synchronized void setSessionProperty(QualifiedName qualifiedName, Object object) {
        if (object == null) {
            if (this.sessionProperties == null) {
                return;
            }
            ObjectMap objectMap = (ObjectMap)this.sessionProperties.clone();
            objectMap.remove(qualifiedName);
            this.sessionProperties = objectMap.isEmpty() ? null : objectMap;
        } else {
            ObjectMap objectMap = this.sessionProperties;
            objectMap = objectMap == null ? new ObjectMap(5) : (ObjectMap)this.sessionProperties.clone();
            objectMap.put(qualifiedName, object);
            this.sessionProperties = objectMap;
        }
    }

    protected void setSyncInfo(ObjectMap objectMap) {
        this.syncInfo = objectMap;
    }

    public synchronized void setSyncInfo(QualifiedName qualifiedName, byte[] byArray) {
        if (byArray == null) {
            if (this.syncInfo == null) {
                return;
            }
            this.syncInfo.remove(qualifiedName);
            if (this.syncInfo.isEmpty()) {
                this.syncInfo = null;
            }
        } else {
            if (this.syncInfo == null) {
                this.syncInfo = new ObjectMap(5);
            }
            this.syncInfo.put(qualifiedName, byArray.clone());
        }
    }

    public void setType(int n) {
        this.setBits(3840, 8, n);
    }

    public void shareStrings(StringPool stringPool) {
        MarkerSet markerSet;
        ObjectMap objectMap = this.syncInfo;
        if (objectMap != null) {
            objectMap.shareStrings(stringPool);
        }
        if ((objectMap = this.sessionProperties) != null) {
            objectMap.shareStrings(stringPool);
        }
        if ((markerSet = this.markers) != null) {
            markerSet.shareStrings(stringPool);
        }
    }

    public void writeTo(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.localInfo);
        dataOutput.writeLong(this.nodeId);
        dataOutput.writeInt(this.getContentId());
        dataOutput.writeLong(this.modStamp);
    }
}

