/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;

public class ResourceStatus
extends Status
implements IResourceStatus {
    IPath path;

    public ResourceStatus(int n, int n2, IPath iPath, String string, Throwable throwable) {
        super(n, "org.eclipse.core.resources", n2, string, throwable);
        this.path = iPath;
    }

    public ResourceStatus(int n, String string) {
        this(ResourceStatus.getSeverity(n), n, null, string, null);
    }

    public ResourceStatus(int n, IPath iPath, String string) {
        this(ResourceStatus.getSeverity(n), n, iPath, string, null);
    }

    public ResourceStatus(int n, IPath iPath, String string, Throwable throwable) {
        this(ResourceStatus.getSeverity(n), n, iPath, string, throwable);
    }

    public IPath getPath() {
        return this.path;
    }

    protected static int getSeverity(int n) {
        return n == 0 ? 0 : 1 << n % 100 / 33;
    }

    private String getTypeName() {
        switch (this.getSeverity()) {
            case 0: {
                return "OK";
            }
            case 4: {
                return "ERROR";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
        }
        return String.valueOf(this.getSeverity());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[type: ");
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("], [path: ");
        stringBuffer.append(this.getPath());
        stringBuffer.append("], [message: ");
        stringBuffer.append(this.getMessage());
        stringBuffer.append("], [plugin: ");
        stringBuffer.append(this.getPlugin());
        stringBuffer.append("], [exception: ");
        stringBuffer.append(this.getException());
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }
}

