/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.BitMask;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.osgi.util.NLS;

class ResourceTree
implements IResourceTree {
    private boolean isValid = true;
    private final FileSystemResourceManager localManager;
    private ILock lock;
    private MultiStatus multistatus;
    private int updateFlags;

    public ResourceTree(FileSystemResourceManager fileSystemResourceManager, ILock iLock, MultiStatus multiStatus, int n) {
        this.localManager = fileSystemResourceManager;
        this.lock = iLock;
        this.multistatus = multiStatus;
        this.updateFlags = n;
    }

    public void addToLocalHistory(IFile iFile) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            if (!iFile.exists()) {
                return;
            }
            IFileStore iFileStore = this.localManager.getStore(iFile);
            IFileInfo iFileInfo = iFileStore.fetchInfo();
            if (!iFileInfo.exists()) {
                return;
            }
            this.localManager.getHistoryStore().addState(iFile.getFullPath(), iFileStore, iFileInfo, false);
        }
        finally {
            this.lock.release();
        }
    }

    private IFileStore computeDestinationStore(IProjectDescription iProjectDescription) throws CoreException {
        URI uRI = iProjectDescription.getLocationURI();
        if (uRI == null) {
            IPath iPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            uRI = iPath.append(iProjectDescription.getName()).toFile().toURI();
        }
        return EFS.getStore((URI)uRI);
    }

    public long computeTimestamp(IFile iFile) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            if (!iFile.getProject().exists()) {
                return 0L;
            }
            long l = this.internalComputeTimestamp(iFile);
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    private void copyLocalHistory(IResource iResource, IResource iResource2) {
        this.localManager.getHistoryStore().copyHistory(iResource, iResource2, true);
    }

    public void deletedFile(IFile iFile) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            if (!iFile.exists()) {
                return;
            }
            try {
                ((Resource)((Object)iFile)).deleteResource(true, null);
            }
            catch (CoreException coreException) {
                String string = NLS.bind((String)Messages.resources_errorDeleting, (Object)iFile.getFullPath());
                ResourceStatus resourceStatus = new ResourceStatus(4, iFile.getFullPath(), string, coreException);
                this.failed(resourceStatus);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public void deletedFolder(IFolder iFolder) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            if (!iFolder.exists()) {
                return;
            }
            try {
                ((Resource)((Object)iFolder)).deleteResource(true, null);
            }
            catch (CoreException coreException) {
                String string = NLS.bind((String)Messages.resources_errorDeleting, (Object)iFolder.getFullPath());
                ResourceStatus resourceStatus = new ResourceStatus(4, iFolder.getFullPath(), string, coreException);
                this.failed(resourceStatus);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public void deletedProject(IProject iProject) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            if (!iProject.exists()) {
                return;
            }
            try {
                ((Project)iProject).deleteResource(false, null);
            }
            catch (CoreException coreException) {
                String string = NLS.bind((String)Messages.resources_errorDeleting, (Object)iProject.getFullPath());
                ResourceStatus resourceStatus = new ResourceStatus(4, iProject.getFullPath(), string, coreException);
                this.failed(resourceStatus);
            }
        }
        finally {
            this.lock.release();
        }
    }

    private boolean ensureDestinationEmpty(IProject iProject, IFileStore iFileStore, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iFileStore.fetchInfo().exists()) {
            return true;
        }
        if (iFileStore.childNames(0, Policy.subMonitorFor(iProgressMonitor, 0)).length > 0) {
            if (((Resource)((Object)iProject)).getStore().equals(iFileStore)) {
                return true;
            }
            String string = NLS.bind((String)Messages.localstore_resourceExists, (Object)iFileStore);
            ResourceStatus resourceStatus = new ResourceStatus(4, iProject.getFullPath(), string, null);
            this.failed(resourceStatus);
            return false;
        }
        iFileStore.delete(0, Policy.subMonitorFor(iProgressMonitor, 0));
        return true;
    }

    public void failed(IStatus iStatus) {
        Assert.isLegal((boolean)this.isValid);
        this.multistatus.add(iStatus);
    }

    protected IStatus getStatus() {
        return this.multistatus;
    }

    public long getTimestamp(IFile iFile) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            if (!iFile.exists()) {
                return 0L;
            }
            ResourceInfo resourceInfo = ((File)iFile).getResourceInfo(false, false);
            long l = resourceInfo == null ? 0L : resourceInfo.getLocalSyncInfo();
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    private long internalComputeTimestamp(IFile iFile) {
        IFileInfo iFileInfo = this.localManager.getStore(iFile).fetchInfo();
        return iFileInfo.exists() ? iFileInfo.getLastModified() : 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean internalDeleteFile(IFile iFile, int n, IProgressMonitor iProgressMonitor) {
        try {
            boolean bl;
            boolean bl2;
            String string = NLS.bind((String)Messages.resources_deleting, (Object)iFile.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            Policy.checkCanceled(iProgressMonitor);
            if (!iFile.exists()) {
                return true;
            }
            if (iFile.isLinked()) {
                this.deletedFile(iFile);
                return true;
            }
            IFileStore iFileStore = this.localManager.getStore(iFile);
            boolean bl3 = iFileStore.fetchInfo().exists();
            if (!bl3) {
                this.deletedFile(iFile);
                return true;
            }
            boolean bl4 = (n & 2) != 0;
            boolean bl5 = bl2 = (n & 1) != 0;
            if (bl4) {
                this.addToLocalHistory(iFile);
            }
            iProgressMonitor.worked(25);
            if (!bl2 && !(bl = this.isSynchronized(iFile, 0)) && bl3) {
                string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)iFile.getFullPath());
                ResourceStatus resourceStatus = new ResourceStatus(274, iFile.getFullPath(), string);
                this.failed(resourceStatus);
                return false;
            }
            iProgressMonitor.worked(25);
            try {
                iFileStore.delete(0, Policy.subMonitorFor(iProgressMonitor, 25));
                this.deletedFile(iFile);
                return true;
            }
            catch (CoreException coreException) {
                string = NLS.bind((String)Messages.resources_couldnotDelete, (Object)iFileStore.toString());
                ResourceStatus resourceStatus = new ResourceStatus(273, iFile.getFullPath(), string, coreException);
                this.failed(resourceStatus);
                iProgressMonitor.done();
                return false;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private boolean internalDeleteFolder(IFolder iFolder, int n, IProgressMonitor iProgressMonitor) {
        String string = NLS.bind((String)Messages.resources_deleting, (Object)iFolder.getFullPath());
        iProgressMonitor.beginTask("", 100);
        iProgressMonitor.subTask(string);
        Policy.checkCanceled(iProgressMonitor);
        if (!iFolder.exists()) {
            return true;
        }
        if (iFolder.isLinked()) {
            this.deletedFolder(iFolder);
            return true;
        }
        IFileStore iFileStore = this.localManager.getStore(iFolder);
        if (!iFileStore.fetchInfo().exists()) {
            this.deletedFolder(iFolder);
            return true;
        }
        try {
            this.localManager.delete(iFolder, n, Policy.subMonitorFor(iProgressMonitor, 100));
        }
        catch (CoreException coreException) {
            string = NLS.bind((String)Messages.localstore_couldnotDelete, (Object)iFolder.getFullPath());
            ResourceStatus resourceStatus = new ResourceStatus(4, 273, iFolder.getFullPath(), string, coreException);
            this.failed(resourceStatus);
            return false;
        }
        return true;
    }

    private boolean internalDeleteProject(IProject iProject, int n, IProgressMonitor iProgressMonitor) {
        String[] stringArray;
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iProject.members(10);
        }
        catch (CoreException coreException) {
            String string = NLS.bind((String)Messages.resources_errorMembers, (Object)iProject.getFullPath());
            ResourceStatus resourceStatus = new ResourceStatus(4, iProject.getFullPath(), string, coreException);
            this.failed(resourceStatus);
            return false;
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            stringArray = iResourceArray[n2];
            switch (stringArray.getType()) {
                case 1: {
                    if (".project".equals(stringArray.getName())) break;
                    bl &= this.internalDeleteFile((IFile)stringArray, n, Policy.subMonitorFor(iProgressMonitor, 100 / iResourceArray.length));
                    break;
                }
                case 2: {
                    bl &= this.internalDeleteFolder((IFolder)stringArray, n, Policy.subMonitorFor(iProgressMonitor, 100 / iResourceArray.length));
                }
            }
            ++n2;
        }
        IFileStore iFileStore = this.localManager.getStore(iProject);
        if (!bl) {
            return false;
        }
        try {
            stringArray = iFileStore.childNames(0, null);
        }
        catch (CoreException coreException) {
            stringArray = new String[]{};
        }
        boolean bl2 = BitMask.isSet(n, 1);
        if (!(bl2 || stringArray.length == 1 && ".project".equals(stringArray[0]))) {
            String string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)iProject.getName());
            this.failed(new ResourceStatus(274, iProject.getFullPath(), string));
            return false;
        }
        IResource iResource = iProject.findMember(".project");
        if (iResource == null) {
            IFileStore iFileStore2 = iFileStore.getChild(".project");
            try {
                iFileStore2.delete(0, null);
            }
            catch (CoreException coreException) {
                this.failed(coreException.getStatus());
            }
        } else {
            boolean bl3 = this.internalDeleteFile((IFile)iResource, n, Policy.monitorFor(null));
            if (!bl3) {
                String string = NLS.bind((String)Messages.resources_couldnotDelete, (Object)iResource.getFullPath());
                ResourceStatus resourceStatus = new ResourceStatus(273, iResource.getFullPath(), string);
                this.failed(resourceStatus);
                return false;
            }
        }
        try {
            iFileStore.delete(0, null);
            this.deletedProject(iProject);
            return true;
        }
        catch (CoreException coreException) {
            String string = NLS.bind((String)Messages.resources_couldnotDelete, (Object)iFileStore.toString());
            ResourceStatus resourceStatus = new ResourceStatus(273, iProject.getFullPath(), string, coreException);
            this.failed(resourceStatus);
            return false;
        }
    }

    private boolean isContentChange(IProject iProject, IProjectDescription iProjectDescription) {
        ProjectDescription projectDescription = ((Project)iProject).internalGetDescription();
        URI uRI = projectDescription.getLocationURI();
        URI uRI2 = iProjectDescription.getLocationURI();
        if (uRI == null || uRI2 == null) {
            return true;
        }
        return !uRI.equals(uRI2);
    }

    private boolean isNameChange(IProject iProject, IProjectDescription iProjectDescription) {
        return !iProject.getName().equals(iProjectDescription.getName());
    }

    private void safeRefresh(IResource iResource) {
        try {
            iResource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            ResourceStatus resourceStatus = new ResourceStatus(4, 273, iResource.getFullPath(), Messages.refresh_refreshErr, coreException);
            this.failed(resourceStatus);
        }
    }

    public boolean isSynchronized(IResource iResource, int n) {
        try {
            this.lock.acquire();
            boolean bl = this.localManager.isSynchronized(iResource, n);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    void makeInvalid() {
        this.isValid = false;
    }

    public void movedFile(IFile iFile, IFile iFile2) {
        Assert.isLegal((boolean)this.isValid);
        try {
            ResourceStatus resourceStatus;
            Object object;
            Object object2;
            Object object3;
            this.lock.acquire();
            if (!iFile.exists()) {
                return;
            }
            if (iFile2.exists()) {
                object3 = NLS.bind((String)Messages.resources_mustNotExist, (Object)iFile2.getFullPath());
                object2 = new ResourceStatus(4, iFile2.getFullPath(), (String)object3);
                this.failed((IStatus)object2);
            }
            object3 = ((Resource)((Object)iFile)).getPropertyManager();
            try {
                object3.copy(iFile, iFile2, 0);
                object3.deleteProperties(iFile, 0);
            }
            catch (CoreException coreException) {
                String string = NLS.bind((String)Messages.resources_errorPropertiesMove, (Object)iFile.getFullPath(), (Object)iFile2.getFullPath());
                object = new ResourceStatus(4, iFile.getFullPath(), string, coreException);
                this.failed((IStatus)object);
            }
            object2 = (Workspace)iFile.getWorkspace();
            try {
                ((Workspace)object2).move((Resource)((Object)iFile), iFile2.getFullPath(), 0, this.updateFlags, false);
            }
            catch (CoreException coreException) {
                object = NLS.bind((String)Messages.resources_errorMoving, (Object)iFile.getFullPath(), (Object)iFile2.getFullPath());
                resourceStatus = new ResourceStatus(4, iFile.getFullPath(), (String)object, coreException);
                this.failed(resourceStatus);
            }
            try {
                ((Workspace)object2).getMarkerManager().moved(iFile, iFile2, 0);
            }
            catch (CoreException coreException) {
                object = NLS.bind((String)Messages.resources_errorMarkersDelete, (Object)iFile.getFullPath());
                resourceStatus = new ResourceStatus(4, iFile.getFullPath(), (String)object, coreException);
                this.failed(resourceStatus);
            }
            this.copyLocalHistory(iFile, iFile2);
        }
        finally {
            this.lock.release();
        }
    }

    public void movedFolderSubtree(IFolder iFolder, IFolder iFolder2) {
        Assert.isLegal((boolean)this.isValid);
        try {
            ResourceStatus resourceStatus;
            Object object;
            this.lock.acquire();
            if (!iFolder.exists()) {
                return;
            }
            if (iFolder2.exists()) {
                String string = NLS.bind((String)Messages.resources_mustNotExist, (Object)iFolder2.getFullPath());
                ResourceStatus resourceStatus2 = new ResourceStatus(4, iFolder2.getFullPath(), string);
                this.failed(resourceStatus2);
                return;
            }
            int n = 2;
            IPropertyManager iPropertyManager = ((Resource)((Object)iFolder)).getPropertyManager();
            try {
                iPropertyManager.copy(iFolder, iFolder2, n);
                iPropertyManager.deleteProperties(iFolder, n);
            }
            catch (CoreException coreException) {
                String string = NLS.bind((String)Messages.resources_errorPropertiesMove, (Object)iFolder.getFullPath(), (Object)iFolder2.getFullPath());
                object = new ResourceStatus(4, iFolder.getFullPath(), string, coreException);
                this.failed((IStatus)object);
            }
            Workspace workspace = (Workspace)iFolder.getWorkspace();
            try {
                workspace.move((Resource)((Object)iFolder), iFolder2.getFullPath(), n, this.updateFlags, false);
            }
            catch (CoreException coreException) {
                object = NLS.bind((String)Messages.resources_errorMoving, (Object)iFolder.getFullPath(), (Object)iFolder2.getFullPath());
                resourceStatus = new ResourceStatus(4, iFolder.getFullPath(), (String)object, coreException);
                this.failed(resourceStatus);
            }
            try {
                workspace.getMarkerManager().moved(iFolder, iFolder2, n);
            }
            catch (CoreException coreException) {
                object = NLS.bind((String)Messages.resources_errorMarkersDelete, (Object)iFolder.getFullPath());
                resourceStatus = new ResourceStatus(4, iFolder.getFullPath(), (String)object, coreException);
                this.failed(resourceStatus);
            }
            this.copyLocalHistory(iFolder, iFolder2);
        }
        finally {
            this.lock.release();
        }
    }

    public boolean movedProjectSubtree(IProject iProject, IProjectDescription iProjectDescription) {
        Assert.isLegal((boolean)this.isValid);
        try {
            ResourceStatus resourceStatus;
            String string;
            this.lock.acquire();
            if (!iProject.exists()) {
                return true;
            }
            Project project = (Project)iProject;
            Project project2 = (Project)project.getWorkspace().getRoot().getProject(iProjectDescription.getName());
            Workspace workspace = (Workspace)project.getWorkspace();
            int n = 2;
            if (this.isNameChange(project, iProjectDescription)) {
                ResourceStatus resourceStatus2;
                String string2;
                if (project2.exists()) {
                    String string3 = NLS.bind((String)Messages.resources_mustNotExist, (Object)project2.getFullPath());
                    ResourceStatus resourceStatus3 = new ResourceStatus(4, project2.getFullPath(), string3);
                    this.failed(resourceStatus3);
                    return false;
                }
                try {
                    project.getPropertyManager().closePropertyStore(project);
                    this.localManager.getHistoryStore().closeHistoryStore(project);
                }
                catch (CoreException coreException) {
                    string = NLS.bind((String)Messages.properties_couldNotClose, (Object)project.getFullPath());
                    resourceStatus = new ResourceStatus(4, project.getFullPath(), string, coreException);
                    this.failed(resourceStatus);
                }
                IFileSystem iFileSystem = EFS.getLocalFileSystem();
                string = iFileSystem.getStore(workspace.getMetaArea().locationFor(project));
                resourceStatus = iFileSystem.getStore(workspace.getMetaArea().locationFor(project2));
                try {
                    string.move((IFileStore)resourceStatus, 0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    string2 = NLS.bind((String)Messages.resources_moveMeta, (Object)string, (Object)resourceStatus);
                    resourceStatus2 = new ResourceStatus(568, project2.getFullPath(), string2, coreException);
                    this.failed(resourceStatus2);
                }
                try {
                    workspace.move(project, project2.getFullPath(), n, this.updateFlags, true);
                }
                catch (CoreException coreException) {
                    string2 = NLS.bind((String)Messages.resources_errorMoving, (Object)project.getFullPath(), (Object)project2.getFullPath());
                    resourceStatus2 = new ResourceStatus(4, project.getFullPath(), string2, coreException);
                    this.failed(resourceStatus2);
                }
                ((ProjectInfo)project2.getResourceInfo(false, true)).fixupAfterMove();
                try {
                    workspace.getMarkerManager().moved(project, project2, n);
                }
                catch (CoreException coreException) {
                    string2 = NLS.bind((String)Messages.resources_errorMarkersMove, (Object)project.getFullPath(), (Object)project2.getFullPath());
                    resourceStatus2 = new ResourceStatus(4, project.getFullPath(), string2, coreException);
                    this.failed(resourceStatus2);
                }
                this.copyLocalHistory(project, project2);
            }
            try {
                ((ProjectDescription)iProjectDescription).setLinkDescriptions(project2.internalGetDescription().getLinks());
                ((ProjectDescription)iProjectDescription).setFilterDescriptions(project2.internalGetDescription().getFilters());
                ((ProjectDescription)iProjectDescription).setVariableDescriptions(project2.internalGetDescription().getVariables());
                project2.internalSetDescription(iProjectDescription, true);
                project2.writeDescription(1);
            }
            catch (CoreException coreException) {
                string = Messages.resources_projectDesc;
                resourceStatus = new ResourceStatus(4, project2.getFullPath(), string, coreException);
                this.failed(resourceStatus);
            }
            try {
                workspace.getMetaArea().writePrivateDescription(project2);
            }
            catch (CoreException coreException) {
                this.failed(coreException.getStatus());
            }
            try {
                project2.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                string = NLS.bind((String)Messages.resources_errorRefresh, (Object)project2.getFullPath());
                resourceStatus = new ResourceStatus(4, project2.getFullPath(), string, coreException);
                this.failed(resourceStatus);
                this.lock.release();
                return false;
            }
            return true;
        }
        finally {
            this.lock.release();
        }
    }

    private void moveProjectContent(IProject iProject, IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            boolean bl;
            String string = NLS.bind((String)Messages.resources_moving, (Object)iProject.getFullPath());
            iProgressMonitor.beginTask(string, 10);
            IProjectDescription iProjectDescription = iProject.getDescription();
            URI uRI = iProjectDescription.getLocationURI();
            if (uRI != null && URIUtil.equals((URI)uRI, (URI)iFileStore.toURI())) {
                return;
            }
            boolean bl2 = bl = (n & 0x100) != 0;
            if (bl) {
                iFileStore.mkdir(0, Policy.subMonitorFor(iProgressMonitor, 10));
                return;
            }
            this.localManager.move(iProject, iFileStore, n, Policy.subMonitorFor(iProgressMonitor, 9));
            if ((n & 0x20) == 0) {
                IResource[] iResourceArray = iProject.members();
                int n2 = 0;
                while (n2 < iResourceArray.length) {
                    if (iResourceArray[n2].isLinked()) {
                        string = NLS.bind((String)Messages.resources_moving, (Object)iResourceArray[n2].getFullPath());
                        iProgressMonitor.subTask(string);
                        IFileStore iFileStore2 = iFileStore.getChild(iResourceArray[n2].getName());
                        try {
                            this.localManager.move(iResourceArray[n2], iFileStore2, n, Policy.monitorFor(null));
                        }
                        catch (CoreException coreException) {
                            this.failed(coreException.getStatus());
                        }
                    }
                    ++n2;
                }
            }
            iProgressMonitor.worked(1);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void standardDeleteFile(IFile iFile, int n, IProgressMonitor iProgressMonitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            this.internalDeleteFile(iFile, n, iProgressMonitor);
        }
        finally {
            this.lock.release();
        }
    }

    public void standardDeleteFolder(IFolder iFolder, int n, IProgressMonitor iProgressMonitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            try {
                this.lock.acquire();
                this.internalDeleteFolder(iFolder, n, iProgressMonitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.safeRefresh(iFolder);
                throw operationCanceledException;
            }
        }
        finally {
            this.lock.release();
            iProgressMonitor.done();
        }
    }

    public void standardDeleteProject(IProject iProject, int n, IProgressMonitor iProgressMonitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            Object object;
            this.lock.acquire();
            String string = NLS.bind((String)Messages.resources_deleting, (Object)iProject.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            if (!iProject.exists()) {
                return;
            }
            boolean bl = (n & 4) != 0;
            boolean bl2 = (n & 8) != 0;
            boolean bl3 = true;
            if (bl || iProject.isOpen() && !bl2) {
                if (bl || this.isSynchronized(iProject, 2)) {
                    n |= 1;
                }
                if (iProject.isOpen()) {
                    bl3 = this.internalDeleteProject(iProject, n, iProgressMonitor);
                    if (!bl3) {
                        IFileStore iFileStore = this.localManager.getStore(iProject);
                        string = NLS.bind((String)Messages.resources_couldnotDelete, (Object)iFileStore.toString());
                        ResourceStatus resourceStatus = new ResourceStatus(273, iProject.getFullPath(), string);
                        this.failed(resourceStatus);
                    }
                    return;
                }
                try {
                    object = this.localManager.getStore(iProject);
                    IFileStore[] iFileStoreArray = object.childStores(0, null);
                    int n2 = 0;
                    while (n2 < iFileStoreArray.length) {
                        if (!".project".equals(iFileStoreArray[n2].getName())) {
                            iFileStoreArray[n2].delete(0, Policy.subMonitorFor(iProgressMonitor, 87 / iFileStoreArray.length));
                        }
                        ++n2;
                    }
                    object.delete(0, Policy.subMonitorFor(iProgressMonitor, 87 / (iFileStoreArray.length > 0 ? iFileStoreArray.length : 1)));
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.safeRefresh(iProject);
                    throw operationCanceledException;
                }
                catch (CoreException coreException) {
                    string = NLS.bind((String)Messages.localstore_couldnotDelete, (Object)iProject.getFullPath());
                    ResourceStatus resourceStatus = new ResourceStatus(4, 273, iProject.getFullPath(), string, coreException);
                    this.failed(resourceStatus);
                    this.lock.release();
                    iProgressMonitor.done();
                    return;
                }
            }
            if (bl3) {
                this.deletedProject(iProject);
            } else {
                string = NLS.bind((String)Messages.localstore_couldnotDelete, (Object)iProject.getFullPath());
                object = new ResourceStatus(273, iProject.getFullPath(), string);
                this.failed((IStatus)object);
            }
        }
        finally {
            this.lock.release();
            iProgressMonitor.done();
        }
    }

    public void standardMoveFile(IFile iFile, IFile iFile2, int n, IProgressMonitor iProgressMonitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            boolean bl;
            block15: {
                boolean bl2;
                this.lock.acquire();
                String string = NLS.bind((String)Messages.resources_moving, (Object)iFile.getFullPath());
                iProgressMonitor.subTask(string);
                if (!iFile.exists() || iFile2.exists() || !iFile2.getParent().isAccessible()) {
                    throw new IllegalArgumentException();
                }
                boolean bl3 = (n & 1) != 0;
                boolean bl4 = (n & 2) != 0;
                boolean bl5 = bl2 = (n & 0x20) == 0;
                if (!bl3 && !this.isSynchronized(iFile, 2)) {
                    string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)iFile.getFullPath());
                    ResourceStatus resourceStatus = new ResourceStatus(274, iFile.getFullPath(), string);
                    this.failed(resourceStatus);
                    return;
                }
                iProgressMonitor.worked(25);
                if (bl4) {
                    this.addToLocalHistory(iFile);
                }
                iProgressMonitor.worked(25);
                if (!bl2 && iFile.isLinked()) {
                    this.movedFile(iFile, iFile2);
                    return;
                }
                IFileStore iFileStore = null;
                bl = false;
                try {
                    iFileStore = this.localManager.getStore(iFile2);
                    iFileStore.getParent().mkdir(0, Policy.subMonitorFor(iProgressMonitor, 0));
                    this.localManager.move(iFile, iFileStore, n, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    this.failed(coreException.getStatus());
                    boolean bl6 = bl = iFileStore != null && iFileStore.fetchInfo().exists();
                    if (bl) break block15;
                    this.lock.release();
                    iProgressMonitor.done();
                    return;
                }
            }
            this.movedFile(iFile, iFile2);
            this.updateMovedFileTimestamp(iFile2, this.internalComputeTimestamp(iFile2));
            if (bl) {
                try {
                    iFile.refreshLocal(2, null);
                }
                catch (CoreException coreException) {}
            }
            iProgressMonitor.worked(25);
            return;
        }
        finally {
            this.lock.release();
            iProgressMonitor.done();
        }
    }

    public void standardMoveFolder(IFolder iFolder, IFolder iFolder2, int n, IProgressMonitor iProgressMonitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            boolean bl;
            boolean bl2;
            block14: {
                boolean bl3;
                this.lock.acquire();
                String string = NLS.bind((String)Messages.resources_moving, (Object)iFolder.getFullPath());
                iProgressMonitor.beginTask(string, 100);
                if (!iFolder.exists() || iFolder2.exists() || !iFolder2.getParent().isAccessible()) {
                    throw new IllegalArgumentException();
                }
                boolean bl4 = bl3 = (n & 1) != 0;
                if (!bl3 && !this.isSynchronized(iFolder, 2)) {
                    string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)iFolder.getFullPath());
                    ResourceStatus resourceStatus = new ResourceStatus(4, iFolder.getFullPath(), string);
                    this.failed(resourceStatus);
                    return;
                }
                iProgressMonitor.worked(20);
                boolean bl5 = bl2 = (n & 0x20) == 0;
                if (!bl2 && (iFolder.isLinked() || iFolder.isGroup())) {
                    this.movedFolderSubtree(iFolder, iFolder2);
                    return;
                }
                IFileStore iFileStore = null;
                bl = false;
                try {
                    iFileStore = this.localManager.getStore(iFolder2);
                    this.localManager.move(iFolder, iFileStore, n, Policy.subMonitorFor(iProgressMonitor, 60));
                }
                catch (CoreException coreException) {
                    this.failed(coreException.getStatus());
                    boolean bl6 = bl = iFileStore != null && iFileStore.fetchInfo().exists();
                    if (bl) break block14;
                    this.lock.release();
                    iProgressMonitor.done();
                    return;
                }
            }
            this.movedFolderSubtree(iFolder, iFolder2);
            iProgressMonitor.worked(20);
            this.updateTimestamps(iFolder2, bl2);
            if (bl) {
                try {
                    iFolder.refreshLocal(2, null);
                    iFolder2.refreshLocal(2, null);
                }
                catch (CoreException coreException) {}
            }
        }
        finally {
            this.lock.release();
            iProgressMonitor.done();
        }
    }

    public void standardMoveProject(IProject iProject, IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) {
        Assert.isLegal((boolean)this.isValid);
        try {
            boolean bl;
            this.lock.acquire();
            String string = NLS.bind((String)Messages.resources_moving, (Object)iProject.getFullPath());
            iProgressMonitor.beginTask(string, 100);
            if (!iProject.isAccessible()) {
                throw new IllegalArgumentException();
            }
            if (!this.isContentChange(iProject, iProjectDescription)) {
                this.movedProjectSubtree(iProject, iProjectDescription);
                return;
            }
            boolean bl2 = bl = (n & 1) != 0;
            if (!bl && !this.isSynchronized(iProject, 2)) {
                string = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)iProject.getFullPath());
                ResourceStatus resourceStatus = new ResourceStatus(274, iProject.getFullPath(), string);
                this.failed(resourceStatus);
                return;
            }
            IFileStore iFileStore = this.computeDestinationStore(iProjectDescription);
            if ((n & 0x100) == 0 && !this.ensureDestinationEmpty(iProject, iFileStore, iProgressMonitor)) {
                return;
            }
            try {
                this.moveProjectContent(iProject, iFileStore, n, Policy.subMonitorFor(iProgressMonitor, 75));
            }
            catch (CoreException coreException) {
                string = NLS.bind((String)Messages.localstore_couldNotMove, (Object)iProject.getFullPath());
                ResourceStatus resourceStatus = new ResourceStatus(4, iProject.getFullPath(), string, coreException);
                this.failed(resourceStatus);
                try {
                    iProject.refreshLocal(2, null);
                }
                catch (CoreException coreException2) {}
            }
            this.movedProjectSubtree(iProject, iProjectDescription);
            iProgressMonitor.worked(12);
            boolean bl3 = (n & 0x20) == 0;
            this.updateTimestamps(iProject.getWorkspace().getRoot().getProject(iProjectDescription.getName()), bl3);
            iProgressMonitor.worked(12);
        }
        finally {
            this.lock.release();
            iProgressMonitor.done();
        }
    }

    public void updateMovedFileTimestamp(IFile iFile, long l) {
        Assert.isLegal((boolean)this.isValid);
        try {
            this.lock.acquire();
            if (!iFile.exists()) {
                return;
            }
            ResourceInfo resourceInfo = ((Resource)((Object)iFile)).getResourceInfo(false, true);
            this.localManager.updateLocalSync(resourceInfo, l);
            resourceInfo.clear(65536);
        }
        finally {
            this.lock.release();
        }
    }

    private void updateTimestamps(IResource iResource, final boolean bl) {
        IResourceVisitor iResourceVisitor = new IResourceVisitor(){

            public boolean visit(IResource iResource) {
                if (iResource.isLinked()) {
                    if (bl && !((Resource)iResource).isUnderGroup()) {
                        ResourceInfo resourceInfo = ((Resource)iResource).getResourceInfo(false, true);
                        resourceInfo.clear(65536);
                    }
                    return true;
                }
                return true;
            }
        };
        try {
            iResource.accept(iResourceVisitor, 2, 10);
        }
        catch (CoreException coreException) {}
    }
}

