/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.HistoryStore2;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.properties.PropertyManager2;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class ResourcesCompatibilityHelper {
    private static final String COMPATIBILITY_CLASS = "org.eclipse.core.internal.resources.ResourcesCompatibility";
    private static final String CONVERT_HISTORY_STORE = "org.eclipse.core.resources.convertHistory";
    private static final String CONVERT_PROPERTY_STORE = "org.eclipse.core.resources.convertProperties";
    private static final String ENABLE_NEW_HISTORY_STORE = "org.eclipse.core.resources.newHistory";
    private static final String ENABLE_NEW_PROPERTY_STORE = "org.eclipse.core.resources.newProperties";
    static /* synthetic */ Class class$0;

    public static IHistoryStore createHistoryStore(IPath iPath, int n) {
        boolean bl = !Boolean.FALSE.toString().equalsIgnoreCase(System.getProperty(ENABLE_NEW_HISTORY_STORE));
        boolean bl2 = !Boolean.FALSE.toString().equalsIgnoreCase(System.getProperty(CONVERT_HISTORY_STORE));
        try {
            return ResourcesCompatibilityHelper.createHistoryStore(iPath, n, bl, bl2, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Workspace.DEBUG) {
                noSuchMethodException.printStackTrace();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            if (Workspace.DEBUG) {
                illegalAccessException.printStackTrace();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iPath);
        return new HistoryStore2((Workspace)ResourcesPlugin.getWorkspace(), iFileStore, n);
    }

    public static IHistoryStore createHistoryStore(IPath iPath, int n, boolean bl, boolean bl2, boolean bl3) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(COMPATIBILITY_CLASS);
        Class[] classArray = new Class[5];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.runtime.IPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        classArray[1] = Integer.TYPE;
        classArray[2] = Boolean.TYPE;
        classArray[3] = Boolean.TYPE;
        classArray[4] = Boolean.TYPE;
        Method method = clazz.getDeclaredMethod("createHistoryStore", classArray);
        return (IHistoryStore)method.invoke(null, iPath, new Integer(n), bl, bl2, bl3);
    }

    public static IPropertyManager createPropertyManager(boolean bl, boolean bl2) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(COMPATIBILITY_CLASS);
        Method method = clazz.getDeclaredMethod("createPropertyManager", Boolean.TYPE, Boolean.TYPE);
        return (IPropertyManager)method.invoke(null, bl, bl2);
    }

    public static IPropertyManager createPropertyManager() {
        boolean bl = !Boolean.FALSE.toString().equalsIgnoreCase(System.getProperty(ENABLE_NEW_PROPERTY_STORE));
        boolean bl2 = !Boolean.FALSE.toString().equalsIgnoreCase(System.getProperty(CONVERT_PROPERTY_STORE));
        try {
            return ResourcesCompatibilityHelper.createPropertyManager(bl, bl2);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Workspace.DEBUG) {
                noSuchMethodException.printStackTrace();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            if (Workspace.DEBUG) {
                illegalAccessException.printStackTrace();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        return new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
    }
}

