/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.resources.team.TeamHook;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

class Rules
implements IResourceRuleFactory,
ILifecycleListener {
    private final ResourceRuleFactory defaultFactory = new ResourceRuleFactory(){};
    private final Map projectsToRules = Collections.synchronizedMap(new HashMap());
    private final TeamHook teamHook;
    private final IWorkspaceRoot root;

    Rules(Workspace workspace) {
        this.root = workspace.getRoot();
        this.teamHook = workspace.getTeamHook();
        workspace.addLifecycleListener(this);
    }

    public ISchedulingRule buildRule() {
        return this.root;
    }

    public ISchedulingRule copyRule(IResource iResource, IResource iResource2) {
        if (iResource.getType() == 8 || iResource2.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(iResource2).copyRule(iResource, iResource2);
    }

    public ISchedulingRule createRule(IResource iResource) {
        if (iResource.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(iResource).createRule(iResource);
    }

    public ISchedulingRule deleteRule(IResource iResource) {
        if (iResource.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(iResource).deleteRule(iResource);
    }

    private IResourceRuleFactory factoryFor(IResource iResource) {
        IResourceRuleFactory iResourceRuleFactory = (IResourceRuleFactory)this.projectsToRules.get(iResource.getFullPath().segment(0));
        if (iResourceRuleFactory == null) {
            if (!iResource.getProject().isAccessible()) {
                return this.defaultFactory;
            }
            iResourceRuleFactory = this.teamHook.getRuleFactory(iResource.getProject());
            this.projectsToRules.put(iResource.getFullPath().segment(0), iResourceRuleFactory);
        }
        return iResourceRuleFactory;
    }

    public void handleEvent(LifecycleEvent lifecycleEvent) {
        switch (lifecycleEvent.kind) {
            case 1: 
            case 16: 
            case 64: {
                this.setRuleFactory((IProject)lifecycleEvent.resource, null);
            }
        }
    }

    public ISchedulingRule charsetRule(IResource iResource) {
        if (iResource.getType() == 8) {
            return null;
        }
        return this.factoryFor(iResource).charsetRule(iResource);
    }

    public ISchedulingRule markerRule(IResource iResource) {
        return null;
    }

    public ISchedulingRule modifyRule(IResource iResource) {
        if (iResource.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(iResource).modifyRule(iResource);
    }

    public ISchedulingRule moveRule(IResource iResource, IResource iResource2) {
        if (iResource.getType() == 8 || iResource2.getType() == 8) {
            return this.root;
        }
        if (!iResource.getFullPath().segment(0).equals(iResource2.getFullPath().segment(0))) {
            return MultiRule.combine((ISchedulingRule)this.modifyRule(iResource.getProject()), (ISchedulingRule)this.modifyRule(iResource2.getProject()));
        }
        return this.factoryFor(iResource).moveRule(iResource, iResource2);
    }

    public ISchedulingRule refreshRule(IResource iResource) {
        if (iResource.getType() == 8) {
            return this.root;
        }
        return this.factoryFor(iResource).refreshRule(iResource);
    }

    void setRuleFactory(IProject iProject, IResourceRuleFactory iResourceRuleFactory) {
        if (iResourceRuleFactory == null) {
            this.projectsToRules.remove(iProject.getName());
        } else {
            this.projectsToRules.put(iProject.getName(), iResourceRuleFactory);
        }
    }

    public ISchedulingRule validateEditRule(IResource[] iResourceArray) {
        if (iResourceArray.length == 0) {
            return null;
        }
        if (iResourceArray.length == 1) {
            if (iResourceArray[0].getType() == 8) {
                return this.root;
            }
            return this.factoryFor(iResourceArray[0]).validateEditRule(iResourceArray);
        }
        HashSet<ISchedulingRule> hashSet = new HashSet<ISchedulingRule>();
        IResource[] iResourceArray2 = new IResource[1];
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n].getType() == 8) {
                return this.root;
            }
            iResourceArray2[0] = iResourceArray[n];
            ISchedulingRule iSchedulingRule = this.factoryFor(iResourceArray[n]).validateEditRule(iResourceArray2);
            if (iSchedulingRule != null) {
                hashSet.add(iSchedulingRule);
            }
            ++n;
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        if (hashSet.size() == 1) {
            return (ISchedulingRule)hashSet.iterator().next();
        }
        ISchedulingRule[] iSchedulingRuleArray = hashSet.toArray(new ISchedulingRule[hashSet.size()]);
        return new MultiRule(iSchedulingRuleArray);
    }
}

