/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SafeFileTable {
    protected IPath location;
    protected Properties table;

    public SafeFileTable(String string) throws CoreException {
        this.location = this.getWorkspace().getMetaArea().getSafeTableLocationFor(string);
        this.restore();
    }

    public IPath[] getFiles() {
        Set<Object> set = this.table.keySet();
        String[] stringArray = set.toArray(new String[set.size()]);
        IPath[] iPathArray = new IPath[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            iPathArray[n] = new Path(stringArray[n]);
            ++n;
        }
        return iPathArray;
    }

    protected Workspace getWorkspace() {
        return (Workspace)ResourcesPlugin.getWorkspace();
    }

    public IPath lookup(IPath iPath) {
        String string = this.table.getProperty(iPath.toOSString());
        return string == null ? null : new Path(string);
    }

    public void map(IPath iPath, IPath iPath2) {
        if (iPath2 == null) {
            this.table.remove(iPath);
        } else {
            this.table.setProperty(iPath.toOSString(), iPath2.toOSString());
        }
    }

    public void restore() throws CoreException {
        File file = this.location.toFile();
        this.table = new Properties();
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.table.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            String string = Messages.resources_exSafeRead;
            throw new ResourceException(566, null, string, iOException);
        }
    }

    public void save() throws CoreException {
        File file = this.location.toFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                this.table.store(fileOutputStream, "safe table");
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            String string = Messages.resources_exSafeSave;
            throw new ResourceException(566, null, string, iOException);
        }
    }

    public void setLocation(IPath iPath) {
        if (iPath != null) {
            this.location = iPath;
        }
    }
}

