/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.SafeFileTable;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class SaveContext
implements ISaveContext {
    protected Plugin plugin;
    protected int kind;
    protected boolean needDelta;
    protected boolean needSaveNumber;
    protected SafeFileTable fileTable;
    protected int previousSaveNumber;
    protected IProject project;

    protected SaveContext(Plugin plugin, int n, IProject iProject) throws CoreException {
        this.plugin = plugin;
        this.kind = n;
        this.project = iProject;
        this.needDelta = false;
        this.needSaveNumber = false;
        String string = plugin.getBundle().getSymbolicName();
        this.fileTable = new SafeFileTable(string);
        this.previousSaveNumber = this.getWorkspace().getSaveManager().getSaveNumber(string);
    }

    public void commit() throws CoreException {
        if (this.needSaveNumber) {
            String string = this.plugin.getBundle().getSymbolicName();
            IPath iPath = this.getWorkspace().getMetaArea().getSafeTableLocationFor(string);
            this.getWorkspace().getSaveManager().setSaveNumber(string, this.getSaveNumber());
            this.fileTable.setLocation(this.getWorkspace().getMetaArea().getSafeTableLocationFor(string));
            this.fileTable.save();
            iPath.toFile().delete();
        }
    }

    public IPath[] getFiles() {
        return this.getFileTable().getFiles();
    }

    protected SafeFileTable getFileTable() {
        return this.fileTable;
    }

    public int getKind() {
        return this.kind;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public int getPreviousSaveNumber() {
        return this.previousSaveNumber;
    }

    public IProject getProject() {
        return this.project;
    }

    public int getSaveNumber() {
        int n = this.getPreviousSaveNumber() + 1;
        return n > 0 ? n : 1;
    }

    protected Workspace getWorkspace() {
        return (Workspace)ResourcesPlugin.getWorkspace();
    }

    public boolean isDeltaNeeded() {
        return this.needDelta;
    }

    public IPath lookup(IPath iPath) {
        return this.getFileTable().lookup(iPath);
    }

    public void map(IPath iPath, IPath iPath2) {
        this.getFileTable().map(iPath, iPath2);
    }

    public void needDelta() {
        this.needDelta = true;
    }

    public void needSaveNumber() {
        this.needSaveNumber = true;
    }
}

