/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceStats;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.localstore.SafeFileOutputStream;
import org.eclipse.core.internal.resources.DelayedSnapshotJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.SaveContext;
import org.eclipse.core.internal.resources.SavedState;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceTreeReader;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.ElementTreeWriter;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SaveManager
implements IElementInfoFlattener,
IManager,
IStringPoolParticipant {
    protected static final String CLEAR_DELTA_PREFIX = "clearDelta_";
    protected static final String DELTA_EXPIRATION_PREFIX = "deltaExpiration_";
    protected static final int DONE_SAVING = 3;
    private static final long MIN_SNAPSHOT_DELAY = 30000L;
    protected static final int NO_OP_THRESHOLD = 20;
    protected static final int PREPARE_TO_SAVE = 1;
    protected static final int ROLLBACK = 4;
    protected static final String SAVE_NUMBER_PREFIX = "saveNumber_";
    protected static final int SAVING = 2;
    protected ElementTree lastSnap;
    protected Properties masterTable;
    private boolean isSaving = false;
    protected int noopCount = 0;
    protected int operationCount = 0;
    protected long persistMarkers = 0L;
    protected long persistSyncInfo = 0L;
    protected Map savedStates;
    protected Map saveParticipants;
    protected final DelayedSnapshotJob snapshotJob;
    protected boolean snapshotRequested;
    protected Workspace workspace;
    private static final String DEBUG_START = " starting...";
    private static final String DEBUG_FULL_SAVE = "Full save on workspace: ";
    private static final String DEBUG_PROJECT_SAVE = "Save on project ";
    private static final String DEBUG_SNAPSHOT = "Snapshot: ";
    private static final int TREE_BUFFER_SIZE = 65536;

    public SaveManager(Workspace workspace) {
        this.workspace = workspace;
        this.snapshotJob = new DelayedSnapshotJob(this);
        this.snapshotRequested = false;
        this.saveParticipants = Collections.synchronizedMap(new HashMap(10));
    }

    public ISavedState addParticipant(Plugin plugin, ISaveParticipant iSaveParticipant) throws CoreException {
        if (this.saveParticipants.put(plugin, iSaveParticipant) != null) {
            return null;
        }
        String string = plugin.getBundle().getSymbolicName();
        SavedState savedState = (SavedState)this.savedStates.get(string);
        if (savedState != null) {
            if (this.isDeltaCleared(string)) {
                savedState.forgetTrees();
                this.removeClearDeltaMarks(string);
            } else {
                try {
                    this.workspace.prepareOperation(null, null);
                    this.workspace.beginOperation(true);
                    savedState.newTree = this.workspace.getElementTree();
                }
                finally {
                    this.workspace.endOperation(null, false, null);
                }
                return savedState;
            }
        }
        if (this.getSaveNumber(string) > 0) {
            return new SavedState(this.workspace, string, null, null);
        }
        return null;
    }

    protected void broadcastLifecycle(final int n, Map map, final MultiStatus multiStatus, IProgressMonitor iProgressMonitor) {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", map.size());
            final Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Plugin plugin = (Plugin)entry.getKey();
                final ISaveParticipant iSaveParticipant = (ISaveParticipant)this.saveParticipants.get(plugin);
                if (iSaveParticipant == null) {
                    iProgressMonitor.worked(1);
                    continue;
                }
                final SaveContext saveContext = (SaveContext)entry.getValue();
                ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                    public void handleException(Throwable throwable) {
                        String string = Messages.resources_saveProblem;
                        Status status = new Status(2, "org.eclipse.core.resources", 566, string, throwable);
                        multiStatus.add((IStatus)status);
                        iterator.remove();
                    }

                    public void run() throws Exception {
                        SaveManager.this.executeLifecycle(n, iSaveParticipant, saveContext);
                    }
                };
                SafeRunner.run((ISafeRunnable)iSafeRunnable);
                iProgressMonitor.worked(1);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void clearDeltaExpiration(String string) {
        this.masterTable.remove(DELTA_EXPIRATION_PREFIX + string);
    }

    protected void cleanMasterTable() {
        String string;
        IPath iPath = this.masterTable.keySet().iterator();
        while (iPath.hasNext()) {
            IProject iProject;
            String string2;
            string = (String)iPath.next();
            if (!string.endsWith(".tree") || (string2 = string.substring(0, string.length() - ".tree".length())).equals(Path.ROOT.toString()) || (iProject = this.workspace.getRoot().getProject(string2)).exists() && !iProject.isOpen()) continue;
            iPath.remove();
        }
        iPath = this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources");
        string = this.workspace.getMetaArea().getBackupLocationFor(iPath);
        try {
            this.saveMasterTable((IPath)string);
        }
        catch (CoreException coreException) {
            Policy.log(coreException.getStatus());
            string.toFile().delete();
            return;
        }
        if (iPath.toFile().exists() && !iPath.toFile().delete()) {
            return;
        }
        try {
            this.saveMasterTable(iPath);
        }
        catch (CoreException coreException) {
            Policy.log(coreException.getStatus());
            iPath.toFile().delete();
            return;
        }
        string.toFile().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSavedDelta() {
        Map map = this.saveParticipants;
        synchronized (map) {
            Iterator iterator = this.saveParticipants.keySet().iterator();
            while (iterator.hasNext()) {
                String string = ((Plugin)iterator.next()).getBundle().getSymbolicName();
                this.masterTable.setProperty(CLEAR_DELTA_PREFIX + string, "true");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collapseTrees() throws CoreException {
        ArrayList<ElementTree> arrayList = new ArrayList<ElementTree>();
        IProject[] iProjectArray = this.savedStates;
        synchronized (this.savedStates) {
            Object object;
            Iterator iterator = this.savedStates.values().iterator();
            while (iterator.hasNext()) {
                object = (SavedState)iterator.next();
                if (object.oldTree == null) continue;
                arrayList.add(object.oldTree);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            iProjectArray = this.workspace.getRoot().getProjects(8);
            int n = 0;
            while (n < iProjectArray.length) {
                ArrayList arrayList2;
                object = iProjectArray[n];
                if (object.isOpen() && (arrayList2 = this.workspace.getBuildManager().createBuildersPersistentInfo((IProject)object)) != null) {
                    Iterator iterator2 = arrayList2.iterator();
                    while (iterator2.hasNext()) {
                        BuilderPersistentInfo builderPersistentInfo = (BuilderPersistentInfo)iterator2.next();
                        arrayList.add(builderPersistentInfo.getLastBuiltTree());
                    }
                }
                ++n;
            }
            if (arrayList.isEmpty()) {
                return;
            }
            arrayList.add(this.workspace.getElementTree());
            ElementTree[] elementTreeArray = new ElementTree[arrayList.size()];
            arrayList.toArray(elementTreeArray);
            object = this.sortTrees(elementTreeArray);
            if (object == null) {
                return;
            }
            int n2 = 1;
            while (n2 < ((ElementTree[])object).length) {
                object[n2].collapseTo(object[n2 - 1]);
                ++n2;
            }
            return;
        }
    }

    protected void commit(Map map) throws CoreException {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ((SaveContext)iterator.next()).commit();
        }
    }

    protected Map computeSaveContexts(Plugin[] pluginArray, int n, IProject iProject) {
        HashMap<Plugin, SaveContext> hashMap = new HashMap<Plugin, SaveContext>(pluginArray.length);
        int n2 = 0;
        while (n2 < pluginArray.length) {
            Plugin plugin = pluginArray[n2];
            try {
                SaveContext saveContext = new SaveContext(plugin, n, iProject);
                hashMap.put(plugin, saveContext);
            }
            catch (CoreException coreException) {
                Policy.log(coreException.getStatus());
            }
            ++n2;
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map computeStatesToSave(Map map, ElementTree elementTree) {
        Object object;
        Object object2;
        HashMap<Object, ElementTree> hashMap = new HashMap<Object, ElementTree>(this.savedStates.size() * 2);
        Object object3 = this.savedStates;
        synchronized (object3) {
            object2 = this.savedStates.values().iterator();
            while (object2.hasNext()) {
                object = (SavedState)object2.next();
                if (((SavedState)object).oldTree == null) continue;
                hashMap.put(((SavedState)object).pluginId, ((SavedState)object).oldTree);
            }
        }
        object3 = map.values().iterator();
        while (object3.hasNext()) {
            object2 = (SaveContext)object3.next();
            if (!((SaveContext)object2).isDeltaNeeded()) continue;
            object = ((SaveContext)object2).getPlugin().getBundle().getSymbolicName();
            hashMap.put(object, elementTree);
        }
        return hashMap;
    }

    protected void executeLifecycle(int n, ISaveParticipant iSaveParticipant, SaveContext saveContext) throws CoreException {
        switch (n) {
            case 1: {
                iSaveParticipant.prepareToSave(saveContext);
                break;
            }
            case 2: {
                try {
                    if (ResourceStats.TRACE_SAVE_PARTICIPANTS) {
                        ResourceStats.startSave(iSaveParticipant);
                    }
                    iSaveParticipant.saving(saveContext);
                    break;
                }
                finally {
                    if (ResourceStats.TRACE_SAVE_PARTICIPANTS) {
                        ResourceStats.endSave();
                    }
                }
            }
            case 3: {
                iSaveParticipant.doneSaving(saveContext);
                break;
            }
            case 4: {
                iSaveParticipant.rollback(saveContext);
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)"Invalid save lifecycle code");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetSavedTree(String string) {
        if (string == null) {
            Map map = this.savedStates;
            synchronized (map) {
                Iterator iterator = this.savedStates.values().iterator();
                while (iterator.hasNext()) {
                    ((SavedState)iterator.next()).forgetTrees();
                }
            }
        } else {
            SavedState savedState = (SavedState)this.savedStates.get(string);
            if (savedState != null) {
                savedState.forgetTrees();
            }
        }
    }

    protected long getDeltaExpiration(String string) {
        String string2 = this.masterTable.getProperty(DELTA_EXPIRATION_PREFIX + string);
        return string2 == null ? System.currentTimeMillis() : new Long(string2);
    }

    protected Properties getMasterTable() {
        return this.masterTable;
    }

    public int getSaveNumber(String string) {
        String string2 = this.masterTable.getProperty(SAVE_NUMBER_PREFIX + string);
        return string2 == null ? 0 : new Integer(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Plugin[] getSaveParticipantPlugins() {
        Map map = this.saveParticipants;
        synchronized (map) {
            return this.saveParticipants.keySet().toArray(new Plugin[this.saveParticipants.size()]);
        }
    }

    private void hookEndSave(int n, IProject iProject, long l) {
        if (ResourceStats.TRACE_SNAPSHOT && n == 2) {
            ResourceStats.endSnapshot();
        }
        if (Policy.DEBUG_SAVE) {
            String string = null;
            switch (n) {
                case 1: {
                    string = DEBUG_FULL_SAVE;
                    break;
                }
                case 2: {
                    string = DEBUG_SNAPSHOT;
                    break;
                }
                case 3: {
                    string = DEBUG_PROJECT_SAVE + iProject.getFullPath() + ": ";
                }
            }
            if (string != null) {
                System.out.println(String.valueOf(string) + (System.currentTimeMillis() - l) + "ms");
            }
        }
    }

    private void hookStartSave(int n, Project project) {
        if (ResourceStats.TRACE_SNAPSHOT && n == 2) {
            ResourceStats.startSnapshot();
        }
        if (Policy.DEBUG_SAVE) {
            switch (n) {
                case 1: {
                    System.out.println("Full save on workspace:  starting...");
                    break;
                }
                case 2: {
                    System.out.println("Snapshot:  starting...");
                    break;
                }
                case 3: {
                    System.out.println(DEBUG_PROJECT_SAVE + project.getFullPath() + DEBUG_START);
                }
            }
        }
    }

    protected void initSnap(IProgressMonitor iProgressMonitor) throws CoreException {
        this.snapshotJob.cancel();
        this.lastSnap = this.workspace.getElementTree();
        this.lastSnap.immutable();
        this.workspace.newWorkingTree();
        this.operationCount = 0;
        IPath iPath = this.workspace.getMetaArea().getSnapshotLocationFor(this.workspace.getRoot());
        File file = iPath.toFile();
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            String string = Messages.resources_snapInit;
            throw new ResourceException(569, null, string, null);
        }
    }

    protected boolean isDeltaCleared(String string) {
        String string2 = this.masterTable.getProperty(CLEAR_DELTA_PREFIX + string);
        return string2 != null && string2.equals("true");
    }

    protected boolean isOldPluginTree(String string) {
        if (this.isDeltaCleared(string)) {
            return false;
        }
        if (Platform.getBundle((String)string) == null) {
            return true;
        }
        long l = System.currentTimeMillis() - this.getDeltaExpiration(string);
        return l > this.workspace.internalGetDescription().getDeltaExpiration();
    }

    public Object readElement(IPath iPath, DataInput dataInput) throws IOException {
        Assert.isNotNull((Object)iPath);
        Assert.isNotNull((Object)dataInput);
        int n = dataInput.readInt();
        int n2 = (n & 0xF00) >> 8;
        ResourceInfo resourceInfo = this.workspace.newElement(n2);
        resourceInfo.readFrom(n, dataInput);
        return resourceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClearDeltaMarks() {
        Map map = this.saveParticipants;
        synchronized (map) {
            Iterator iterator = this.saveParticipants.keySet().iterator();
            while (iterator.hasNext()) {
                String string = ((Plugin)iterator.next()).getBundle().getSymbolicName();
                this.removeClearDeltaMarks(string);
            }
        }
    }

    protected void removeClearDeltaMarks(String string) {
        this.masterTable.setProperty(CLEAR_DELTA_PREFIX + string, "false");
    }

    protected void removeFiles(File file, String[] stringArray, List list) {
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = true;
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                if (!string.equals(stringArray[n])) continue;
                listIterator.remove();
                bl = false;
                break;
            }
            if (bl) {
                new File(file, stringArray[n]).delete();
            }
            ++n;
        }
    }

    private void removeGarbage(DataOutputStream dataOutputStream, IPath iPath, IPath iPath2) throws IOException {
        if (dataOutputStream.size() == 0) {
            dataOutputStream.close();
            iPath.toFile().delete();
            iPath2.toFile().delete();
        }
    }

    public void removeParticipant(Plugin plugin) {
        this.saveParticipants.remove(plugin);
    }

    protected void removeUnusedSafeTables() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        IPath iPath = this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources");
        arrayList.add(iPath.lastSegment());
        Object object = this.masterTable.keys();
        while (object.hasMoreElements()) {
            stringArray = (String[])object.nextElement();
            if (!stringArray.startsWith(SAVE_NUMBER_PREFIX)) continue;
            String string = stringArray.substring(SAVE_NUMBER_PREFIX.length());
            arrayList.add(this.workspace.getMetaArea().getSafeTableLocationFor(string).lastSegment());
        }
        object = iPath.toFile().getParentFile();
        stringArray = ((File)object).list();
        if (stringArray == null) {
            return;
        }
        this.removeFiles((File)object, stringArray, arrayList);
    }

    protected void removeUnusedTreeFiles() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        IPath iPath = this.workspace.getMetaArea().getTreeLocationFor(this.workspace.getRoot(), false);
        arrayList.add(iPath.lastSegment());
        File file = iPath.toFile().getParentFile();
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".tree");
            }
        };
        String[] stringArray = file.list(filenameFilter);
        if (stringArray != null) {
            this.removeFiles(file, stringArray, arrayList);
        }
        IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            iPath = this.workspace.getMetaArea().getTreeLocationFor(iProjectArray[n], false);
            arrayList.add(iPath.lastSegment());
            file = iPath.toFile().getParentFile();
            stringArray = file.list(filenameFilter);
            if (stringArray != null) {
                this.removeFiles(file, stringArray, arrayList);
            }
            ++n;
        }
    }

    public void requestSnapshot() {
        this.snapshotRequested = true;
    }

    protected void resetSnapshots(IResource iResource) throws CoreException {
        Assert.isLegal((iResource.getType() == 8 || iResource.getType() == 4 ? 1 : 0) != 0);
        File file = this.workspace.getMetaArea().getMarkersSnapshotLocationFor(iResource).toFile();
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            String string = Messages.resources_resetMarkers;
            throw new ResourceException(569, iResource.getFullPath(), string, null);
        }
        file = this.workspace.getMetaArea().getSyncInfoSnapshotLocationFor(iResource).toFile();
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            String string = Messages.resources_resetSync;
            throw new ResourceException(569, iResource.getFullPath(), string, null);
        }
        if (iResource.getType() == 4) {
            return;
        }
        IProject[] iProjectArray = ((IWorkspaceRoot)iResource).getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            this.resetSnapshots(iProjectArray[n]);
            ++n;
        }
    }

    protected void restore(IProgressMonitor iProgressMonitor) throws CoreException {
        if (Policy.DEBUG_RESTORE) {
            System.out.println("Restore workspace: starting...");
        }
        long l = System.currentTimeMillis();
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 50);
            this.workspace.newWorkingTree();
            try {
                String string = Messages.resources_startupProblems;
                MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 567, string, null);
                this.restoreMasterTable();
                this.restoreTree(Policy.subMonitorFor(iProgressMonitor, 10));
                this.restoreSnapshots(Policy.subMonitorFor(iProgressMonitor, 10));
                try {
                    this.restoreMarkers(this.workspace.getRoot(), false, Policy.subMonitorFor(iProgressMonitor, 10));
                }
                catch (CoreException coreException) {
                    multiStatus.merge(coreException.getStatus());
                }
                try {
                    this.restoreSyncInfo(this.workspace.getRoot(), Policy.subMonitorFor(iProgressMonitor, 10));
                }
                catch (CoreException coreException) {
                    multiStatus.merge(coreException.getStatus());
                }
                this.restoreMetaInfo(multiStatus, Policy.subMonitorFor(iProgressMonitor, 10));
                IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
                int n = 0;
                while (n < iProjectArray.length) {
                    ((Project)iProjectArray[n]).startup();
                    ++n;
                }
                if (!multiStatus.isOK()) {
                    Policy.log((IStatus)multiStatus);
                }
            }
            finally {
                this.workspace.getElementTree().immutable();
            }
        }
        finally {
            iProgressMonitor.done();
        }
        if (Policy.DEBUG_RESTORE) {
            System.out.println("Restore workspace: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected boolean restore(Project project, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = true;
        if (Policy.DEBUG_RESTORE) {
            System.out.println("Restore project " + project.getFullPath() + ": starting...");
        }
        long l = System.currentTimeMillis();
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 40);
            if (project.isOpen()) {
                bl = this.restoreTree(project, Policy.subMonitorFor(iProgressMonitor, 10));
            } else {
                iProgressMonitor.worked(10);
            }
            this.restoreMarkers(project, true, Policy.subMonitorFor(iProgressMonitor, 10));
            this.restoreSyncInfo(project, Policy.subMonitorFor(iProgressMonitor, 10));
            this.restoreMetaInfo(project, Policy.subMonitorFor(iProgressMonitor, 10));
        }
        finally {
            iProgressMonitor.done();
        }
        if (Policy.DEBUG_RESTORE) {
            System.out.println("Restore project " + project.getFullPath() + ": " + (System.currentTimeMillis() - l) + "ms");
        }
        return bl;
    }

    protected void restoreMarkers(IResource iResource, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isLegal((iResource.getType() == 8 || iResource.getType() == 4 ? 1 : 0) != 0);
        long l = System.currentTimeMillis();
        MarkerManager markerManager = this.workspace.getMarkerManager();
        if (iResource.isAccessible()) {
            markerManager.restore(iResource, bl, iProgressMonitor);
        }
        if (iResource.getType() == 4) {
            if (Policy.DEBUG_RESTORE_MARKERS) {
                System.out.println("Restore Markers for " + iResource.getFullPath() + ": " + (System.currentTimeMillis() - l) + "ms");
            }
            return;
        }
        IProject[] iProjectArray = ((IWorkspaceRoot)iResource).getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].isAccessible()) {
                markerManager.restore(iProjectArray[n], bl, iProgressMonitor);
            }
            ++n;
        }
        if (Policy.DEBUG_RESTORE_MARKERS) {
            System.out.println("Restore Markers for workspace: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected void restoreMasterTable() throws CoreException {
        long l = System.currentTimeMillis();
        this.masterTable = new Properties();
        IPath iPath = this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources");
        File file = iPath.toFile();
        if (!file.exists() && !(file = (iPath = this.workspace.getMetaArea().getBackupLocationFor(iPath)).toFile()).exists()) {
            return;
        }
        try {
            SafeChunkyInputStream safeChunkyInputStream = new SafeChunkyInputStream(file);
            try {
                this.masterTable.load(safeChunkyInputStream);
            }
            finally {
                safeChunkyInputStream.close();
            }
        }
        catch (IOException iOException) {
            String string = Messages.resources_exMasterTable;
            throw new ResourceException(566, null, string, iOException);
        }
        if (Policy.DEBUG_RESTORE_MASTERTABLE) {
            System.out.println("Restore master table for " + iPath + ": " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected void restoreMetaInfo(MultiStatus multiStatus, IProgressMonitor iProgressMonitor) {
        if (Policy.DEBUG_RESTORE_METAINFO) {
            System.out.println("Restore workspace metainfo: starting...");
        }
        long l = System.currentTimeMillis();
        IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            try {
                this.restoreMetaInfo((Project)iProjectArray[n], iProgressMonitor);
            }
            catch (CoreException coreException) {
                String string = NLS.bind((String)Messages.resources_readMeta, (Object)iProjectArray[n].getName());
                multiStatus.merge((IStatus)new ResourceStatus(567, iProjectArray[n].getFullPath(), string, coreException));
            }
            ++n;
        }
        if (Policy.DEBUG_RESTORE_METAINFO) {
            System.out.println("Restore workspace metainfo: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected void restoreMetaInfo(Project project, IProgressMonitor iProgressMonitor) throws CoreException {
        long l = System.currentTimeMillis();
        ProjectDescription projectDescription = null;
        CoreException coreException = null;
        try {
            projectDescription = project.isOpen() ? this.workspace.getFileSystemManager().read(project, true) : this.workspace.getMetaArea().readOldDescription(project);
        }
        catch (CoreException coreException2) {
            coreException = coreException2;
        }
        if (projectDescription == null) {
            projectDescription = new ProjectDescription();
            projectDescription.setName(project.getName());
            this.workspace.getMetaArea().readPrivateDescription(project, projectDescription);
        }
        project.internalSetDescription(projectDescription, false);
        if (coreException != null) {
            project.internalClose();
            throw coreException;
        }
        if (Policy.DEBUG_RESTORE_METAINFO) {
            System.out.println("Restore metainfo for " + project.getFullPath() + ": " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected void restoreSnapshots(IProgressMonitor iProgressMonitor) throws CoreException {
        long l = System.currentTimeMillis();
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 100);
            IPath iPath = this.workspace.getMetaArea().getSnapshotLocationFor(this.workspace.getRoot());
            File file = iPath.toFile();
            if (!file.exists()) {
                this.initSnap(Policy.subMonitorFor(iProgressMonitor, 50));
                return;
            }
            this.workspace.setCrashed(true);
            try {
                ElementTree elementTree = this.workspace.getElementTree();
                elementTree.immutable();
                DataInputStream dataInputStream = new DataInputStream(new SafeChunkyInputStream(file));
                try {
                    WorkspaceTreeReader workspaceTreeReader = WorkspaceTreeReader.getReader(this.workspace, dataInputStream.readInt());
                    elementTree = workspaceTreeReader.readSnapshotTree(dataInputStream, elementTree, iProgressMonitor);
                }
                finally {
                    FileUtil.safeClose(dataInputStream);
                    this.lastSnap = elementTree;
                    this.workspace.tree = elementTree = elementTree.newEmptyDelta();
                }
            }
            catch (Exception exception) {
                String string = Messages.resources_snapRead;
                Policy.log(new ResourceStatus(567, null, string, exception));
            }
        }
        finally {
            iProgressMonitor.done();
        }
        if (Policy.DEBUG_RESTORE_SNAPSHOTS) {
            System.out.println("Restore snapshots for workspace: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected void restoreSyncInfo(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isLegal((iResource.getType() == 8 || iResource.getType() == 4 ? 1 : 0) != 0);
        long l = System.currentTimeMillis();
        Synchronizer synchronizer = (Synchronizer)this.workspace.getSynchronizer();
        if (iResource.isAccessible()) {
            synchronizer.restore(iResource, iProgressMonitor);
        }
        if (iResource.getType() == 4) {
            if (Policy.DEBUG_RESTORE_SYNCINFO) {
                System.out.println("Restore SyncInfo for " + iResource.getFullPath() + ": " + (System.currentTimeMillis() - l) + "ms");
            }
            return;
        }
        IProject[] iProjectArray = ((IWorkspaceRoot)iResource).getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].isAccessible()) {
                synchronizer.restore(iProjectArray[n], iProgressMonitor);
            }
            ++n;
        }
        if (Policy.DEBUG_RESTORE_SYNCINFO) {
            System.out.println("Restore SyncInfo for workspace: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected void restoreTree(IProgressMonitor iProgressMonitor) throws CoreException {
        long l = System.currentTimeMillis();
        IPath iPath = this.workspace.getMetaArea().getTreeLocationFor(this.workspace.getRoot(), false);
        IPath iPath2 = this.workspace.getMetaArea().getBackupLocationFor(iPath);
        if (!iPath.toFile().exists() && !iPath2.toFile().exists()) {
            this.savedStates = Collections.synchronizedMap(new HashMap(10));
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new SafeFileInputStream(iPath.toOSString(), iPath2.toOSString(), 65536));
            try {
                WorkspaceTreeReader.getReader(this.workspace, dataInputStream.readInt()).readTree(dataInputStream, iProgressMonitor);
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)Messages.resources_readMeta, (Object)iPath.toOSString());
            throw new ResourceException(567, iPath, string, iOException);
        }
        if (Policy.DEBUG_RESTORE_TREE) {
            System.out.println("Restore Tree for workspace: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected boolean restoreTree(Project project, IProgressMonitor iProgressMonitor) throws CoreException {
        long l = System.currentTimeMillis();
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 100);
            IPath iPath = this.workspace.getMetaArea().getTreeLocationFor(project, false);
            IPath iPath2 = this.workspace.getMetaArea().getBackupLocationFor(iPath);
            if (!iPath.toFile().exists() && !iPath2.toFile().exists()) {
                return false;
            }
            try {
                DataInputStream dataInputStream = new DataInputStream(new SafeFileInputStream(iPath.toOSString(), iPath2.toOSString()));
                try {
                    WorkspaceTreeReader workspaceTreeReader = WorkspaceTreeReader.getReader(this.workspace, dataInputStream.readInt());
                    workspaceTreeReader.readTree(project, dataInputStream, Policy.subMonitorFor(iProgressMonitor, 100));
                }
                finally {
                    dataInputStream.close();
                }
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)Messages.resources_readMeta, (Object)project.getFullPath());
                throw new ResourceException(567, project.getFullPath(), string, iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
        if (Policy.DEBUG_RESTORE_TREE) {
            System.out.println("Restore Tree for " + project.getFullPath() + ": " + (System.currentTimeMillis() - l) + "ms");
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public IStatus save(int var1_1, Project var2_2, IProgressMonitor var3_3) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void saveMasterTable() throws CoreException {
        this.saveMasterTable(this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources"));
    }

    protected void saveMasterTable(IPath iPath) throws CoreException {
        long l = System.currentTimeMillis();
        File file = iPath.toFile();
        try {
            SafeChunkyOutputStream safeChunkyOutputStream = new SafeChunkyOutputStream(file);
            try {
                this.masterTable.store(safeChunkyOutputStream, "master table");
                safeChunkyOutputStream.succeed();
            }
            finally {
                safeChunkyOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ResourceException(566, null, NLS.bind((String)Messages.resources_exSaveMaster, (Object)iPath.toOSString()), iOException);
        }
        if (Policy.DEBUG_SAVE_MASTERTABLE) {
            System.out.println("Save master table for " + iPath + ": " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected void saveMetaInfo(MultiStatus multiStatus, IProgressMonitor iProgressMonitor) throws CoreException {
        if (Policy.DEBUG_SAVE_METAINFO) {
            System.out.println("Save workspace metainfo: starting...");
        }
        long l = System.currentTimeMillis();
        ResourcesPlugin.getPlugin().savePluginPreferences();
        IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            IStatus iStatus;
            if (iProjectArray[n].isAccessible() && !(iStatus = this.saveMetaInfo((Project)iProjectArray[n], null)).isOK()) {
                multiStatus.merge(iStatus);
            }
            ++n;
        }
        if (Policy.DEBUG_SAVE_METAINFO) {
            System.out.println("Save workspace metainfo: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected IStatus saveMetaInfo(Project project, IProgressMonitor iProgressMonitor) throws CoreException {
        long l = System.currentTimeMillis();
        if (!this.workspace.getFileSystemManager().hasSavedDescription(project)) {
            this.workspace.getFileSystemManager().writeSilently(project);
            String string = NLS.bind((String)Messages.resources_missingProjectMetaRepaired, (Object)project.getName());
            return new ResourceStatus(234, project.getFullPath(), string);
        }
        if (Policy.DEBUG_SAVE_METAINFO) {
            System.out.println("Save metainfo for " + project.getFullPath() + ": " + (System.currentTimeMillis() - l) + "ms");
        }
        return Status.OK_STATUS;
    }

    protected void saveTree(Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        long l = System.currentTimeMillis();
        IPath iPath = this.workspace.getMetaArea().getTreeLocationFor(this.workspace.getRoot(), true);
        try {
            IPath iPath2 = this.workspace.getMetaArea().getBackupLocationFor(iPath);
            DataOutputStream dataOutputStream = new DataOutputStream(new SafeFileOutputStream(iPath.toOSString(), iPath2.toOSString()));
            try {
                dataOutputStream.writeInt(67305986);
                this.writeTree(this.computeStatesToSave(map, this.workspace.getElementTree()), dataOutputStream, iProgressMonitor);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (Exception exception) {
            String string = NLS.bind((String)Messages.resources_writeWorkspaceMeta, (Object)iPath);
            throw new ResourceException(568, (IPath)Path.ROOT, string, exception);
        }
        if (Policy.DEBUG_SAVE_TREE) {
            System.out.println("Save Workspace Tree: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    void setPluginsSavedState(HashMap hashMap) {
        this.savedStates = Collections.synchronizedMap(hashMap);
    }

    protected void setSaveNumber(String string, int n) {
        this.masterTable.setProperty(SAVE_NUMBER_PREFIX + string, new Integer(n).toString());
    }

    public void shareStrings(StringPool stringPool) {
        this.lastSnap.shareStrings(stringPool);
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
        int n = this.snapshotJob.getState();
        if (n == 2 || n == 1) {
            this.snapshotJob.run(Policy.monitorFor(iProgressMonitor));
        }
        this.snapshotJob.cancel();
    }

    public void snapshotIfNeeded(boolean bl) {
        if (this.isSaving) {
            return;
        }
        if (this.snapshotRequested || this.operationCount >= this.workspace.internalGetDescription().getOperationsPerSnapshot()) {
            if (this.snapshotJob.getState() == 0) {
                this.snapshotJob.schedule();
            } else {
                this.snapshotJob.wakeUp();
            }
        } else if (bl) {
            ++this.operationCount;
            if (this.snapshotJob.getState() == 0) {
                if (Policy.DEBUG_SAVE) {
                    System.out.println("Scheduling workspace snapshot");
                }
                long l = this.workspace.internalGetDescription().getSnapshotInterval();
                this.snapshotJob.schedule(Math.max(l, 30000L));
            }
        } else if (++this.noopCount > 20) {
            ++this.operationCount;
            this.noopCount = 0;
        }
    }

    protected void snapTree(ElementTree elementTree, IProgressMonitor iProgressMonitor) throws CoreException {
        long l = System.currentTimeMillis();
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 100);
            elementTree.immutable();
            if (elementTree == this.lastSnap) {
                return;
            }
            this.operationCount = 0;
            IPath iPath = this.workspace.getMetaArea().getSnapshotLocationFor(this.workspace.getRoot());
            ElementTreeWriter elementTreeWriter = new ElementTreeWriter(this);
            File file = iPath.toFile();
            try {
                SafeChunkyOutputStream safeChunkyOutputStream = new SafeChunkyOutputStream(file);
                DataOutputStream dataOutputStream = new DataOutputStream(safeChunkyOutputStream);
                try {
                    dataOutputStream.writeInt(67305986);
                    this.writeWorkspaceFields(dataOutputStream, iProgressMonitor);
                    elementTreeWriter.writeDelta(elementTree, this.lastSnap, (IPath)Path.ROOT, -1, dataOutputStream, ResourceComparator.getSaveComparator());
                    safeChunkyOutputStream.succeed();
                }
                finally {
                    dataOutputStream.close();
                }
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)Messages.resources_writeWorkspaceMeta, (Object)file.getAbsolutePath());
                throw new ResourceException(568, (IPath)Path.ROOT, string, iOException);
            }
            this.lastSnap = elementTree;
        }
        finally {
            iProgressMonitor.done();
        }
        if (Policy.DEBUG_SAVE_TREE) {
            System.out.println("Snapshot Workspace Tree: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected ElementTree[] sortTrees(ElementTree[] elementTreeArray) {
        int n = elementTreeArray.length;
        ElementTree[] elementTreeArray2 = new ElementTree[n];
        HashMap<ElementTree, ArrayList<Integer>> hashMap = new HashMap<ElementTree, ArrayList<Integer>>(n * 2 + 1);
        int n2 = 0;
        while (n2 < elementTreeArray.length) {
            ArrayList<Integer> arrayList = (ArrayList<Integer>)hashMap.get(elementTreeArray[n2]);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>(10);
                hashMap.put(elementTreeArray[n2], arrayList);
            }
            arrayList.add(new Integer(n2));
            ++n2;
        }
        Object object = elementTreeArray[ElementTree.findOldest(elementTreeArray)];
        int n3 = n - 1;
        while (n3 >= 0) {
            List list = (List)hashMap.remove(object);
            Object object2 = Collections.enumeration(list);
            while (object2.hasMoreElements()) {
                object2.nextElement();
                elementTreeArray2[n3] = object;
                --n3;
            }
            if (n3 < 0) continue;
            object2 = ((ElementTree)object).getParent();
            while (object2 != null && hashMap.get(object2) == null) {
                object2 = ((ElementTree)object2).getParent();
            }
            if (object2 == null) {
                Status status = new Status(2, "org.eclipse.core.resources", 566, "null parent found while collapsing trees", null);
                Policy.log((IStatus)status);
                return null;
            }
            object = object2;
        }
        return elementTreeArray2;
    }

    public void startup(IProgressMonitor iProgressMonitor) throws CoreException {
        this.restore(iProgressMonitor);
        File file = this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources").toFile();
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
    }

    protected void updateDeltaExpiration(String string) {
        String string2 = DELTA_EXPIRATION_PREFIX + string;
        if (!this.masterTable.containsKey(string2)) {
            this.masterTable.setProperty(string2, Long.toString(System.currentTimeMillis()));
        }
    }

    public void visitAndSave(IResource iResource) throws CoreException {
        Assert.isLegal((iResource.getType() == 8 || iResource.getType() == 4 ? 1 : 0) != 0);
        if (!iResource.isAccessible()) {
            return;
        }
        Synchronizer synchronizer = (Synchronizer)this.workspace.getSynchronizer();
        final MarkerManager markerManager = this.workspace.getMarkerManager();
        IPath iPath = this.workspace.getMetaArea().getMarkersLocationFor(iResource);
        IPath iPath2 = this.workspace.getMetaArea().getBackupLocationFor(iPath);
        IPath iPath3 = this.workspace.getMetaArea().getSyncInfoLocationFor(iResource);
        IPath iPath4 = this.workspace.getMetaArea().getBackupLocationFor(iPath3);
        ArrayList arrayList = new ArrayList(5);
        ArrayList arrayList2 = new ArrayList(synchronizer.registry.size());
        FilterOutputStream filterOutputStream = null;
        DataOutputStream dataOutputStream = null;
        try {
            filterOutputStream = new DataOutputStream(new SafeFileOutputStream(iPath.toOSString(), iPath2.toOSString()));
            if (iResource.getType() != 8) {
                dataOutputStream = new DataOutputStream(new SafeFileOutputStream(iPath3.toOSString(), iPath4.toOSString()));
            }
        }
        catch (IOException iOException) {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException2) {}
            }
            String string = NLS.bind((String)Messages.resources_writeMeta, (Object)iResource.getFullPath());
            throw new ResourceException(568, iResource.getFullPath(), string, iOException);
        }
        FilterOutputStream filterOutputStream2 = filterOutputStream;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        long[] lArray = new long[2];
        IElementContentVisitor iElementContentVisitor = new IElementContentVisitor((DataOutputStream)filterOutputStream2, arrayList, lArray, dataOutputStream2, synchronizer, arrayList2, iResource){
            private final /* synthetic */ DataOutputStream val$markersOutput;
            private final /* synthetic */ List val$writtenTypes;
            private final /* synthetic */ long[] val$saveTimes;
            private final /* synthetic */ DataOutputStream val$syncInfoOutput;
            private final /* synthetic */ Synchronizer val$synchronizer;
            private final /* synthetic */ List val$writtenPartners;
            private final /* synthetic */ IResource val$root;
            {
                this.val$markersOutput = dataOutputStream;
                this.val$writtenTypes = list;
                this.val$saveTimes = lArray;
                this.val$syncInfoOutput = dataOutputStream2;
                this.val$synchronizer = synchronizer;
                this.val$writtenPartners = list2;
                this.val$root = iResource;
            }

            public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                ResourceInfo resourceInfo = (ResourceInfo)object;
                if (resourceInfo != null) {
                    try {
                        long l = System.currentTimeMillis();
                        markerManager.save(resourceInfo, iPathRequestor, this.val$markersOutput, this.val$writtenTypes);
                        long l2 = System.currentTimeMillis() - l;
                        this.val$saveTimes[0] = this.val$saveTimes[0] + l2;
                        SaveManager.this.persistMarkers += l2;
                        if (this.val$syncInfoOutput != null) {
                            l = System.currentTimeMillis();
                            this.val$synchronizer.saveSyncInfo(resourceInfo, iPathRequestor, this.val$syncInfoOutput, this.val$writtenPartners);
                            long l3 = System.currentTimeMillis() - l;
                            this.val$saveTimes[1] = this.val$saveTimes[1] + l3;
                            SaveManager.this.persistSyncInfo += l3;
                        }
                    }
                    catch (IOException iOException) {
                        throw new WrappedRuntimeException(iOException);
                    }
                }
                return this.val$root.getType() != 8;
            }
        };
        try {
            try {
                try {
                    new ElementTreeIterator(this.workspace.getElementTree(), iResource.getFullPath()).iterate(iElementContentVisitor);
                }
                catch (WrappedRuntimeException wrappedRuntimeException) {
                    throw (IOException)wrappedRuntimeException.getTargetException();
                }
                if (Policy.DEBUG_SAVE_MARKERS) {
                    System.out.println("Save Markers for " + iResource.getFullPath() + ": " + lArray[0] + "ms");
                }
                if (Policy.DEBUG_SAVE_SYNCINFO) {
                    System.out.println("Save SyncInfo for " + iResource.getFullPath() + ": " + lArray[1] + "ms");
                }
                this.removeGarbage((DataOutputStream)filterOutputStream2, iPath, iPath2);
                if (dataOutputStream2 != null) {
                    this.removeGarbage(dataOutputStream2, iPath3, iPath4);
                }
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)Messages.resources_writeMeta, (Object)iResource.getFullPath());
                throw new ResourceException(568, iResource.getFullPath(), string, iOException);
            }
        }
        finally {
            FileUtil.safeClose(filterOutputStream2);
            FileUtil.safeClose(dataOutputStream2);
        }
        if (iResource.getType() == 4) {
            return;
        }
        IProject[] iProjectArray = ((IWorkspaceRoot)iResource).getProjects(8);
        int n = 0;
        while (n < iProjectArray.length) {
            this.visitAndSave(iProjectArray[n]);
            ++n;
        }
    }

    public void visitAndSnap(final IResource iResource) throws CoreException {
        Assert.isLegal((iResource.getType() == 8 || iResource.getType() == 4 ? 1 : 0) != 0);
        if (!iResource.isAccessible()) {
            return;
        }
        final Synchronizer synchronizer = (Synchronizer)this.workspace.getSynchronizer();
        final MarkerManager markerManager = this.workspace.getMarkerManager();
        IPath iPath = this.workspace.getMetaArea().getMarkersSnapshotLocationFor(iResource);
        IPath iPath2 = this.workspace.getMetaArea().getSyncInfoSnapshotLocationFor(iResource);
        SafeChunkyOutputStream safeChunkyOutputStream = null;
        SafeChunkyOutputStream safeChunkyOutputStream2 = null;
        DataOutputStream dataOutputStream = null;
        DataOutputStream dataOutputStream2 = null;
        try {
            safeChunkyOutputStream = new SafeChunkyOutputStream(iPath.toFile());
            dataOutputStream = new DataOutputStream(safeChunkyOutputStream);
            if (iResource.getType() != 8) {
                safeChunkyOutputStream2 = new SafeChunkyOutputStream(iPath2.toFile());
                dataOutputStream2 = new DataOutputStream(safeChunkyOutputStream2);
            }
        }
        catch (IOException iOException) {
            FileUtil.safeClose(dataOutputStream);
            String string = NLS.bind((String)Messages.resources_writeMeta, (Object)iResource.getFullPath());
            throw new ResourceException(568, iResource.getFullPath(), string, iOException);
        }
        final DataOutputStream dataOutputStream3 = dataOutputStream;
        final DataOutputStream dataOutputStream4 = dataOutputStream2;
        int n = dataOutputStream3.size();
        int n2 = safeChunkyOutputStream2 == null ? -1 : dataOutputStream4.size();
        final long[] lArray = new long[2];
        IElementContentVisitor iElementContentVisitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                ResourceInfo resourceInfo = (ResourceInfo)object;
                if (resourceInfo != null) {
                    try {
                        long l = System.currentTimeMillis();
                        markerManager.snap(resourceInfo, iPathRequestor, dataOutputStream3);
                        long l2 = System.currentTimeMillis() - l;
                        lArray[0] = lArray[0] + l2;
                        SaveManager.this.persistMarkers += l2;
                        if (dataOutputStream4 != null) {
                            l = System.currentTimeMillis();
                            synchronizer.snapSyncInfo(resourceInfo, iPathRequestor, dataOutputStream4);
                            long l3 = System.currentTimeMillis() - l;
                            lArray[1] = lArray[1] + l3;
                            SaveManager.this.persistSyncInfo += l3;
                        }
                    }
                    catch (IOException iOException) {
                        throw new WrappedRuntimeException(iOException);
                    }
                }
                return iResource.getType() != 8;
            }
        };
        try {
            try {
                try {
                    new ElementTreeIterator(this.workspace.getElementTree(), iResource.getFullPath()).iterate(iElementContentVisitor);
                }
                catch (WrappedRuntimeException wrappedRuntimeException) {
                    throw (IOException)wrappedRuntimeException.getTargetException();
                }
                if (Policy.DEBUG_SAVE_MARKERS) {
                    System.out.println("Snap Markers for " + iResource.getFullPath() + ": " + lArray[0] + "ms");
                }
                if (Policy.DEBUG_SAVE_SYNCINFO) {
                    System.out.println("Snap SyncInfo for " + iResource.getFullPath() + ": " + lArray[1] + "ms");
                }
                if (n != dataOutputStream3.size()) {
                    safeChunkyOutputStream.succeed();
                }
                if (safeChunkyOutputStream2 != null && n2 != dataOutputStream4.size()) {
                    safeChunkyOutputStream2.succeed();
                }
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)Messages.resources_writeMeta, (Object)iResource.getFullPath());
                throw new ResourceException(568, iResource.getFullPath(), string, iOException);
            }
        }
        finally {
            FileUtil.safeClose(dataOutputStream3);
            FileUtil.safeClose(dataOutputStream4);
        }
        if (iResource.getType() == 4) {
            return;
        }
        IProject[] iProjectArray = ((IWorkspaceRoot)iResource).getProjects(8);
        int n3 = 0;
        while (n3 < iProjectArray.length) {
            this.visitAndSnap(iProjectArray[n3]);
            ++n3;
        }
    }

    protected void writeBuilderPersistentInfo(DataOutputStream dataOutputStream, List list, List list2, IProgressMonitor iProgressMonitor) throws IOException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            int n = list.size();
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                BuilderPersistentInfo builderPersistentInfo = (BuilderPersistentInfo)list.get(n2);
                dataOutputStream.writeUTF(builderPersistentInfo.getProjectName());
                dataOutputStream.writeUTF(builderPersistentInfo.getBuilderName());
                IProject[] iProjectArray = builderPersistentInfo.getInterestingProjects();
                dataOutputStream.writeInt(iProjectArray.length);
                int n3 = 0;
                while (n3 < iProjectArray.length) {
                    dataOutputStream.writeUTF(iProjectArray[n3].getName());
                    ++n3;
                }
                ElementTree elementTree = builderPersistentInfo.getLastBuiltTree();
                if (elementTree == null) {
                    elementTree = this.workspace.getElementTree();
                }
                list2.add(elementTree);
                ++n2;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void writeElement(IPath iPath, Object object, DataOutput dataOutput) throws IOException {
        Assert.isNotNull((Object)iPath);
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)dataOutput);
        ResourceInfo resourceInfo = (ResourceInfo)object;
        dataOutput.writeInt(resourceInfo.getFlags());
        resourceInfo.writeTo(dataOutput);
    }

    protected void writeTree(Map map, DataOutputStream dataOutputStream, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 100);
            boolean bl = false;
            try {
                ElementTree[] elementTreeArray;
                Object object;
                ElementTree elementTree = this.workspace.getElementTree();
                bl = elementTree.isImmutable();
                elementTree.immutable();
                ArrayList<Object> arrayList = new ArrayList<Object>(map.size() * 2);
                iProgressMonitor.worked(10);
                this.writeWorkspaceFields(dataOutputStream, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 20 / 100));
                dataOutputStream.writeInt(map.size());
                IProject[] iProjectArray = map.entrySet().iterator();
                while (iProjectArray.hasNext()) {
                    object = iProjectArray.next();
                    String string = (String)object.getKey();
                    dataOutputStream.writeUTF(string);
                    arrayList.add(object.getValue());
                    this.updateDeltaExpiration(string);
                }
                iProgressMonitor.worked(10);
                iProjectArray = this.workspace.getRoot().getProjects(8);
                object = new ArrayList(iProjectArray.length * 2);
                int n = 0;
                while (n < iProjectArray.length) {
                    ArrayList arrayList2;
                    elementTreeArray = iProjectArray[n];
                    if (elementTreeArray.isOpen() && (arrayList2 = this.workspace.getBuildManager().createBuildersPersistentInfo((IProject)elementTreeArray)) != null) {
                        object.addAll(arrayList2);
                    }
                    ++n;
                }
                this.writeBuilderPersistentInfo(dataOutputStream, (List)object, arrayList, Policy.subMonitorFor(iProgressMonitor, 10));
                arrayList.add(elementTree);
                ElementTreeWriter elementTreeWriter = new ElementTreeWriter(this);
                elementTreeArray = arrayList.toArray(new ElementTree[arrayList.size()]);
                elementTreeWriter.writeDeltaChain(elementTreeArray, (IPath)Path.ROOT, -1, dataOutputStream, ResourceComparator.getSaveComparator());
                iProgressMonitor.worked(50);
            }
            finally {
                if (!bl) {
                    this.workspace.newWorkingTree();
                }
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void writeTree(Project project, DataOutputStream dataOutputStream, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 10);
            boolean bl = false;
            try {
                ArrayList arrayList = this.workspace.getBuildManager().createBuildersPersistentInfo(project);
                if (arrayList == null) {
                    arrayList = new ArrayList(5);
                }
                ArrayList<ElementTree> arrayList2 = new ArrayList<ElementTree>(arrayList.size() + 1);
                iProgressMonitor.worked(1);
                ElementTree elementTree = this.workspace.getElementTree();
                bl = elementTree.isImmutable();
                elementTree.immutable();
                this.writeBuilderPersistentInfo(dataOutputStream, arrayList, arrayList2, Policy.subMonitorFor(iProgressMonitor, 1));
                arrayList2.add(elementTree);
                ElementTreeWriter elementTreeWriter = new ElementTreeWriter(this);
                ElementTree[] elementTreeArray = arrayList2.toArray(new ElementTree[arrayList2.size()]);
                elementTreeWriter.writeDeltaChain(elementTreeArray, project.getFullPath(), -1, dataOutputStream, ResourceComparator.getSaveComparator());
                iProgressMonitor.worked(8);
            }
            finally {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
                if (!bl) {
                    this.workspace.newWorkingTree();
                }
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void writeTree(Project project, int n) throws CoreException {
        long l = System.currentTimeMillis();
        IPath iPath = this.workspace.getMetaArea().getTreeLocationFor(project, true);
        IPath iPath2 = this.workspace.getMetaArea().getBackupLocationFor(iPath);
        try {
            SafeFileOutputStream safeFileOutputStream = new SafeFileOutputStream(iPath.toOSString(), iPath2.toOSString());
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(safeFileOutputStream);
                dataOutputStream.writeInt(67305986);
                this.writeTree(project, dataOutputStream, null);
            }
            finally {
                safeFileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)Messages.resources_writeMeta, (Object)project.getFullPath());
            throw new ResourceException(568, iPath, string, iOException);
        }
        if (Policy.DEBUG_SAVE_TREE) {
            System.out.println("Save tree for " + project.getFullPath() + ": " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    protected void writeWorkspaceFields(DataOutputStream dataOutputStream, IProgressMonitor iProgressMonitor) throws IOException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            dataOutputStream.writeLong(this.workspace.nextNodeId);
            dataOutputStream.writeLong(0L);
            dataOutputStream.writeLong(this.workspace.nextMarkerId);
            ((Synchronizer)this.workspace.getSynchronizer()).savePartners(dataOutputStream);
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

