/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.SyncInfoReader_2;
import org.eclipse.core.internal.resources.SyncInfoReader_3;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class SyncInfoReader {
    protected Workspace workspace;
    protected Synchronizer synchronizer;

    public SyncInfoReader(Workspace workspace, Synchronizer synchronizer) {
        this.workspace = workspace;
        this.synchronizer = synchronizer;
    }

    protected SyncInfoReader getReader(int n) throws IOException {
        switch (n) {
            case 2: {
                return new SyncInfoReader_2(this.workspace, this.synchronizer);
            }
            case 3: {
                return new SyncInfoReader_3(this.workspace, this.synchronizer);
            }
        }
        throw new IOException(NLS.bind((String)Messages.resources_format, (Object)new Integer(n)));
    }

    public void readPartners(DataInputStream dataInputStream) throws CoreException {
        try {
            int n = dataInputStream.readInt();
            HashSet<QualifiedName> hashSet = new HashSet<QualifiedName>(n);
            int n2 = 0;
            while (n2 < n) {
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                hashSet.add(new QualifiedName(string, string2));
                ++n2;
            }
            this.synchronizer.setRegistry(hashSet);
        }
        catch (IOException iOException) {
            String string = NLS.bind((String)Messages.resources_readSync, (Object)iOException);
            throw new ResourceException(new ResourceStatus(566, string));
        }
    }

    public void readSyncInfo(DataInputStream dataInputStream) throws IOException, CoreException {
        int n = SyncInfoReader.readVersionNumber(dataInputStream);
        SyncInfoReader syncInfoReader = this.getReader(n);
        syncInfoReader.readSyncInfo(dataInputStream);
    }

    protected static int readVersionNumber(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readInt();
    }
}

