/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.SyncInfoReader;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.ObjectMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class SyncInfoReader_3
extends SyncInfoReader {
    public static final byte INDEX = 1;
    public static final byte QNAME = 2;

    public SyncInfoReader_3(Workspace workspace, Synchronizer synchronizer) {
        super(workspace, synchronizer);
    }

    public void readSyncInfo(DataInputStream dataInputStream) throws IOException, CoreException {
        try {
            ArrayList arrayList = new ArrayList(5);
            while (true) {
                Path path = new Path(dataInputStream.readUTF());
                this.readSyncInfo((IPath)path, dataInputStream, arrayList);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void readSyncInfo(IPath iPath, DataInputStream dataInputStream, List list) throws IOException, CoreException {
        int n = dataInputStream.readInt();
        ObjectMap objectMap = new ObjectMap(n);
        int n2 = 0;
        while (n2 < n) {
            Object object;
            QualifiedName qualifiedName = null;
            byte by = dataInputStream.readByte();
            switch (by) {
                case 2: {
                    String string = dataInputStream.readUTF();
                    object = dataInputStream.readUTF();
                    qualifiedName = new QualifiedName(string, (String)object);
                    list.add(qualifiedName);
                    break;
                }
                case 1: {
                    qualifiedName = (QualifiedName)list.get(dataInputStream.readInt());
                    break;
                }
                default: {
                    String string = NLS.bind((String)Messages.resources_readSync, (Object)(iPath == null ? "" : iPath.toString()));
                    throw new ResourceException(567, iPath, string, null);
                }
            }
            int n3 = dataInputStream.readInt();
            object = new byte[n3];
            dataInputStream.readFully((byte[])object);
            objectMap.put(qualifiedName, object);
            ++n2;
        }
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iPath, true, false);
        if (resourceInfo == null) {
            return;
        }
        resourceInfo.setSyncInfo(objectMap);
        resourceInfo.clear(8192);
    }
}

