/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.ObjectMap;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.runtime.QualifiedName;

public class SyncInfoWriter {
    protected Synchronizer synchronizer;
    protected Workspace workspace;
    public static final int SYNCINFO_SAVE_VERSION = 3;
    public static final int SYNCINFO_SNAP_VERSION = 3;
    public static final byte INDEX = 1;
    public static final byte QNAME = 2;

    public SyncInfoWriter(Workspace workspace, Synchronizer synchronizer) {
        this.workspace = workspace;
        this.synchronizer = synchronizer;
    }

    public void savePartners(DataOutputStream dataOutputStream) throws IOException {
        Set set = this.synchronizer.getRegistry();
        dataOutputStream.writeInt(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            QualifiedName qualifiedName = (QualifiedName)iterator.next();
            dataOutputStream.writeUTF(qualifiedName.getQualifier());
            dataOutputStream.writeUTF(qualifiedName.getLocalName());
        }
    }

    public void saveSyncInfo(ResourceInfo resourceInfo, IPathRequestor iPathRequestor, DataOutputStream dataOutputStream, List list) throws IOException {
        ObjectMap objectMap = resourceInfo.getSyncInfo(false);
        if (objectMap == null) {
            return;
        }
        if (dataOutputStream.size() == 0) {
            dataOutputStream.writeInt(3);
        }
        dataOutputStream.writeUTF(iPathRequestor.requestPath().toString());
        dataOutputStream.writeInt(objectMap.size());
        Iterator iterator = objectMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            QualifiedName qualifiedName = (QualifiedName)entry.getKey();
            int n = list.indexOf(qualifiedName);
            if (n == -1) {
                dataOutputStream.writeByte(2);
                dataOutputStream.writeUTF(qualifiedName.getQualifier());
                dataOutputStream.writeUTF(qualifiedName.getLocalName());
                list.add(qualifiedName);
            } else {
                dataOutputStream.writeByte(1);
                dataOutputStream.writeInt(n);
            }
            byte[] byArray = (byte[])entry.getValue();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    public void snapSyncInfo(ResourceInfo resourceInfo, IPathRequestor iPathRequestor, DataOutputStream dataOutputStream) throws IOException {
        if (!resourceInfo.isSet(8192)) {
            return;
        }
        ObjectMap objectMap = resourceInfo.getSyncInfo(false);
        if (objectMap == null) {
            return;
        }
        dataOutputStream.writeInt(3);
        dataOutputStream.writeUTF(iPathRequestor.requestPath().toString());
        dataOutputStream.writeInt(objectMap.size());
        Iterator iterator = objectMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            QualifiedName qualifiedName = (QualifiedName)entry.getKey();
            dataOutputStream.writeUTF(qualifiedName.getQualifier());
            dataOutputStream.writeUTF(qualifiedName.getLocalName());
            byte[] byArray = (byte[])entry.getValue();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
        resourceInfo.clear(8192);
    }
}

