/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.SyncInfoReader;
import org.eclipse.core.internal.resources.SyncInfoSnapReader;
import org.eclipse.core.internal.resources.SyncInfoWriter;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class Synchronizer
implements ISynchronizer {
    protected Workspace workspace;
    protected SyncInfoWriter writer;
    protected Set registry = new HashSet(5);

    public Synchronizer(Workspace workspace) {
        this.workspace = workspace;
        this.writer = new SyncInfoWriter(workspace, this);
    }

    public void accept(QualifiedName qualifiedName, IResource iResource, IResourceVisitor iResourceVisitor, int n) throws CoreException {
        Assert.isLegal((qualifiedName != null ? 1 : 0) != 0);
        Assert.isLegal((iResource != null ? 1 : 0) != 0);
        Assert.isLegal((iResourceVisitor != null ? 1 : 0) != 0);
        if (this.getSyncInfo(qualifiedName, iResource) != null && !iResourceVisitor.visit(iResource)) {
            return;
        }
        if (n == 0 || iResource.getType() == 1) {
            return;
        }
        if (n == 1) {
            n = 0;
        }
        IResource[] iResourceArray = ((IContainer)iResource).members();
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            this.accept(qualifiedName, iResourceArray[n2], iResourceVisitor, n);
            ++n2;
        }
    }

    public void add(QualifiedName qualifiedName) {
        Assert.isLegal((qualifiedName != null ? 1 : 0) != 0);
        this.registry.add(qualifiedName);
    }

    public void flushSyncInfo(final QualifiedName qualifiedName, final IResource iResource, final int n) throws CoreException {
        Assert.isLegal((qualifiedName != null ? 1 : 0) != 0);
        Assert.isLegal((iResource != null ? 1 : 0) != 0);
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IResourceVisitor iResourceVisitor = new IResourceVisitor(this, qualifiedName){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ QualifiedName val$partner;
                    {
                        this.this$1 = var1_1;
                        this.val$partner = qualifiedName;
                    }

                    public boolean visit(IResource iResource) throws CoreException {
                        if (1.access$0(this.this$1).getSyncInfo(this.val$partner, iResource) != null) {
                            1.access$0(this.this$1).setSyncInfo(this.val$partner, iResource, null);
                        }
                        return true;
                    }
                };
                iResource.accept(iResourceVisitor, n, true);
            }

            static /* synthetic */ Synchronizer access$0(1 var0) {
                return var0.Synchronizer.this;
            }
        };
        this.workspace.run(iWorkspaceRunnable, iResource, 0, null);
    }

    public QualifiedName[] getPartners() {
        return this.registry.toArray(new QualifiedName[this.registry.size()]);
    }

    protected Set getRegistry() {
        return this.registry;
    }

    public byte[] getSyncInfo(QualifiedName qualifiedName, IResource iResource) throws CoreException {
        Assert.isLegal((qualifiedName != null ? 1 : 0) != 0);
        Assert.isLegal((iResource != null ? 1 : 0) != 0);
        if (!this.isRegistered(qualifiedName)) {
            String string = NLS.bind((String)Messages.synchronizer_partnerNotRegistered, (Object)qualifiedName);
            throw new ResourceException(new ResourceStatus(375, string));
        }
        ResourceInfo resourceInfo = this.workspace.getResourceInfo(iResource.getFullPath(), true, false);
        return resourceInfo == null ? null : resourceInfo.getSyncInfo(qualifiedName, true);
    }

    protected boolean isRegistered(QualifiedName qualifiedName) {
        Assert.isLegal((qualifiedName != null ? 1 : 0) != 0);
        return this.registry.contains(qualifiedName);
    }

    public void readPartners(DataInputStream dataInputStream) throws CoreException {
        SyncInfoReader syncInfoReader = new SyncInfoReader(this.workspace, this);
        syncInfoReader.readPartners(dataInputStream);
    }

    public void restore(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        this.restoreFromSave(iResource);
        this.restoreFromSnap(iResource);
    }

    protected void restoreFromSave(IResource iResource) throws CoreException {
        IPath iPath = this.workspace.getMetaArea().getSyncInfoLocationFor(iResource);
        IPath iPath2 = this.workspace.getMetaArea().getBackupLocationFor(iPath);
        if (!iPath.toFile().exists() && !iPath2.toFile().exists()) {
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new SafeFileInputStream(iPath.toOSString(), iPath2.toOSString()));
            try {
                SyncInfoReader syncInfoReader = new SyncInfoReader(this.workspace, this);
                syncInfoReader.readSyncInfo(dataInputStream);
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            String string = NLS.bind((String)Messages.resources_readMeta, (Object)iPath);
            throw new ResourceException(567, iPath, string, exception);
        }
    }

    protected void restoreFromSnap(IResource iResource) {
        IPath iPath = this.workspace.getMetaArea().getSyncInfoSnapshotLocationFor(iResource);
        if (!iPath.toFile().exists()) {
            return;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new SafeChunkyInputStream(iPath.toFile()));
            try {
                try {
                    SyncInfoSnapReader syncInfoSnapReader = new SyncInfoSnapReader(this.workspace, this);
                    while (true) {
                        syncInfoSnapReader.readSyncInfo(dataInputStream);
                    }
                }
                catch (EOFException eOFException) {
                    dataInputStream.close();
                }
            }
            catch (Throwable throwable) {
                dataInputStream.close();
                throw throwable;
            }
        }
        catch (Exception exception) {
            String string = NLS.bind((String)Messages.resources_readMeta, (Object)iPath);
            Policy.log(new ResourceStatus(567, iPath, string, exception));
        }
    }

    public void remove(QualifiedName qualifiedName) {
        Assert.isLegal((qualifiedName != null ? 1 : 0) != 0);
        if (this.isRegistered(qualifiedName)) {
            try {
                this.flushSyncInfo(qualifiedName, this.workspace.getRoot(), 2);
                this.registry.remove(qualifiedName);
            }
            catch (CoreException coreException) {
                Policy.log(coreException);
            }
        }
    }

    public void savePartners(DataOutputStream dataOutputStream) throws IOException {
        this.writer.savePartners(dataOutputStream);
    }

    public void saveSyncInfo(ResourceInfo resourceInfo, IPathRequestor iPathRequestor, DataOutputStream dataOutputStream, List list) throws IOException {
        this.writer.saveSyncInfo(resourceInfo, iPathRequestor, dataOutputStream, list);
    }

    protected void setRegistry(Set set) {
        this.registry = set;
    }

    public void setSyncInfo(QualifiedName qualifiedName, IResource iResource, byte[] byArray) throws CoreException {
        Assert.isLegal((qualifiedName != null ? 1 : 0) != 0);
        Assert.isLegal((iResource != null ? 1 : 0) != 0);
        try {
            Container container;
            this.workspace.prepareOperation(iResource, null);
            this.workspace.beginOperation(true);
            if (!this.isRegistered(qualifiedName)) {
                String string = NLS.bind((String)Messages.synchronizer_partnerNotRegistered, (Object)qualifiedName);
                throw new ResourceException(new ResourceStatus(375, string));
            }
            if (iResource.getType() == 8) {
                return;
            }
            Resource resource = (Resource)iResource;
            ResourceInfo resourceInfo = this.workspace.getResourceInfo(resource.getFullPath(), true, false);
            int n = resource.getFlags(resourceInfo);
            if (!resource.exists(n, false)) {
                if (byArray == null) {
                    return;
                }
                resource.checkValidPath(resource.getFullPath(), resource.getType(), false);
                container = (Container)resource.getParent();
                container.checkAccessible(container.getFlags(container.getResourceInfo(true, false)));
                this.workspace.createResource((IResource)resource, true);
            }
            resourceInfo = resource.getResourceInfo(true, true);
            resourceInfo.setSyncInfo(qualifiedName, byArray);
            resourceInfo.incrementSyncInfoGenerationCount();
            resourceInfo.set(8192);
            n = resource.getFlags(resourceInfo);
            if (resource.isPhantom(n) && resourceInfo.getSyncInfo(false) == null) {
                container = new MultiStatus("org.eclipse.core.resources", 566, Messages.resources_deleteProblem, null);
                ((Resource)iResource).deleteResource(false, (MultiStatus)container);
                if (!container.isOK()) {
                    throw new ResourceException((IStatus)container);
                }
            }
        }
        finally {
            this.workspace.endOperation(iResource, false, null);
        }
    }

    public void snapSyncInfo(ResourceInfo resourceInfo, IPathRequestor iPathRequestor, DataOutputStream dataOutputStream) throws IOException {
        this.writer.snapSyncInfo(resourceInfo, iPathRequestor, dataOutputStream);
    }
}

