/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class WorkManager
implements IManager {
    private final ThreadLocal checkInFailed = new ThreadLocal();
    private boolean hasBuildChanges = false;
    private IJobManager jobManager;
    private final ILock lock;
    private int nestedOperations = 0;
    private NotifyRule notifyRule = new NotifyRule();
    private boolean operationCanceled = false;
    private int preparedOperations = 0;
    private Workspace workspace;
    static /* synthetic */ Class class$0;

    public WorkManager(Workspace workspace) {
        this.workspace = workspace;
        this.jobManager = Job.getJobManager();
        this.lock = this.jobManager.newLock();
    }

    public int beginUnprotected() {
        int n = this.lock.getDepth();
        int n2 = 0;
        while (n2 < n) {
            this.lock.release();
            ++n2;
        }
        return n;
    }

    public void checkIn(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = false;
        try {
            if (this.workspace.isTreeLocked()) {
                String string = Messages.resources_cannotModify;
                throw new ResourceException(380, null, string, null);
            }
            this.jobManager.beginRule(iSchedulingRule, iProgressMonitor);
            this.lock.acquire();
            this.incrementPreparedOperations();
            bl = true;
        }
        finally {
            if (!bl) {
                this.checkInFailed.set(Boolean.TRUE);
            }
        }
    }

    public boolean checkInFailed(ISchedulingRule iSchedulingRule) {
        if (this.checkInFailed.get() != null) {
            this.checkInFailed.set(null);
            if (!this.workspace.isTreeLocked()) {
                this.jobManager.endRule(iSchedulingRule);
            }
            return true;
        }
        return false;
    }

    public synchronized void checkOut(ISchedulingRule iSchedulingRule) {
        this.decrementPreparedOperations();
        this.rebalanceNestedOperations();
        if (this.preparedOperations == 0) {
            this.hasBuildChanges = false;
            this.operationCanceled = false;
        }
        try {
            this.lock.release();
        }
        finally {
            this.jobManager.endRule(iSchedulingRule);
        }
    }

    private void decrementPreparedOperations() {
        --this.preparedOperations;
    }

    public void endUnprotected(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.lock.acquire();
            ++n2;
        }
    }

    ILock getLock() {
        return this.lock;
    }

    public ISchedulingRule getNotifyRule() {
        return this.notifyRule;
    }

    public synchronized int getPreparedOperationDepth() {
        return this.preparedOperations;
    }

    void incrementNestedOperations() {
        ++this.nestedOperations;
    }

    private void incrementPreparedOperations() {
        ++this.preparedOperations;
    }

    boolean isBalanced() {
        return this.nestedOperations == this.preparedOperations;
    }

    public boolean isLockAlreadyAcquired() {
        boolean bl = false;
        try {
            boolean bl2 = this.lock.acquire(0L);
            if (bl2) {
                bl = this.lock.getDepth() > 1;
                this.lock.release();
            }
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    public void operationCanceled() {
        this.operationCanceled = true;
    }

    public void rebalanceNestedOperations() {
        this.nestedOperations = this.preparedOperations;
    }

    public void setBuild(boolean bl) {
        this.hasBuildChanges = this.hasBuildChanges || bl;
    }

    public boolean shouldBuild() {
        if (this.hasBuildChanges) {
            return !this.operationCanceled;
        }
        return false;
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
    }

    public void startup(IProgressMonitor iProgressMonitor) {
        this.jobManager.beginRule((ISchedulingRule)this.workspace.getRoot(), iProgressMonitor);
        this.lock.acquire();
    }

    void postWorkspaceStartup() {
        try {
            this.lock.release();
        }
        finally {
            this.jobManager.endRule((ISchedulingRule)this.workspace.getRoot());
        }
    }

    class NotifyRule
    implements ISchedulingRule {
        NotifyRule() {
        }

        public boolean contains(ISchedulingRule iSchedulingRule) {
            if (!(iSchedulingRule instanceof IResource)) {
                Class<?> clazz = iSchedulingRule.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.core.internal.resources.WorkManager$NotifyRule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.equals(clazz2)) {
                    return false;
                }
            }
            return true;
        }

        public boolean isConflicting(ISchedulingRule iSchedulingRule) {
            return this.contains(iSchedulingRule);
        }
    }
}

