/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.NotificationManager;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.AliasManager;
import org.eclipse.core.internal.resources.CharsetManager;
import org.eclipse.core.internal.resources.ComputeProjectOrder;
import org.eclipse.core.internal.resources.ContentDescriptionManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.LocationValidator;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.MoveDeleteHook;
import org.eclipse.core.internal.resources.NatureManager;
import org.eclipse.core.internal.resources.PathVariableManager;
import org.eclipse.core.internal.resources.PathVariableUtil;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ProjectPathVariableManager;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.ResourcesCompatibilityHelper;
import org.eclipse.core.internal.resources.RootInfo;
import org.eclipse.core.internal.resources.Rules;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspacePreferences;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.internal.resources.projectVariables.WorkspaceLocationProjectVariable;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.StringPoolJob;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceLock;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.TeamHook;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;

public class Workspace
extends PlatformObject
implements IWorkspace,
ICoreConstants {
    public static final boolean caseSensitive = "macosx".equals(Platform.getOS()) ? false : new java.io.File("a").compareTo(new java.io.File("A")) != 0;
    public static boolean DEBUG = false;
    protected WorkManager _workManager;
    protected AliasManager aliasManager;
    protected BuildManager buildManager;
    protected IProject[] buildOrder = null;
    protected CharsetManager charsetManager;
    protected ContentDescriptionManager contentDescriptionManager;
    protected boolean crashed = false;
    protected final IWorkspaceRoot defaultRoot = new WorkspaceRoot((IPath)Path.ROOT, this);
    protected WorkspacePreferences description;
    protected FileSystemResourceManager fileSystemManager;
    protected final HashSet lifecycleListeners = new HashSet(10);
    protected LocalMetaArea localMetaArea;
    protected final LocationValidator locationValidator = new LocationValidator(this);
    protected MarkerManager markerManager;
    protected IMoveDeleteHook moveDeleteHook = null;
    protected NatureManager natureManager;
    protected long nextMarkerId = 0L;
    protected long nextNodeId = 1L;
    protected NotificationManager notificationManager;
    protected boolean openFlag = false;
    protected ElementTree operationTree;
    protected PathVariableManager pathVariableManager;
    protected IPropertyManager propertyManager;
    protected RefreshManager refreshManager;
    private IResourceRuleFactory ruleFactory;
    protected SaveManager saveManager;
    protected boolean shouldValidate = true;
    private StringPoolJob stringPoolJob;
    protected Synchronizer synchronizer;
    protected TeamHook teamHook = null;
    protected ElementTree tree;
    protected Thread treeLocked = null;
    protected IFileModificationValidator validator = null;

    public static boolean clear(java.io.File file) {
        boolean bl = Workspace.clearChildren(file);
        try {
            if (file.exists()) {
                bl &= file.delete();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean clearChildren(java.io.File file) {
        String[] stringArray;
        boolean bl = true;
        if (file.isDirectory() && (stringArray = file.list()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                bl &= Workspace.clear(new java.io.File(file, stringArray[n]));
                ++n;
            }
        }
        return bl;
    }

    public static WorkspaceDescription defaultWorkspaceDescription() {
        return new WorkspaceDescription("Workspace");
    }

    private static boolean isDuplicate(Object[] objectArray, int n) {
        if (objectArray == null || n >= objectArray.length) {
            return false;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            if (objectArray[n2].equals(objectArray[n])) {
                return true;
            }
            --n2;
        }
        return false;
    }

    public Workspace() {
        this.localMetaArea = new LocalMetaArea();
        this.tree = new ElementTree();
        this.tree.immutable();
        this.treeLocked = Thread.currentThread();
        this.tree.setTreeData(this.newElement(8));
    }

    protected void aboutToBuild(Object object, int n) {
        this.broadcastPostChange();
        this.broadcastBuildEvent(object, 8, n);
    }

    public void addLifecycleListener(ILifecycleListener iLifecycleListener) {
        this.lifecycleListeners.add(iLifecycleListener);
    }

    public void addResourceChangeListener(IResourceChangeListener iResourceChangeListener) {
        this.notificationManager.addListener(iResourceChangeListener, 7);
    }

    public void addResourceChangeListener(IResourceChangeListener iResourceChangeListener, int n) {
        this.notificationManager.addListener(iResourceChangeListener, n);
    }

    public ISavedState addSaveParticipant(Plugin plugin, ISaveParticipant iSaveParticipant) throws CoreException {
        Assert.isNotNull((Object)plugin, (String)"Plugin must not be null");
        Assert.isNotNull((Object)iSaveParticipant, (String)"Participant must not be null");
        return this.saveManager.addParticipant(plugin, iSaveParticipant);
    }

    public void beginOperation(boolean bl) throws CoreException {
        WorkManager workManager = this.getWorkManager();
        workManager.incrementNestedOperations();
        if (!workManager.isBalanced()) {
            Assert.isTrue((boolean)false, (String)"Operation was not prepared.");
        }
        if (workManager.getPreparedOperationDepth() > 1) {
            if (bl && this.tree.isImmutable()) {
                this.newWorkingTree();
            }
            return;
        }
        this.operationTree = this.tree;
        if (bl && this.tree.isImmutable()) {
            this.newWorkingTree();
        }
    }

    public void broadcastBuildEvent(Object object, int n, int n2) {
        ResourceChangeEvent resourceChangeEvent = new ResourceChangeEvent(object, n, n2, null);
        this.notificationManager.broadcastChanges(this.tree, resourceChangeEvent, false);
    }

    protected void broadcastEvent(LifecycleEvent lifecycleEvent) throws CoreException {
        Iterator iterator = this.lifecycleListeners.iterator();
        while (iterator.hasNext()) {
            ILifecycleListener iLifecycleListener = (ILifecycleListener)iterator.next();
            iLifecycleListener.handleEvent(lifecycleEvent);
        }
    }

    public void broadcastPostChange() {
        ResourceChangeEvent resourceChangeEvent = new ResourceChangeEvent(this, 1, 0, null);
        this.notificationManager.broadcastChanges(this.tree, resourceChangeEvent, true);
    }

    public void build(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        ISchedulingRule iSchedulingRule = this.getRuleFactory().buildRule();
        try {
            iProgressMonitor.beginTask("", Policy.opWork);
            try {
                IStatus iStatus;
                this.prepareOperation(iSchedulingRule, iProgressMonitor);
                this.beginOperation(true);
                this.aboutToBuild(this, n);
                try {
                    iStatus = this.getBuildManager().build(n, Policy.subMonitorFor(iProgressMonitor, Policy.opWork));
                }
                finally {
                    this.broadcastBuildEvent(this, 16, n);
                }
                if (!iStatus.isOK()) {
                    throw new ResourceException(iStatus);
                }
            }
            finally {
                if (this.tree.isImmutable()) {
                    this.newWorkingTree();
                }
                this.endOperation(iSchedulingRule, false, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private boolean canCreateExtensions() {
        return Platform.getBundle((String)"org.eclipse.osgi").getState() != 16;
    }

    public void checkpoint(boolean bl) {
        try {
            ISchedulingRule iSchedulingRule = this.getWorkManager().getNotifyRule();
            try {
                this.prepareOperation(iSchedulingRule, null);
                this.beginOperation(true);
                this.broadcastPostChange();
            }
            finally {
                this.endOperation(iSchedulingRule, bl, null);
            }
        }
        catch (CoreException coreException) {
            Policy.log(coreException.getStatus());
        }
    }

    public void close(IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.isOpen()) {
            return;
        }
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = Messages.resources_closing_0;
            int n = this.tree.getChildCount((IPath)Path.ROOT);
            iProgressMonitor.beginTask(string, n + 2);
            iProgressMonitor.subTask(string);
            try {
                this.stringPoolJob.cancel();
                this.saveManager.shutdown(null);
                this.prepareOperation(this.getRoot(), iProgressMonitor);
                this.notificationManager.shutdown(null);
                this.beginOperation(true);
                IProject[] iProjectArray = this.getRoot().getProjects(8);
                int n2 = 0;
                while (n2 < iProjectArray.length) {
                    this.broadcastEvent(LifecycleEvent.newEvent(1, iProjectArray[n2]));
                    iProgressMonitor.worked(1);
                    ++n2;
                }
                this.deleteResource(this.getRoot());
                this.openFlag = false;
            }
            finally {
                this.shutdown(Policy.subMonitorFor(iProgressMonitor, 2, 2));
            }
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)this.getRoot());
            iProgressMonitor.done();
        }
    }

    private IWorkspace.ProjectOrder computeFullProjectOrder() {
        TreeSet<Project> treeSet = new TreeSet<Project>(new Comparator(){

            public int compare(Object object, Object object2) {
                IProject iProject = (IProject)object;
                IProject iProject2 = (IProject)object2;
                return iProject2.getName().compareTo(iProject.getName());
            }
        });
        IProject[] iProjectArray = this.getRoot().getProjects(8);
        ArrayList<IProject[]> arrayList = new ArrayList<IProject[]>(iProjectArray.length);
        int n = 0;
        while (n < iProjectArray.length) {
            ProjectDescription projectDescription;
            Project project = (Project)iProjectArray[n];
            if (project.isAccessible() && (projectDescription = project.internalGetDescription()) != null) {
                IProject[] iProjectArray2 = projectDescription.getAllReferences(false);
                treeSet.add(project);
                int n2 = 0;
                while (n2 < iProjectArray2.length) {
                    IProject iProject = iProjectArray2[n2];
                    if (iProject.isAccessible() && !iProject.equals(project)) {
                        arrayList.add(new IProject[]{project, iProject});
                    }
                    ++n2;
                }
            }
            ++n;
        }
        IWorkspace.ProjectOrder projectOrder = ComputeProjectOrder.computeProjectOrder(treeSet, arrayList);
        return projectOrder;
    }

    public IProject[][] computePrerequisiteOrder(IProject[] iProjectArray) {
        return this.computePrerequisiteOrder1(iProjectArray);
    }

    private IProject[][] computePrerequisiteOrder1(IProject[] iProjectArray) {
        IProject iProject;
        Object object;
        IWorkspace.ProjectOrder projectOrder = this.computeProjectOrder(iProjectArray);
        if (!projectOrder.hasCycles) {
            return new IProject[][]{projectOrder.projects, new IProject[0]};
        }
        HashSet<IProject> hashSet = new HashSet<IProject>();
        HashSet<IProject> hashSet2 = new HashSet<IProject>(Arrays.asList(projectOrder.projects));
        int n = 0;
        while (n < projectOrder.knots.length) {
            object = projectOrder.knots[n];
            int n2 = 0;
            while (n2 < ((IProject[])object).length) {
                iProject = object[n2];
                if (hashSet2.contains(iProject)) {
                    hashSet.add(iProject);
                }
                ++n2;
            }
            ++n;
        }
        IProject[] iProjectArray2 = new IProject[hashSet.size()];
        hashSet.toArray(iProjectArray2);
        object = new LinkedList();
        object.addAll(Arrays.asList(projectOrder.projects));
        IProject[] iProjectArray3 = object.listIterator();
        while (iProjectArray3.hasNext()) {
            iProject = (IProject)iProjectArray3.next();
            if (!hashSet.contains(iProject)) continue;
            iProjectArray3.remove();
        }
        iProjectArray3 = new IProject[object.size()];
        object.toArray(iProjectArray3);
        return new IProject[][]{iProjectArray3, iProjectArray2};
    }

    public IWorkspace.ProjectOrder computeProjectOrder(IProject[] iProjectArray) {
        Object object;
        IWorkspace.ProjectOrder projectOrder = this.computeFullProjectOrder();
        int n = 0;
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            if (iProjectArray[n2].isAccessible()) {
                ++n;
            }
            ++n2;
        }
        if (n == projectOrder.projects.length) {
            return projectOrder;
        }
        HashSet<IProject> hashSet = new HashSet<IProject>(Arrays.asList(iProjectArray));
        ArrayList<IProject> arrayList = new ArrayList<IProject>(projectOrder.projects.length);
        int n3 = 0;
        while (n3 < projectOrder.projects.length) {
            object = projectOrder.projects[n3];
            if (hashSet.contains(object)) {
                arrayList.add((IProject)object);
            }
            ++n3;
        }
        IProject[] iProjectArray2 = new IProject[arrayList.size()];
        arrayList.toArray(iProjectArray2);
        object = new ArrayList(projectOrder.knots.length);
        int n4 = 0;
        while (n4 < projectOrder.knots.length) {
            IProject[] iProjectArray3 = projectOrder.knots[n4];
            ArrayList<IProject> arrayList2 = new ArrayList<IProject>(iProjectArray3.length);
            int n5 = 0;
            while (n5 < iProjectArray3.length) {
                IProject iProject = iProjectArray3[n5];
                if (hashSet.contains(iProject)) {
                    arrayList2.add(iProject);
                }
                ++n5;
            }
            if (arrayList2.size() > 1) {
                object.add(arrayList2.toArray(new IProject[arrayList2.size()]));
            }
            ++n4;
        }
        IProject[][] iProjectArray4 = new IProject[object.size()][];
        object.toArray((T[])iProjectArray4);
        return new IWorkspace.ProjectOrder(iProjectArray2, iProjectArray4.length > 0, iProjectArray4);
    }

    public IStatus copy(IResource[] iResourceArray, IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        return this.copy(iResourceArray, iPath, n, iProgressMonitor);
    }

    public IStatus copy(IResource[] iResourceArray, IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            Assert.isLegal((iResourceArray != null ? 1 : 0) != 0);
            int n2 = Math.max(iResourceArray.length, 1);
            int n3 = 100 * n2 / Policy.opWork;
            String string = Messages.resources_copying_0;
            iProgressMonitor.beginTask(string, n3);
            if (iResourceArray.length == 0) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            iResourceArray = (IResource[])iResourceArray.clone();
            IPath iPath2 = null;
            string = Messages.resources_copyProblem;
            MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 566, string, null);
            try {
                try {
                    this.prepareOperation(this.getRoot(), iProgressMonitor);
                    this.beginOperation(true);
                    int n4 = 0;
                    while (n4 < iResourceArray.length) {
                        block22: {
                            Policy.checkCanceled(iProgressMonitor);
                            IResource iResource = iResourceArray[n4];
                            if (iResource == null || Workspace.isDuplicate(iResourceArray, n4)) {
                                iProgressMonitor.worked(1);
                            } else {
                                if (iPath2 == null) {
                                    iPath2 = iResource.getFullPath().removeLastSegments(1);
                                }
                                if (iPath2.equals((Object)iResource.getFullPath().removeLastSegments(1))) {
                                    try {
                                        IPath iPath3 = iPath.append(iResource.getName());
                                        IStatus iStatus = ((Resource)iResource).checkCopyRequirements(iPath3, iResource.getType(), n);
                                        if (iStatus.isOK()) {
                                            try {
                                                iResource.copy(iPath3, n, Policy.subMonitorFor(iProgressMonitor, 1));
                                            }
                                            catch (CoreException coreException) {
                                                multiStatus.merge(coreException.getStatus());
                                            }
                                            break block22;
                                        }
                                        iProgressMonitor.worked(1);
                                        multiStatus.merge(iStatus);
                                    }
                                    catch (CoreException coreException) {
                                        iProgressMonitor.worked(1);
                                        multiStatus.merge(coreException.getStatus());
                                    }
                                } else {
                                    iProgressMonitor.worked(1);
                                    string = NLS.bind((String)Messages.resources_notChild, (Object)iResourceArray[n4].getFullPath(), (Object)iPath2);
                                    multiStatus.merge((IStatus)new ResourceStatus(76, iResourceArray[n4].getFullPath(), string));
                                }
                            }
                        }
                        ++n4;
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.endOperation(this.getRoot(), true, Policy.subMonitorFor(iProgressMonitor, n3 - n2));
            }
            if (multiStatus.matches(4)) {
                throw new ResourceException((IStatus)multiStatus);
            }
            IStatus iStatus = multiStatus.isOK() ? Status.OK_STATUS : multiStatus;
            return iStatus;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void copyTree(IResource iResource, IPath iPath, int n, int n2, boolean bl) throws CoreException {
        this.copyTree(iResource, iPath, n, n2, bl, false, iResource.getType() == 4);
    }

    protected void copyTree(IResource iResource, IPath iPath, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws CoreException {
        boolean bl4;
        Cloneable cloneable;
        Object object;
        IResource[] iResourceArray;
        int n3;
        IResource iResource2 = this.getRoot().findMember(iPath, true);
        if (iResource2 == null) {
            n3 = iResource.getType() == 1 ? 1 : (iPath.segmentCount() == 1 ? 4 : 2);
            iResource2 = this.newResource(iPath, n3);
        } else {
            n3 = iResource2.getType();
        }
        ResourceInfo resourceInfo = ((Resource)iResource).getResourceInfo(true, false);
        if (n3 != iResource.getType()) {
            resourceInfo = (ResourceInfo)resourceInfo.clone();
            resourceInfo.setType(n3);
        }
        ResourceInfo resourceInfo2 = this.createResource(iResource2, resourceInfo, false, false, bl);
        resourceInfo2.setNodeId(resourceInfo.getNodeId());
        resourceInfo2.setFlags(resourceInfo2.getFlags() | resourceInfo.getFlags() & 2);
        resourceInfo2.setFileStoreRoot(null);
        resourceInfo2.clear(393216);
        if (iResource.isLinked()) {
            iResourceArray = this.transferVariableDefinition(iResource, iResource2, iResource.getLocationURI());
            if ((n2 & 0x20) != 0 || ((Resource)iResource).isUnderGroup()) {
                resourceInfo2.set(65536);
                object = new LinkDescription(iResource2, (URI)iResourceArray);
            } else {
                resourceInfo2.clear(65536);
                object = null;
            }
            if (bl2 && !bl3 && ((Project)iResource.getProject()).internalGetDescription().setLinkLocation(iResource.getProjectRelativePath(), null)) {
                ((Project)iResource.getProject()).writeDescription(n2);
            }
            cloneable = (Project)iResource2.getProject();
            ((Project)cloneable).internalGetDescription().setLinkLocation(iResource2.getProjectRelativePath(), (LinkDescription)object);
            ((Project)cloneable).writeDescription(n2);
            resourceInfo2.setFileStoreRoot(null);
        }
        if (iResource.hasFilters() && iResource.getProject().exists()) {
            object = (Project)iResource.getProject();
            iResourceArray = ((Project)object).internalGetDescription().getFilter(iResource.getProjectRelativePath());
            cloneable = FilterDescription.copy((LinkedList)iResourceArray, iResource2.getProjectRelativePath());
            if (bl2 && !bl3 && ((Project)iResource.getProject()).internalGetDescription().setFilters(iResource.getProjectRelativePath(), null)) {
                ((Project)iResource.getProject()).writeDescription(n2);
            }
            Project project = (Project)iResource2.getProject();
            project.internalGetDescription().setFilters(iResource2.getProjectRelativePath(), (LinkedList)cloneable);
            project.writeDescription(n2);
        }
        if (n == 0 || iResource.getType() == 1) {
            return;
        }
        if (n == 1) {
            n = 0;
        }
        boolean bl5 = bl4 = iResource.getType() == 4 && n3 == 4;
        if (bl4 && (iResourceArray = ((Project)iResource).findMember(".project")) != null) {
            this.copyTree((IResource)iResourceArray, iPath.append(iResourceArray.getName()), n, n2, bl, bl2, bl3);
        }
        iResourceArray = ((IContainer)iResource).members(10);
        int n4 = 0;
        int n5 = iResourceArray.length;
        while (n4 < n5) {
            String string = iResourceArray[n4].getName();
            if (!bl4 || !string.equals(".project")) {
                IPath iPath2 = iPath.append(string);
                this.copyTree(iResourceArray[n4], iPath2, n, n2, bl, bl2, bl3);
            }
            ++n4;
        }
    }

    public URI transferVariableDefinition(IResource iResource, IResource iResource2, URI uRI) throws CoreException {
        IPath iPath = iResource.getLocation();
        IPath iPath2 = iResource.getRawLocation();
        if (iPath != null && !iPath2.equals((Object)iPath)) {
            if (!iResource.getProject().equals(iResource2.getProject())) {
                String string = iPath2.segment(0);
                string = this.copyVariable(iResource.getProject(), iResource2.getProject(), string);
                IPath iPath3 = Path.fromPortableString((String)string).append(iPath2.removeFirstSegments(1));
                uRI = this.toURI(iPath3);
            } else {
                uRI = this.toURI(iPath2);
            }
        }
        return uRI;
    }

    URI toURI(IPath iPath) {
        if (iPath.isAbsolute()) {
            return URIUtil.toURI((IPath)iPath);
        }
        try {
            return new URI(null, null, iPath.toPortableString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return URIUtil.toURI((IPath)iPath);
        }
    }

    String copyVariable(IProject iProject, IProject iProject2, String string) throws CoreException {
        IPath iPath;
        IPathVariableManager iPathVariableManager = iProject2.getPathVariableManager();
        IPathVariableManager iPathVariableManager2 = iProject.getPathVariableManager();
        IPath iPath2 = iPathVariableManager2.getValue(string);
        if (iPath2 == null) {
            return PathVariableUtil.getUniqueVariableName(string, iPathVariableManager);
        }
        IPath iPath3 = iPathVariableManager2.resolvePath(iPath2);
        boolean bl = false;
        if (iPathVariableManager.isDefined(string)) {
            bl = true;
            if (iPathVariableManager.resolvePath(iPathVariableManager.getValue(string)).equals((Object)iPath3)) {
                return string;
            }
        }
        String[] stringArray = iPathVariableManager.getPathVariableNames();
        int n = 0;
        while (n < stringArray.length) {
            IPath iPath4;
            if (!stringArray[n].equals(WorkspaceLocationProjectVariable.NAME) && !stringArray[n].equals("PARENT") && (iPath4 = iPathVariableManager.resolvePath(iPathVariableManager.getValue(stringArray[n]))).equals((Object)iPath3)) {
                return stringArray[n];
            }
            ++n;
        }
        String string2 = PathVariableUtil.getUniqueVariableName(string, iPathVariableManager);
        boolean bl2 = true;
        if (!iPath2.equals((Object)iPath3) && !bl) {
            iPath = ProjectPathVariableManager.splitVariableNames(iPath2.toPortableString());
            bl2 = false;
            if (((IPath)iPath).length == 1 && iPath[0].startsWith("PARENT-")) {
                bl2 = true;
            }
            if (!bl2) {
                String[] stringArray2 = ProjectPathVariableManager.splitVariablesAndContent(iPath2.toPortableString());
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    String string3 = ProjectPathVariableManager.extractVariable(stringArray2[n2]);
                    if (string3.length() > 0) {
                        String string4 = this.copyVariable(iProject, iProject2, string3);
                        int n3 = stringArray2[n2].indexOf(string3);
                        if (n3 != -1) {
                            stringBuffer.append(stringArray2[n2].substring(0, n3));
                            stringBuffer.append(string4);
                            int n4 = n3 + string3.length();
                            int n5 = stringArray2[n2].length();
                            stringBuffer.append(stringArray2[n2].substring(n4, n5));
                        }
                    } else {
                        stringBuffer.append(stringArray2[n2]);
                    }
                    ++n2;
                }
                iPath2 = Path.fromPortableString((String)stringBuffer.toString());
            }
        }
        if (bl2 && (iPath = PathVariableUtil.convertToPathRelativeMacro(iPathVariableManager, iPath3, true, null)) != null) {
            iPath2 = iPath;
        }
        iPathVariableManager.setValue(string2, iPath2);
        return string2;
    }

    public int countResources(IPath iPath, int n, final boolean bl) {
        if (!this.tree.includes(iPath)) {
            return 0;
        }
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1 + this.tree.getChildCount(iPath);
            }
            case 2: {
                final int[] nArray = new int[1];
                IElementContentVisitor iElementContentVisitor = new IElementContentVisitor(){

                    public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                        if (bl || !((ResourceInfo)object).isSet(8)) {
                            nArray[0] = nArray[0] + 1;
                        }
                        return true;
                    }
                };
                new ElementTreeIterator(this.tree, iPath).iterate(iElementContentVisitor);
                return nArray[0];
            }
        }
        return 0;
    }

    public ResourceInfo createResource(IResource iResource, boolean bl) throws CoreException {
        return this.createResource(iResource, null, bl, false, false);
    }

    public ResourceInfo createResource(IResource iResource, int n) throws CoreException {
        ResourceInfo resourceInfo = this.createResource(iResource, null, false, false, false);
        if ((n & 0x400) != 0) {
            resourceInfo.set(16384);
        }
        if ((n & 0x800) != 0) {
            resourceInfo.set(32768);
        }
        if ((n & 0x1000) != 0) {
            resourceInfo.set(0x200000);
        }
        return resourceInfo;
    }

    public ResourceInfo createResource(IResource iResource, ResourceInfo resourceInfo, boolean bl, boolean bl2, boolean bl3) throws CoreException {
        resourceInfo = resourceInfo == null ? this.newElement(iResource.getType()) : (ResourceInfo)resourceInfo.clone();
        ResourceInfo resourceInfo2 = this.getResourceInfo(iResource.getFullPath(), true, false);
        if (bl) {
            resourceInfo.set(8);
            resourceInfo.clearModificationStamp();
        }
        if (resourceInfo2 == null) {
            if (!bl3) {
                resourceInfo.setSyncInfo(null);
            }
            this.tree.createElement(iResource.getFullPath(), resourceInfo);
        } else if (bl2 || !bl && resourceInfo2.isSet(8)) {
            if (!bl3) {
                resourceInfo.setSyncInfo(resourceInfo2.getSyncInfo(true));
            }
            resourceInfo.set(4096);
            this.tree.setElementData(iResource.getFullPath(), resourceInfo);
        } else {
            String string = NLS.bind((String)Messages.resources_mustNotExist, (Object)iResource.getFullPath());
            throw new ResourceException(367, iResource.getFullPath(), string, null);
        }
        return resourceInfo;
    }

    public IStatus delete(IResource[] iResourceArray, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        return this.delete(iResourceArray, n |= 2, iProgressMonitor);
    }

    /*
     * Loose catch block
     */
    public IStatus delete(IResource[] iResourceArray, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            int n2 = Math.max(iResourceArray.length, 1);
            int n3 = 100 * n2 / Policy.opWork;
            String string = Messages.resources_deleting_0;
            iProgressMonitor.beginTask(string, n3);
            string = Messages.resources_deleteProblem;
            MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 566, string, null);
            if (iResourceArray.length == 0) {
                MultiStatus multiStatus2 = multiStatus;
                return multiStatus2;
            }
            iResourceArray = (IResource[])iResourceArray.clone();
            try {
                this.prepareOperation(this.getRoot(), iProgressMonitor);
                this.beginOperation(true);
                int n4 = 0;
                while (n4 < iResourceArray.length) {
                    block17: {
                        Policy.checkCanceled(iProgressMonitor);
                        Resource resource = (Resource)iResourceArray[n4];
                        if (resource == null) {
                            iProgressMonitor.worked(1);
                        } else {
                            try {
                                resource.delete(n, Policy.subMonitorFor(iProgressMonitor, 1));
                            }
                            catch (CoreException coreException) {
                                ResourceInfo resourceInfo = resource.getResourceInfo(false, false);
                                if (!resource.exists(resource.getFlags(resourceInfo), false)) break block17;
                                string = NLS.bind((String)Messages.resources_couldnotDelete, (Object)resource.getFullPath());
                                multiStatus.merge((IStatus)new ResourceStatus(273, resource.getFullPath(), string));
                                multiStatus.merge(coreException.getStatus());
                            }
                        }
                    }
                    ++n4;
                }
                if (multiStatus.matches(4)) {
                    throw new ResourceException((IStatus)multiStatus);
                }
                MultiStatus multiStatus3 = multiStatus;
                return multiStatus3;
            }
            catch (OperationCanceledException operationCanceledException) {
                this.getWorkManager().operationCanceled();
                throw operationCanceledException;
            }
            finally {
                this.endOperation(this.getRoot(), true, Policy.subMonitorFor(iProgressMonitor, n3 - n2));
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void deleteMarkers(IMarker[] iMarkerArray) throws CoreException {
        Assert.isNotNull((Object)iMarkerArray);
        if (iMarkerArray.length == 0) {
            return;
        }
        iMarkerArray = (IMarker[])iMarkerArray.clone();
        try {
            this.prepareOperation(null, null);
            this.beginOperation(true);
            int n = 0;
            while (n < iMarkerArray.length) {
                if (iMarkerArray[n] != null && iMarkerArray[n].getResource() != null) {
                    this.markerManager.removeMarker(iMarkerArray[n].getResource(), iMarkerArray[n].getId());
                }
                ++n;
            }
        }
        finally {
            this.endOperation(null, false, null);
        }
    }

    void deleteResource(IResource iResource) {
        IPath iPath = iResource.getFullPath();
        if (iPath.equals((Object)Path.ROOT)) {
            IProject[] iProjectArray = this.getRoot().getProjects(8);
            int n = 0;
            while (n < iProjectArray.length) {
                this.tree.deleteElement(iProjectArray[n].getFullPath());
                ++n;
            }
        } else {
            this.tree.deleteElement(iPath);
        }
    }

    public void endOperation(ISchedulingRule iSchedulingRule, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        WorkManager workManager = this.getWorkManager();
        if (workManager.checkInFailed(iSchedulingRule)) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            workManager.setBuild(bl);
            boolean bl4 = bl3 = workManager.getPreparedOperationDepth() == 1;
            if (!this.notificationManager.shouldNotify() && !bl3) {
                this.notificationManager.requestNotify();
                return;
            }
            try {
                this.notificationManager.beginNotify();
                Assert.isTrue((workManager.getPreparedOperationDepth() > 0 ? 1 : 0) != 0, (String)"Mismatched begin/endOperation");
                workManager.rebalanceNestedOperations();
                bl2 = workManager.shouldBuild();
                if (bl2) {
                    bl2 = this.operationTree != null && ElementTree.hasChanges(this.tree, this.operationTree, ResourceComparator.getBuildComparator(), true);
                }
                this.broadcastPostChange();
                this.saveManager.snapshotIfNeeded(bl2);
            }
            finally {
                if (bl3) {
                    this.tree.immutable();
                    this.operationTree = null;
                } else {
                    this.newWorkingTree();
                }
            }
        }
        finally {
            workManager.checkOut(iSchedulingRule);
        }
        if (bl3) {
            this.buildManager.endTopLevel(bl2);
        }
    }

    protected void flushBuildOrder() {
        if (this.description.getBuildOrder(false) == null) {
            this.buildOrder = null;
        }
    }

    public void forgetSavedTree(String string) {
        this.saveManager.forgetSavedTree(string);
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public BuildManager getBuildManager() {
        return this.buildManager;
    }

    public IProject[] getBuildOrder() {
        if (this.buildOrder != null) {
            return this.buildOrder;
        }
        String[] stringArray = this.description.getBuildOrder(false);
        if (stringArray != null) {
            ArrayList<IProject> arrayList = new ArrayList<IProject>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                IProject iProject = this.getRoot().getProject(stringArray[n]);
                if (iProject.isAccessible()) {
                    arrayList.add(iProject);
                }
                ++n;
            }
            this.buildOrder = new IProject[arrayList.size()];
            arrayList.toArray(this.buildOrder);
        } else {
            this.buildOrder = this.computeFullProjectOrder().projects;
        }
        return this.buildOrder;
    }

    public CharsetManager getCharsetManager() {
        return this.charsetManager;
    }

    public ContentDescriptionManager getContentDescriptionManager() {
        return this.contentDescriptionManager;
    }

    public Map getDanglingReferences() {
        IProject[] iProjectArray = this.getRoot().getProjects(8);
        HashMap<IProject, IProject[]> hashMap = new HashMap<IProject, IProject[]>(iProjectArray.length);
        int n = 0;
        while (n < iProjectArray.length) {
            Project project = (Project)iProjectArray[n];
            if (project.isAccessible()) {
                IProject[] iProjectArray2 = project.internalGetDescription().getReferencedProjects(false);
                ArrayList<IProject> arrayList = new ArrayList<IProject>(iProjectArray2.length);
                int n2 = 0;
                while (n2 < iProjectArray2.length) {
                    if (!iProjectArray2[n].exists()) {
                        arrayList.add(iProjectArray2[n]);
                    }
                    ++n2;
                }
                if (!arrayList.isEmpty()) {
                    hashMap.put(iProjectArray[n], arrayList.toArray(new IProject[arrayList.size()]));
                }
            }
            ++n;
        }
        return hashMap;
    }

    public IWorkspaceDescription getDescription() {
        WorkspaceDescription workspaceDescription = Workspace.defaultWorkspaceDescription();
        this.description.copyTo(workspaceDescription);
        return workspaceDescription;
    }

    public ElementTree getElementTree() {
        return this.tree;
    }

    public FileSystemResourceManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public MarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public LocalMetaArea getMetaArea() {
        return this.localMetaArea;
    }

    protected IMoveDeleteHook getMoveDeleteHook() {
        if (this.moveDeleteHook == null) {
            this.initializeMoveDeleteHook();
        }
        return this.moveDeleteHook;
    }

    public IProjectNatureDescriptor getNatureDescriptor(String string) {
        return this.natureManager.getNatureDescriptor(string);
    }

    public IProjectNatureDescriptor[] getNatureDescriptors() {
        return this.natureManager.getNatureDescriptors();
    }

    public NatureManager getNatureManager() {
        return this.natureManager;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public IPathVariableManager getPathVariableManager() {
        return this.pathVariableManager;
    }

    public IPropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public RefreshManager getRefreshManager() {
        return this.refreshManager;
    }

    public ResourceInfo getResourceInfo(IPath iPath, boolean bl, boolean bl2) {
        ResourceInfo resourceInfo;
        block6: {
            block5: {
                try {
                    if (iPath.segmentCount() == 0) {
                        ResourceInfo resourceInfo2 = (ResourceInfo)this.tree.getTreeData();
                        Assert.isNotNull((Object)resourceInfo2, (String)"Tree root info must never be null");
                        return resourceInfo2;
                    }
                    resourceInfo = null;
                    if (this.tree.includes(iPath)) break block5;
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            resourceInfo = bl2 ? (ResourceInfo)this.tree.openElementData(iPath) : (ResourceInfo)this.tree.getElementData(iPath);
            if (resourceInfo == null || bl || !resourceInfo.isSet(8)) break block6;
            return null;
        }
        return resourceInfo;
    }

    public IWorkspaceRoot getRoot() {
        return this.defaultRoot;
    }

    public IResourceRuleFactory getRuleFactory() {
        if (this.ruleFactory == null) {
            this.ruleFactory = new Rules(this);
        }
        return this.ruleFactory;
    }

    public SaveManager getSaveManager() {
        return this.saveManager;
    }

    public ISynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    protected TeamHook getTeamHook() {
        if (this.teamHook == null) {
            this.initializeTeamHook();
        }
        return this.teamHook;
    }

    public WorkManager getWorkManager() throws CoreException {
        if (this._workManager == null) {
            String string = Messages.resources_shutdown;
            throw new ResourceException(new ResourceStatus(566, null, string));
        }
        return this._workManager;
    }

    protected void initializeMoveDeleteHook() {
        try {
            if (!this.canCreateExtensions()) {
                return;
            }
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "moveDeleteHook");
            if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
                return;
            }
            if (iConfigurationElementArray.length > 1) {
                ResourceStatus resourceStatus = new ResourceStatus(4, 1, null, Messages.resources_oneHook, null);
                Policy.log(resourceStatus);
                return;
            }
            try {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
                this.moveDeleteHook = (IMoveDeleteHook)iConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                if (this.canCreateExtensions()) {
                    ResourceStatus resourceStatus = new ResourceStatus(4, 1, null, Messages.resources_initHook, coreException);
                    Policy.log(resourceStatus);
                }
            }
        }
        finally {
            if (this.moveDeleteHook == null) {
                this.moveDeleteHook = new MoveDeleteHook();
            }
        }
    }

    protected void initializeTeamHook() {
        IConfigurationElement[] iConfigurationElementArray;
        block14: {
            block15: {
                block12: {
                    block13: {
                        block10: {
                            block11: {
                                try {
                                    if (this.canCreateExtensions()) break block10;
                                    if (this.teamHook != null) break block11;
                                }
                                catch (Throwable throwable) {
                                    if (this.teamHook == null) {
                                        this.teamHook = new TeamHook(){};
                                    }
                                    throw throwable;
                                }
                                this.teamHook = new /* invalid duplicate definition of identical inner class */;
                            }
                            return;
                        }
                        iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "teamHook");
                        if (iConfigurationElementArray != null && iConfigurationElementArray.length != 0) break block12;
                        if (this.teamHook != null) break block13;
                        this.teamHook = new /* invalid duplicate definition of identical inner class */;
                    }
                    return;
                }
                if (iConfigurationElementArray.length <= 1) break block14;
                ResourceStatus resourceStatus = new ResourceStatus(4, 1, null, Messages.resources_oneTeamHook, null);
                Policy.log(resourceStatus);
                if (this.teamHook != null) break block15;
                this.teamHook = new /* invalid duplicate definition of identical inner class */;
            }
            return;
        }
        try {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
            this.teamHook = (TeamHook)iConfigurationElement.createExecutableExtension("class");
        }
        catch (CoreException coreException) {
            if (this.canCreateExtensions()) {
                ResourceStatus resourceStatus = new ResourceStatus(4, 1, null, Messages.resources_initTeamHook, coreException);
                Policy.log(resourceStatus);
            }
        }
        if (this.teamHook == null) {
            this.teamHook = new /* invalid duplicate definition of identical inner class */;
        }
    }

    protected void initializeValidator() {
        block5: {
            this.shouldValidate = false;
            if (!this.canCreateExtensions()) {
                return;
            }
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "fileModificationValidator");
            if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
                return;
            }
            if (iConfigurationElementArray.length > 1) {
                ResourceStatus resourceStatus = new ResourceStatus(4, 1, null, Messages.resources_oneValidator, null);
                Policy.log(resourceStatus);
                return;
            }
            try {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
                this.validator = (IFileModificationValidator)iConfigurationElement.createExecutableExtension("class");
                this.shouldValidate = true;
            }
            catch (CoreException coreException) {
                if (!this.canCreateExtensions()) break block5;
                ResourceStatus resourceStatus = new ResourceStatus(4, 1, null, Messages.resources_initValidator, coreException);
                Policy.log(resourceStatus);
            }
        }
    }

    public WorkspaceDescription internalGetDescription() {
        return this.description;
    }

    public boolean isAutoBuilding() {
        return this.description.isAutoBuilding();
    }

    public boolean isOpen() {
        return this.openFlag;
    }

    public boolean isTreeLocked() {
        return this.treeLocked == Thread.currentThread();
    }

    protected void linkTrees(IPath iPath, ElementTree[] elementTreeArray) {
        this.tree = this.tree.mergeDeltaChain(iPath, elementTreeArray);
    }

    public IProjectDescription loadProjectDescription(InputStream inputStream) throws CoreException {
        ProjectDescription projectDescription = null;
        projectDescription = new ProjectDescriptionReader().read(new InputSource(inputStream));
        if (projectDescription == null) {
            String string = NLS.bind((String)Messages.resources_errorReadProject, (Object)inputStream.toString());
            Status status = new Status(4, "org.eclipse.core.resources", 567, string, null);
            throw new ResourceException((IStatus)status);
        }
        return projectDescription;
    }

    public IProjectDescription loadProjectDescription(IPath iPath) throws CoreException {
        IPath iPath2;
        String string;
        ProjectDescription projectDescription = null;
        IOException iOException = null;
        try {
            projectDescription = new ProjectDescriptionReader().read(iPath);
            if (projectDescription != null) {
                string = iPath.removeLastSegments(1);
                iPath2 = this.getRoot().getLocation().append(projectDescription.getName());
                if (!string.toFile().equals(iPath2.toFile())) {
                    projectDescription.setLocation((IPath)string);
                }
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (projectDescription == null || iOException != null) {
            string = NLS.bind((String)Messages.resources_errorReadProject, (Object)iPath.toOSString());
            iPath2 = new Status(4, "org.eclipse.core.resources", 567, string, (Throwable)iOException);
            throw new ResourceException((IStatus)iPath2);
        }
        return projectDescription;
    }

    public IStatus move(IResource[] iResourceArray, IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        return this.move(iResourceArray, iPath, n |= 2, iProgressMonitor);
    }

    public IStatus move(IResource[] iResourceArray, IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            Assert.isLegal((iResourceArray != null ? 1 : 0) != 0);
            int n2 = Math.max(iResourceArray.length, 1);
            int n3 = 100 * n2 / Policy.opWork;
            String string = Messages.resources_moving_0;
            iProgressMonitor.beginTask(string, n3);
            if (iResourceArray.length == 0) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            iResourceArray = (IResource[])iResourceArray.clone();
            IPath iPath2 = null;
            string = Messages.resources_moveProblem;
            MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 566, string, null);
            try {
                try {
                    this.prepareOperation(this.getRoot(), iProgressMonitor);
                    this.beginOperation(true);
                    int n4 = 0;
                    while (n4 < iResourceArray.length) {
                        block22: {
                            Policy.checkCanceled(iProgressMonitor);
                            Resource resource = (Resource)iResourceArray[n4];
                            if (resource == null || Workspace.isDuplicate(iResourceArray, n4)) {
                                iProgressMonitor.worked(1);
                            } else {
                                if (iPath2 == null) {
                                    iPath2 = resource.getFullPath().removeLastSegments(1);
                                }
                                if (iPath2.equals((Object)resource.getFullPath().removeLastSegments(1))) {
                                    try {
                                        IStatus iStatus = resource.checkMoveRequirements(iPath.append(resource.getName()), resource.getType(), n);
                                        if (iStatus.isOK()) {
                                            try {
                                                resource.move(iPath.append(resource.getName()), n, Policy.subMonitorFor(iProgressMonitor, 1));
                                            }
                                            catch (CoreException coreException) {
                                                multiStatus.merge(coreException.getStatus());
                                            }
                                            break block22;
                                        }
                                        iProgressMonitor.worked(1);
                                        multiStatus.merge(iStatus);
                                    }
                                    catch (CoreException coreException) {
                                        iProgressMonitor.worked(1);
                                        multiStatus.merge(coreException.getStatus());
                                    }
                                } else {
                                    iProgressMonitor.worked(1);
                                    string = NLS.bind((String)Messages.resources_notChild, (Object)resource.getFullPath(), (Object)iPath2);
                                    multiStatus.merge((IStatus)new ResourceStatus(76, resource.getFullPath(), string));
                                }
                            }
                        }
                        ++n4;
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                this.endOperation(this.getRoot(), true, Policy.subMonitorFor(iProgressMonitor, n3 - n2));
            }
            if (multiStatus.matches(4)) {
                throw new ResourceException((IStatus)multiStatus);
            }
            IStatus iStatus = multiStatus.isOK() ? Status.OK_STATUS : multiStatus;
            return iStatus;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    void move(Resource resource, IPath iPath, int n, int n2, boolean bl) throws CoreException {
        this.copyTree(resource, iPath, n, n2, bl, true, resource.getType() == 4);
        resource.fixupAfterMoveSource();
    }

    protected ResourceInfo newElement(int n) {
        ResourceInfo resourceInfo = null;
        switch (n) {
            case 1: 
            case 2: {
                resourceInfo = new ResourceInfo();
                break;
            }
            case 4: {
                resourceInfo = new ProjectInfo();
                break;
            }
            case 8: {
                resourceInfo = new RootInfo();
            }
        }
        resourceInfo.setNodeId(this.nextNodeId());
        this.updateModificationStamp(resourceInfo);
        resourceInfo.setType(n);
        return resourceInfo;
    }

    public IProjectDescription newProjectDescription(String string) {
        ProjectDescription projectDescription = new ProjectDescription();
        projectDescription.setName(string);
        return projectDescription;
    }

    public Resource newResource(IPath iPath, int n) {
        switch (n) {
            case 2: {
                if (iPath.segmentCount() < 2) {
                    String string = "Path must include project and resource name: " + iPath.toString();
                    Assert.isLegal((boolean)false, (String)string);
                }
                return new Folder(iPath.makeAbsolute(), this);
            }
            case 1: {
                if (iPath.segmentCount() < 2) {
                    String string = "Path must include project and resource name: " + iPath.toString();
                    Assert.isLegal((boolean)false, (String)string);
                }
                return new File(iPath.makeAbsolute(), this);
            }
            case 4: {
                return (Resource)((Object)this.getRoot().getProject(iPath.lastSegment()));
            }
            case 8: {
                return (Resource)((Object)this.getRoot());
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    public ElementTree newWorkingTree() {
        this.tree = this.tree.newEmptyDelta();
        return this.tree;
    }

    protected long nextMarkerId() {
        return this.nextMarkerId++;
    }

    protected long nextNodeId() {
        return this.nextNodeId++;
    }

    public IStatus open(IProgressMonitor iProgressMonitor) throws CoreException {
        String string = Messages.resources_workspaceOpen;
        Assert.isTrue((!this.isOpen() ? 1 : 0) != 0, (String)string);
        if (!this.getMetaArea().hasSavedWorkspace()) {
            string = Messages.resources_readWorkspaceMeta;
            throw new ResourceException(567, Platform.getLocation(), string, null);
        }
        this.description = new WorkspacePreferences();
        WorkspaceDescription workspaceDescription = this.getMetaArea().readOldWorkspace();
        if (workspaceDescription != null) {
            this.description.copyFrom(workspaceDescription);
            ResourcesPlugin.getPlugin().savePluginPreferences();
        }
        this.localMetaArea.locationFor(this.getRoot()).toFile().mkdirs();
        IProgressMonitor iProgressMonitor2 = Policy.monitorFor(null);
        this.startup(iProgressMonitor2);
        this.notificationManager.startup(null);
        this.openFlag = true;
        if (this.crashed || this.refreshRequested()) {
            try {
                this.refreshManager.refresh(this.getRoot());
            }
            catch (RuntimeException runtimeException) {
                return new ResourceStatus(566, (IPath)Path.ROOT, Messages.resources_errorMultiRefresh, runtimeException);
            }
        }
        this.stringPoolJob = new StringPoolJob();
        this.stringPoolJob.addStringPoolParticipant(this.saveManager, this.getRoot());
        return Status.OK_STATUS;
    }

    public void prepareOperation(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            if (iSchedulingRule != null && iSchedulingRule.isConflicting(this.getRuleFactory().buildRule())) {
                this.buildManager.interrupt();
            }
        }
        finally {
            this.getWorkManager().checkIn(iSchedulingRule, iProgressMonitor);
        }
        if (!this.isOpen()) {
            String string = Messages.resources_workspaceClosed;
            throw new ResourceException(76, null, string, null);
        }
    }

    protected boolean refreshRequested() {
        String[] stringArray = Platform.getCommandLineArgs();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-refresh")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void removeResourceChangeListener(IResourceChangeListener iResourceChangeListener) {
        this.notificationManager.removeListener(iResourceChangeListener);
    }

    public void removeSaveParticipant(Plugin plugin) {
        Assert.isNotNull((Object)plugin, (String)"Plugin must not be null");
        this.saveManager.removeParticipant(plugin);
    }

    public void run(IWorkspaceRunnable iWorkspaceRunnable, IProgressMonitor iProgressMonitor) throws CoreException {
        this.run(iWorkspaceRunnable, this.defaultRoot, 1, iProgressMonitor);
    }

    public void run(IWorkspaceRunnable iWorkspaceRunnable, ISchedulingRule iSchedulingRule, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 100);
            int n2 = -1;
            boolean bl = (n & 1) != 0;
            try {
                try {
                    this.prepareOperation(iSchedulingRule, iProgressMonitor);
                    this.beginOperation(true);
                    if (bl) {
                        bl = this.notificationManager.beginAvoidNotify();
                    }
                    n2 = this.getWorkManager().beginUnprotected();
                    iWorkspaceRunnable.run(Policy.subMonitorFor(iProgressMonitor, Policy.opWork, 4));
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.getWorkManager().operationCanceled();
                    throw operationCanceledException;
                }
            }
            finally {
                if (bl) {
                    this.notificationManager.endAvoidNotify();
                }
                if (n2 >= 0) {
                    this.getWorkManager().endUnprotected(n2);
                }
                this.endOperation(iSchedulingRule, false, Policy.subMonitorFor(iProgressMonitor, Policy.endOpWork));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public IStatus save(boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        if (bl) {
            if (this.getWorkManager().isLockAlreadyAcquired()) {
                String string = Messages.resources_saveOp;
                throw new ResourceException(76, null, string, new IllegalStateException());
            }
            return this.saveManager.save(1, null, iProgressMonitor);
        }
        try {
            this.prepareOperation(this.getRoot(), iProgressMonitor);
            this.beginOperation(false);
            this.saveManager.requestSnapshot();
            String string = Messages.resources_snapRequest;
            ResourceStatus resourceStatus = new ResourceStatus(0, string);
            return resourceStatus;
        }
        finally {
            this.endOperation(this.getRoot(), false, null);
        }
    }

    public void setCrashed(boolean bl) {
        this.crashed = bl;
        if (this.crashed) {
            String string = "The workspace exited with unsaved changes in the previous session; refreshing workspace to recover changes.";
            Policy.log(new ResourceStatus(10035, string));
            if (Policy.DEBUG) {
                System.out.println(string);
            }
        }
    }

    public void setDescription(IWorkspaceDescription iWorkspaceDescription) {
        WorkspaceDescription workspaceDescription = (WorkspaceDescription)iWorkspaceDescription;
        String[] stringArray = workspaceDescription.getBuildOrder(false);
        if (this.description.getBuildOrder(false) != null || stringArray != null) {
            this.buildOrder = null;
        }
        this.description.copyFrom(workspaceDescription);
        ResourcesPlugin.getPlugin().savePluginPreferences();
    }

    public void setTreeLocked(boolean bl) {
        Assert.isTrue((!bl || this.treeLocked == null ? 1 : 0) != 0, (String)"The workspace tree is already locked");
        this.treeLocked = bl ? Thread.currentThread() : null;
    }

    public void setWorkspaceLock(WorkspaceLock workspaceLock) {
    }

    protected void shutdown(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            IManager[] iManagerArray = new IManager[]{this.buildManager, this.propertyManager, this.pathVariableManager, this.charsetManager, this.fileSystemManager, this.markerManager, this._workManager, this.aliasManager, this.refreshManager, this.contentDescriptionManager};
            iProgressMonitor.beginTask("", iManagerArray.length);
            String string = Messages.resources_shutdownProblems;
            MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 566, string, null);
            int n = 0;
            while (n < iManagerArray.length) {
                IManager iManager = iManagerArray[n];
                if (iManager == null) {
                    iProgressMonitor.worked(1);
                } else {
                    try {
                        iManager.shutdown(Policy.subMonitorFor(iProgressMonitor, 1));
                    }
                    catch (Exception exception) {
                        string = Messages.resources_shutdownProblems;
                        multiStatus.add((IStatus)new Status(4, "org.eclipse.core.resources", 566, string, (Throwable)exception));
                    }
                }
                ++n;
            }
            this.buildManager = null;
            this.notificationManager = null;
            this.propertyManager = null;
            this.pathVariableManager = null;
            this.fileSystemManager = null;
            this.markerManager = null;
            this.synchronizer = null;
            this.saveManager = null;
            this._workManager = null;
            this.aliasManager = null;
            this.refreshManager = null;
            this.charsetManager = null;
            this.contentDescriptionManager = null;
            if (!multiStatus.isOK()) {
                throw new CoreException((IStatus)multiStatus);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public String[] sortNatureSet(String[] stringArray) {
        return this.natureManager.sortNatureSet(stringArray);
    }

    protected void startup(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            this._workManager = new WorkManager(this);
            this._workManager.startup(null);
            this.fileSystemManager = new FileSystemResourceManager(this);
            this.fileSystemManager.startup(iProgressMonitor);
            this.pathVariableManager = new PathVariableManager();
            this.pathVariableManager.startup(null);
            this.natureManager = new NatureManager();
            this.natureManager.startup(null);
            this.buildManager = new BuildManager(this, this.getWorkManager().getLock());
            this.buildManager.startup(null);
            this.notificationManager = new NotificationManager(this);
            this.notificationManager.startup(null);
            this.markerManager = new MarkerManager(this);
            this.markerManager.startup(null);
            this.synchronizer = new Synchronizer(this);
            this.refreshManager = new RefreshManager(this);
            this.saveManager = new SaveManager(this);
            this.saveManager.startup(null);
            this.refreshManager.startup(null);
            this.aliasManager = new AliasManager(this);
            this.aliasManager.startup(null);
            this.propertyManager = ResourcesCompatibilityHelper.createPropertyManager();
            this.propertyManager.startup(iProgressMonitor);
            this.charsetManager = new CharsetManager(this);
            this.charsetManager.startup(null);
            this.contentDescriptionManager = new ContentDescriptionManager();
            this.contentDescriptionManager.startup(null);
        }
        finally {
            this.treeLocked = null;
            this._workManager.postWorkspaceStartup();
        }
    }

    public String toDebugString() {
        final StringBuffer stringBuffer = new StringBuffer("\nDump of " + this.toString() + ":\n");
        stringBuffer.append("  parent: " + this.tree.getParent());
        IElementContentVisitor iElementContentVisitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                stringBuffer.append("\n  " + iPathRequestor.requestPath() + ": " + object);
                return true;
            }
        };
        new ElementTreeIterator(this.tree, (IPath)Path.ROOT).iterate(iElementContentVisitor);
        return stringBuffer.toString();
    }

    public void updateModificationStamp(ResourceInfo resourceInfo) {
        resourceInfo.incrementModificationStamp();
    }

    public IStatus validateEdit(final IFile[] iFileArray, final Object object) {
        if (!this.shouldValidate) {
            String string = Messages.resources_readOnly2;
            MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 279, string, null);
            int n = 0;
            while (n < iFileArray.length) {
                if (iFileArray[n].isReadOnly()) {
                    IPath iPath = iFileArray[n].getFullPath();
                    string = NLS.bind((String)Messages.resources_readOnly, (Object)iPath);
                    multiStatus.add((IStatus)new ResourceStatus(279, iPath, string));
                }
                ++n;
            }
            return multiStatus.getChildren().length == 0 ? Status.OK_STATUS : multiStatus;
        }
        if (this.validator == null) {
            this.initializeValidator();
        }
        if (this.validator == null) {
            return Status.OK_STATUS;
        }
        final IStatus[] iStatusArray = new IStatus[1];
        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

            public void handleException(Throwable throwable) {
                iStatusArray[0] = new ResourceStatus(4, null, Messages.resources_errorValidator, throwable);
            }

            public void run() throws Exception {
                Object object2 = object;
                if (!(Workspace.this.validator instanceof FileModificationValidator) && object2 instanceof FileModificationValidationContext) {
                    object2 = null;
                }
                iStatusArray[0] = Workspace.this.validator.validateEdit(iFileArray, object2);
            }
        };
        SafeRunner.run((ISafeRunnable)iSafeRunnable);
        return iStatusArray[0];
    }

    public IStatus validateLinkLocation(IResource iResource, IPath iPath) {
        return this.locationValidator.validateLinkLocation(iResource, iPath);
    }

    public IStatus validateLinkLocationURI(IResource iResource, URI uRI) {
        return this.locationValidator.validateLinkLocationURI(iResource, uRI);
    }

    public IStatus validateName(String string, int n) {
        return this.locationValidator.validateName(string, n);
    }

    public IStatus validateNatureSet(String[] stringArray) {
        return this.natureManager.validateNatureSet(stringArray);
    }

    public IStatus validatePath(String string, int n) {
        return this.locationValidator.validatePath(string, n);
    }

    public IStatus validateProjectLocation(IProject iProject, IPath iPath) {
        return this.locationValidator.validateProjectLocation(iProject, iPath);
    }

    public IStatus validateProjectLocationURI(IProject iProject, URI uRI) {
        return this.locationValidator.validateProjectLocationURI(iProject, uRI);
    }

    protected void validateSave(final IFile iFile) throws CoreException {
        if (!this.shouldValidate) {
            return;
        }
        if (this.validator == null) {
            this.initializeValidator();
        }
        if (this.validator == null) {
            return;
        }
        final IStatus[] iStatusArray = new IStatus[1];
        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

            public void handleException(Throwable throwable) {
                iStatusArray[0] = new ResourceStatus(4, null, Messages.resources_errorValidator, throwable);
            }

            public void run() throws Exception {
                iStatusArray[0] = Workspace.this.validator.validateSave(iFile);
            }
        };
        SafeRunner.run((ISafeRunnable)iSafeRunnable);
        if (!iStatusArray[0].isOK()) {
            throw new ResourceException(iStatusArray[0]);
        }
    }
}

