/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.ModelObject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class WorkspaceDescription
extends ModelObject
implements IWorkspaceDescription {
    protected boolean autoBuilding;
    protected String[] buildOrder;
    protected volatile long fileStateLongevity;
    protected int maxBuildIterations;
    protected int maxFileStates;
    protected volatile long maxFileStateSize;
    private volatile long snapshotInterval;
    protected int operationsPerSnapshot;
    protected long deltaExpiration;

    public WorkspaceDescription(String string) {
        super(string);
        IEclipsePreferences iEclipsePreferences = new DefaultScope().getNode("org.eclipse.core.resources");
        this.autoBuilding = iEclipsePreferences.getBoolean("description.autobuilding", true);
        this.fileStateLongevity = iEclipsePreferences.getLong("description.filestatelongevity", 604800000L);
        this.maxBuildIterations = iEclipsePreferences.getInt("description.maxbuilditerations", 10);
        this.maxFileStates = iEclipsePreferences.getInt("description.maxfilestates", 50);
        this.maxFileStateSize = iEclipsePreferences.getLong("description.maxfilestatesize", 0x100000L);
        this.snapshotInterval = iEclipsePreferences.getLong("description.snapshotinterval", 300000L);
        this.operationsPerSnapshot = iEclipsePreferences.getInt("snapshots.operations", 100);
        this.deltaExpiration = iEclipsePreferences.getLong("delta.expiration", 2592000000L);
    }

    public String[] getBuildOrder() {
        return this.getBuildOrder(true);
    }

    public String[] getBuildOrder(boolean bl) {
        if (this.buildOrder == null) {
            return null;
        }
        return bl ? (String[])this.buildOrder.clone() : this.buildOrder;
    }

    public long getDeltaExpiration() {
        return this.deltaExpiration;
    }

    public void setDeltaExpiration(long l) {
        this.deltaExpiration = l;
    }

    public long getFileStateLongevity() {
        return this.fileStateLongevity;
    }

    public int getMaxBuildIterations() {
        return this.maxBuildIterations;
    }

    public int getMaxFileStates() {
        return this.maxFileStates;
    }

    public long getMaxFileStateSize() {
        return this.maxFileStateSize;
    }

    public int getOperationsPerSnapshot() {
        return this.operationsPerSnapshot;
    }

    public long getSnapshotInterval() {
        return this.snapshotInterval;
    }

    public void internalSetBuildOrder(String[] stringArray) {
        this.buildOrder = stringArray;
    }

    public boolean isAutoBuilding() {
        return this.autoBuilding;
    }

    public void setOperationsPerSnapshot(int n) {
        this.operationsPerSnapshot = n;
    }

    public void setAutoBuilding(boolean bl) {
        this.autoBuilding = bl;
    }

    public void setBuildOrder(String[] stringArray) {
        this.buildOrder = stringArray == null ? null : (String[])stringArray.clone();
    }

    public void setFileStateLongevity(long l) {
        this.fileStateLongevity = l;
    }

    public void setMaxBuildIterations(int n) {
        this.maxBuildIterations = n;
    }

    public void setMaxFileStates(int n) {
        this.maxFileStates = n;
    }

    public void setMaxFileStateSize(long l) {
        this.maxFileStateSize = l;
    }

    public void setSnapshotInterval(long l) {
        this.snapshotInterval = l;
    }
}

