/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.resources.IModelObjectConstants;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WorkspaceDescriptionReader
implements IModelObjectConstants {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected String getString(Node node, String string) {
        Node node2 = this.searchNode(node, string);
        return node2 != null ? (node2.getFirstChild() == null ? null : node2.getFirstChild().getNodeValue()) : null;
    }

    protected String[] getStrings(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(nodeList.getLength());
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeType() == 1) {
                arrayList.add(this.read(node2.getChildNodes().item(0)));
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void logNumberFormatException(String string, NumberFormatException numberFormatException) {
        String string2 = NLS.bind((String)Messages.resources_readWorkspaceMetaValue, (Object)string);
        Policy.log(new ResourceStatus(567, null, string2, numberFormatException));
    }

    public Object read(InputStream inputStream) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return this.read(document.getFirstChild());
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return null;
    }

    public Object read(IPath iPath, IPath iPath2) throws IOException {
        SafeFileInputStream safeFileInputStream = new SafeFileInputStream(iPath.toOSString(), iPath2.toOSString());
        try {
            Object object = this.read(safeFileInputStream);
            return object;
        }
        finally {
            safeFileInputStream.close();
        }
    }

    protected Object read(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                if (node.getNodeName().equals("workspaceDescription")) {
                    return this.readWorkspaceDescription(node);
                }
            }
            case 3: {
                String string = node.getNodeValue();
                return string == null ? null : string.trim();
            }
        }
        return node.toString();
    }

    protected WorkspaceDescription readWorkspaceDescription(Node node) {
        String string = this.getString(node, "name");
        String string2 = this.getString(node, "autobuild");
        String string3 = this.getString(node, "snapshotInterval");
        String string4 = this.getString(node, "fileStateLongevity");
        String string5 = this.getString(node, "maxFileStateSize");
        String string6 = this.getString(node, "maxFileStates");
        String[] stringArray = this.getStrings(this.searchNode(node, "buildOrder"));
        WorkspaceDescription workspaceDescription = new WorkspaceDescription(string);
        if (string2 != null) {
            workspaceDescription.setAutoBuilding(!string2.equals(Integer.toString(0)));
        }
        try {
            if (string4 != null) {
                workspaceDescription.setFileStateLongevity(Long.parseLong(string4));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logNumberFormatException(string4, numberFormatException);
        }
        try {
            if (string5 != null) {
                workspaceDescription.setMaxFileStateSize(Long.parseLong(string5));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logNumberFormatException(string5, numberFormatException);
        }
        try {
            if (string6 != null) {
                workspaceDescription.setMaxFileStates(Integer.parseInt(string6));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logNumberFormatException(string6, numberFormatException);
        }
        if (stringArray != null) {
            workspaceDescription.internalSetBuildOrder(stringArray);
        }
        try {
            if (string3 != null) {
                workspaceDescription.setSnapshotInterval(Long.parseLong(string3));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logNumberFormatException(string3, numberFormatException);
        }
        return workspaceDescription;
    }

    protected Node searchNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeName().equals(string)) {
                return nodeList.item(n);
            }
            ++n;
        }
        return null;
    }
}

