/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;

public class WorkspacePreferences
extends WorkspaceDescription {
    public static final String PROJECT_SEPARATOR = "/";
    private Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();

    public static String convertStringArraytoString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(PROJECT_SEPARATOR);
            ++n;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static String[] convertStringToStringArray(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void copyFromTo(WorkspaceDescription workspaceDescription, WorkspaceDescription workspaceDescription2) {
        workspaceDescription2.setAutoBuilding(workspaceDescription.isAutoBuilding());
        workspaceDescription2.setBuildOrder(workspaceDescription.getBuildOrder());
        workspaceDescription2.setFileStateLongevity(workspaceDescription.getFileStateLongevity());
        workspaceDescription2.setMaxBuildIterations(workspaceDescription.getMaxBuildIterations());
        workspaceDescription2.setMaxFileStates(workspaceDescription.getMaxFileStates());
        workspaceDescription2.setMaxFileStateSize(workspaceDescription.getMaxFileStateSize());
        workspaceDescription2.setSnapshotInterval(workspaceDescription.getSnapshotInterval());
        workspaceDescription2.setOperationsPerSnapshot(workspaceDescription.getOperationsPerSnapshot());
        workspaceDescription2.setDeltaExpiration(workspaceDescription.getDeltaExpiration());
    }

    public WorkspacePreferences() {
        super("Workspace");
        String string = this.preferences.getString("version");
        if (!"1".equals(string)) {
            this.upgradeVersion(string);
        }
        super.setAutoBuilding(this.preferences.getBoolean("description.autobuilding"));
        super.setSnapshotInterval(this.preferences.getInt("description.snapshotinterval"));
        super.setMaxBuildIterations(this.preferences.getInt("description.maxbuilditerations"));
        super.setMaxFileStates(this.preferences.getInt("description.maxfilestates"));
        super.setMaxFileStateSize(this.preferences.getLong("description.maxfilestatesize"));
        super.setFileStateLongevity(this.preferences.getLong("description.filestatelongevity"));
        super.setOperationsPerSnapshot(this.preferences.getInt("snapshots.operations"));
        super.setDeltaExpiration(this.preferences.getLong("delta.expiration"));
        this.preferences.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                WorkspacePreferences.this.synchronizeWithPreferences(propertyChangeEvent.getProperty());
            }
        });
    }

    public Object clone() {
        throw new UnsupportedOperationException("clone() is not supported in " + this.getClass().getName());
    }

    public void copyFrom(WorkspaceDescription workspaceDescription) {
        WorkspacePreferences.copyFromTo(workspaceDescription, this);
    }

    public void copyTo(WorkspaceDescription workspaceDescription) {
        WorkspacePreferences.copyFromTo(this, workspaceDescription);
    }

    public String[] getBuildOrder() {
        boolean bl = this.preferences.getBoolean("description.defaultbuildorder");
        if (bl) {
            return null;
        }
        return WorkspacePreferences.convertStringToStringArray(this.preferences.getString("description.buildorder"), PROJECT_SEPARATOR);
    }

    public String[] getBuildOrder(boolean bl) {
        return this.getBuildOrder();
    }

    public void setAutoBuilding(boolean bl) {
        this.preferences.setValue("description.autobuilding", bl);
    }

    public void setBuildOrder(String[] stringArray) {
        this.preferences.setValue("description.defaultbuildorder", stringArray == null);
        this.preferences.setValue("description.buildorder", WorkspacePreferences.convertStringArraytoString(stringArray));
    }

    public void setDeltaExpiration(long l) {
        this.preferences.setValue("delta.expiration", l);
    }

    public void setFileStateLongevity(long l) {
        this.preferences.setValue("description.filestatelongevity", l);
    }

    public void setMaxBuildIterations(int n) {
        this.preferences.setValue("description.maxbuilditerations", n);
    }

    public void setMaxFileStates(int n) {
        this.preferences.setValue("description.maxfilestates", n);
    }

    public void setMaxFileStateSize(long l) {
        this.preferences.setValue("description.maxfilestatesize", l);
    }

    public void setOperationsPerSnapshot(int n) {
        this.preferences.setValue("snapshots.operations", n);
    }

    public void setSnapshotInterval(long l) {
        this.preferences.setValue("description.snapshotinterval", l);
    }

    protected void synchronizeWithPreferences(String string) {
        if (string.equals("description.autobuilding")) {
            super.setAutoBuilding(this.preferences.getBoolean("description.autobuilding"));
        } else if (string.equals("description.snapshotinterval")) {
            super.setSnapshotInterval(this.preferences.getLong("description.snapshotinterval"));
        } else if (string.equals("description.maxbuilditerations")) {
            super.setMaxBuildIterations(this.preferences.getInt("description.maxbuilditerations"));
        } else if (string.equals("description.maxfilestates")) {
            super.setMaxFileStates(this.preferences.getInt("description.maxfilestates"));
        } else if (string.equals("description.maxfilestatesize")) {
            super.setMaxFileStateSize(this.preferences.getLong("description.maxfilestatesize"));
        } else if (string.equals("description.filestatelongevity")) {
            super.setFileStateLongevity(this.preferences.getLong("description.filestatelongevity"));
        } else if (string.equals("snapshots.operations")) {
            super.setOperationsPerSnapshot(this.preferences.getInt("snapshots.operations"));
        } else if (string.equals("delta.expiration")) {
            super.setDeltaExpiration(this.preferences.getLong("delta.expiration"));
        }
    }

    private void upgradeVersion(String string) {
        if (string.length() == 0 && !this.preferences.getBoolean("description.defaultbuildorder")) {
            String string2 = this.preferences.getString("description.buildorder");
            this.setBuildOrder(WorkspacePreferences.convertStringToStringArray(string2, ":"));
        }
        this.preferences.setValue("version", "1");
    }
}

