/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class WorkspaceRoot
extends Container
implements IWorkspaceRoot {
    private final Map projectTable = Collections.synchronizedMap(new HashMap(16));
    private final IPath workspaceLocation;

    protected WorkspaceRoot(IPath iPath, Workspace workspace) {
        super(iPath, workspace);
        Assert.isTrue((boolean)iPath.equals((Object)Path.ROOT));
        this.workspaceLocation = FileUtil.canonicalPath(Platform.getLocation());
        Assert.isNotNull((Object)this.workspaceLocation);
    }

    public void delete(boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl2 ? 1 : 0;
        this.delete(n |= bl ? 4 : 8, iProgressMonitor);
    }

    public void delete(boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = bl ? 1 : 0;
        this.delete(n, iProgressMonitor);
    }

    public boolean exists(int n, boolean bl) {
        return true;
    }

    public IContainer[] findContainersForLocation(IPath iPath) {
        return this.findContainersForLocationURI(URIUtil.toURI((IPath)iPath.makeAbsolute()));
    }

    public IContainer[] findContainersForLocationURI(URI uRI) {
        return this.findContainersForLocationURI(uRI, 0);
    }

    public IContainer[] findContainersForLocationURI(URI uRI, int n) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return (IContainer[])this.getLocalManager().allResourcesFor(uRI, false, n);
    }

    public IFile[] findFilesForLocation(IPath iPath) {
        return this.findFilesForLocationURI(URIUtil.toURI((IPath)iPath.makeAbsolute()));
    }

    public IFile[] findFilesForLocationURI(URI uRI) {
        return this.findFilesForLocationURI(uRI, 0);
    }

    public IFile[] findFilesForLocationURI(URI uRI, int n) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return (IFile[])this.getLocalManager().allResourcesFor(uRI, true, n);
    }

    public IContainer getContainerForLocation(IPath iPath) {
        return this.getLocalManager().containerForLocation(iPath);
    }

    public String getDefaultCharset(boolean bl) {
        if (bl) {
            return ResourcesPlugin.getEncoding();
        }
        String string = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        return string == null || string.length() == 0 ? null : string;
    }

    public IFile getFileForLocation(IPath iPath) {
        return this.getLocalManager().fileForLocation(iPath);
    }

    public long getLocalTimeStamp() {
        return -1L;
    }

    public IPath getLocation() {
        return this.workspaceLocation;
    }

    public String getName() {
        return "";
    }

    public IContainer getParent() {
        return null;
    }

    public IProject getProject() {
        return null;
    }

    public IProject getProject(String string) {
        Project project = (Project)this.projectTable.get(string);
        if (project == null) {
            IPath iPath = new Path(null, string).makeAbsolute();
            String string2 = "Path for project must have only one segment.";
            Assert.isLegal((iPath.segmentCount() == 1 ? 1 : 0) != 0, (String)string2);
            String string3 = iPath.lastSegment();
            project = (Project)this.projectTable.get(string3);
            if (project != null) {
                return project;
            }
            project = new Project(iPath, this.workspace);
            this.projectTable.put(string3, project);
        }
        return project;
    }

    public IPath getProjectRelativePath() {
        return Path.EMPTY;
    }

    public IProject[] getProjects() {
        return this.getProjects(0);
    }

    public IProject[] getProjects(int n) {
        IResource[] iResourceArray = this.getChildren(n);
        IProject[] iProjectArray = new IProject[iResourceArray.length];
        System.arraycopy(iResourceArray, 0, iProjectArray, 0, iResourceArray.length);
        return iProjectArray;
    }

    public int getType() {
        return 8;
    }

    public void internalSetLocal(boolean bl, int n) throws CoreException {
        if (n == 0) {
            return;
        }
        if (n == 1) {
            n = 0;
        }
        IResource[] iResourceArray = this.getChildren(0);
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            ((Resource)iResourceArray[n2]).internalSetLocal(bl, n);
            ++n2;
        }
    }

    public boolean isDerived(int n) {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isHidden(int n) {
        return false;
    }

    public boolean isTeamPrivateMember(int n) {
        return false;
    }

    public boolean isLinked(int n) {
        return false;
    }

    public boolean isLocal(int n) {
        return this.isLocal(-1, n);
    }

    public boolean isLocal(int n, int n2) {
        if (n2 == 0) {
            return true;
        }
        if (n2 == 1) {
            n2 = 0;
        }
        IResource[] iResourceArray = this.getChildren(0);
        int n3 = 0;
        while (n3 < iResourceArray.length) {
            if (!iResourceArray[n3].isLocal(n2)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean isPhantom() {
        return false;
    }

    public void setDefaultCharset(String string) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (string != null) {
            preferences.setValue("encoding", string);
        } else {
            preferences.setToDefault("encoding");
        }
    }

    public void setHidden(boolean bl) {
    }

    public long setLocalTimeStamp(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal time stamp: " + l);
        }
        return l;
    }

    public void setReadOnly(boolean bl) {
    }

    public void touch(IProgressMonitor iProgressMonitor) {
    }
}

