/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.SavedState;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceTreeReader;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WorkspaceTreeReader_1
extends WorkspaceTreeReader {
    protected Workspace workspace;

    public WorkspaceTreeReader_1(Workspace workspace) {
        this.workspace = workspace;
    }

    protected int getVersion() {
        return 67305985;
    }

    protected void linkBuildersToTrees(List list, ElementTree[] elementTreeArray, int n, IProgressMonitor iProgressMonitor) {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            ArrayList<BuilderPersistentInfo> arrayList = null;
            String string = null;
            int n2 = 0;
            while (n2 < list.size()) {
                BuilderPersistentInfo builderPersistentInfo = (BuilderPersistentInfo)list.get(n2);
                if (!builderPersistentInfo.getProjectName().equals(string)) {
                    if (arrayList != null) {
                        IProject iProject = this.workspace.getRoot().getProject(string);
                        this.workspace.getBuildManager().setBuildersPersistentInfo(iProject, arrayList);
                    }
                    string = builderPersistentInfo.getProjectName();
                    arrayList = new ArrayList<BuilderPersistentInfo>(5);
                }
                builderPersistentInfo.setLastBuildTree(elementTreeArray[n++]);
                arrayList.add(builderPersistentInfo);
                ++n2;
            }
            if (arrayList != null) {
                IProject iProject = this.workspace.getRoot().getProject(string);
                this.workspace.getBuildManager().setBuildersPersistentInfo(iProject, arrayList);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void linkPluginsSavedStateToTrees(List list, ElementTree[] elementTreeArray, IProgressMonitor iProgressMonitor) {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            int n = 0;
            while (n < list.size()) {
                SavedState savedState = (SavedState)list.get(n);
                SaveManager saveManager = this.workspace.getSaveManager();
                if (!saveManager.isOldPluginTree(savedState.pluginId)) {
                    savedState.oldTree = elementTreeArray[n];
                } else {
                    saveManager.clearDeltaExpiration(savedState.pluginId);
                }
                ++n;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected BuilderPersistentInfo readBuilderInfo(IProject iProject, DataInputStream dataInputStream, int n) throws IOException {
        String string = dataInputStream.readUTF();
        if (iProject != null) {
            string = iProject.getName();
        }
        String string2 = dataInputStream.readUTF();
        return new BuilderPersistentInfo(string, string2, n);
    }

    protected void readBuildersPersistentInfo(IProject iProject, DataInputStream dataInputStream, List list, IProgressMonitor iProgressMonitor) throws IOException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                list.add(this.readBuilderInfo(iProject, dataInputStream, n2));
                ++n2;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void readPluginsSavedStates(DataInputStream dataInputStream, HashMap hashMap, List list, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                String string = dataInputStream.readUTF();
                SavedState savedState = new SavedState(this.workspace, string, null, null);
                hashMap.put(string, savedState);
                list.add(savedState);
                ++n2;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Exception decompiling
     */
    public ElementTree readSnapshotTree(DataInputStream var1_1, ElementTree var2_2, IProgressMonitor var3_3) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void readTree(DataInputStream dataInputStream, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            try {
                String string = Messages.resources_reading;
                iProgressMonitor.beginTask(string, 100);
                this.readWorkspaceFields(dataInputStream, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 20 / 100));
                HashMap hashMap = new HashMap(20);
                ArrayList arrayList = new ArrayList(20);
                this.readPluginsSavedStates(dataInputStream, hashMap, arrayList, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 10 / 100));
                this.workspace.getSaveManager().setPluginsSavedState(hashMap);
                ArrayList arrayList2 = new ArrayList(20);
                this.readBuildersPersistentInfo(null, dataInputStream, arrayList2, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 10 / 100));
                ElementTree[] elementTreeArray = this.readTrees((IPath)Path.ROOT, dataInputStream, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 40 / 100));
                this.linkPluginsSavedStateToTrees(arrayList, elementTreeArray, Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 10 / 100));
                this.linkBuildersToTrees(arrayList2, elementTreeArray, arrayList.size(), Policy.subMonitorFor(iProgressMonitor, Policy.opWork * 10 / 100));
            }
            catch (IOException iOException) {
                String string = Messages.resources_readWorkspaceTree;
                throw new ResourceException(567, null, string, iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void readTree(IProject iProject, DataInputStream dataInputStream, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            try {
                Object object;
                String string = Messages.resources_reading;
                iProgressMonitor.beginTask(string, 10);
                int n = dataInputStream.readInt();
                String[] stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    object = dataInputStream.readUTF();
                    stringArray[n2] = object;
                    ++n2;
                }
                iProgressMonitor.worked(1);
                ElementTree[] elementTreeArray = this.readTrees(iProject.getFullPath(), dataInputStream, Policy.subMonitorFor(iProgressMonitor, 8));
                if (n > 0) {
                    object = new ArrayList(elementTreeArray.length * 2 + 1);
                    int n3 = 0;
                    while (n3 < n) {
                        BuilderPersistentInfo builderPersistentInfo = new BuilderPersistentInfo(iProject.getName(), stringArray[n3], -1);
                        builderPersistentInfo.setLastBuildTree(elementTreeArray[n3]);
                        ((ArrayList)object).add(builderPersistentInfo);
                        ++n3;
                    }
                    this.workspace.getBuildManager().setBuildersPersistentInfo(iProject, (ArrayList)object);
                }
                iProgressMonitor.worked(1);
            }
            catch (IOException iOException) {
                String string = Messages.resources_readProjectTree;
                throw new ResourceException(567, null, string, iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected ElementTree[] readTrees(IPath iPath, DataInputStream dataInputStream, IProgressMonitor iProgressMonitor) throws IOException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string = Messages.resources_reading;
            iProgressMonitor.beginTask(string, 4);
            ElementTreeReader elementTreeReader = new ElementTreeReader(this.workspace.getSaveManager());
            ElementTree[] elementTreeArray = elementTreeReader.readDeltaChain(dataInputStream);
            iProgressMonitor.worked(3);
            if (iPath.isRoot()) {
                ElementTree elementTree = elementTreeArray[elementTreeArray.length - 1];
                elementTree.setTreeData(this.workspace.tree.getTreeData());
                this.workspace.tree = elementTree;
            } else {
                this.workspace.linkTrees(iPath, elementTreeArray);
            }
            iProgressMonitor.worked(1);
            ElementTree[] elementTreeArray2 = elementTreeArray;
            return elementTreeArray2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void readWorkspaceFields(DataInputStream dataInputStream, IProgressMonitor iProgressMonitor) throws IOException, CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            this.workspace.nextNodeId = dataInputStream.readLong();
            dataInputStream.readLong();
            this.workspace.nextMarkerId = dataInputStream.readLong();
            ((Synchronizer)this.workspace.getSynchronizer()).readPartners(dataInputStream);
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

