/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceTreeReader_1;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceTreeReader_2
extends WorkspaceTreeReader_1 {
    public WorkspaceTreeReader_2(Workspace workspace) {
        super(workspace);
    }

    protected int getVersion() {
        return 67305986;
    }

    protected void readBuildersPersistentInfo(IProject iProject, DataInputStream dataInputStream, List list, IProgressMonitor iProgressMonitor) throws IOException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                BuilderPersistentInfo builderPersistentInfo = this.readBuilderInfo(iProject, dataInputStream, n2);
                int n3 = dataInputStream.readInt();
                IProject[] iProjectArray = new IProject[n3];
                int n4 = 0;
                while (n4 < n3) {
                    iProjectArray[n4] = this.workspace.getRoot().getProject(dataInputStream.readUTF());
                    ++n4;
                }
                builderPersistentInfo.setInterestingProjects(iProjectArray);
                list.add(builderPersistentInfo);
                ++n2;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void readTree(IProject iProject, DataInputStream dataInputStream, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            try {
                String string = Messages.resources_reading;
                iProgressMonitor.beginTask(string, 10);
                ArrayList arrayList = new ArrayList(5);
                this.readBuildersPersistentInfo(iProject, dataInputStream, arrayList, Policy.subMonitorFor(iProgressMonitor, 1));
                ElementTree[] elementTreeArray = this.readTrees(iProject.getFullPath(), dataInputStream, Policy.subMonitorFor(iProgressMonitor, 8));
                this.linkBuildersToTrees(arrayList, elementTreeArray, 0, Policy.subMonitorFor(iProgressMonitor, 1));
            }
            catch (IOException iOException) {
                String string = Messages.resources_readProjectTree;
                throw new ResourceException(567, null, string, iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

