/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class ChangeDescription {
    private List addedRoots = new ArrayList();
    private List changedFiles = new ArrayList();
    private List closedProjects = new ArrayList();
    private List copiedRoots = new ArrayList();
    private List movedRoots = new ArrayList();
    private List removedRoots = new ArrayList();

    private IResource createSourceResource(IResourceDelta iResourceDelta) {
        IPath iPath = iResourceDelta.getMovedFromPath();
        IResource iResource = iResourceDelta.getResource();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        switch (iResource.getType()) {
            case 4: {
                return iWorkspaceRoot.getProject(iPath.segment(0));
            }
            case 2: {
                return iWorkspaceRoot.getFolder(iPath);
            }
            case 1: {
                return iWorkspaceRoot.getFile(iPath);
            }
        }
        return null;
    }

    private void ensureResourceCovered(IResource iResource, List list) {
        IPath iPath = iResource.getFullPath();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IResource iResource2 = (IResource)iterator.next();
            if (!iResource2.getFullPath().isPrefixOf(iPath)) continue;
            return;
        }
        list.add(iResource);
    }

    public IResource[] getRootResources() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.addedRoots);
        hashSet.addAll(this.changedFiles);
        hashSet.addAll(this.closedProjects);
        hashSet.addAll(this.copiedRoots);
        hashSet.addAll(this.movedRoots);
        hashSet.addAll(this.removedRoots);
        return hashSet.toArray(new IResource[hashSet.size()]);
    }

    private void handleAdded(IResourceDelta iResourceDelta) {
        if ((iResourceDelta.getFlags() & 0x1000) != 0) {
            this.handleMove(iResourceDelta);
        } else if ((iResourceDelta.getFlags() & 0x800) != 0) {
            this.handleCopy(iResourceDelta);
        } else {
            this.ensureResourceCovered(iResourceDelta.getResource(), this.addedRoots);
        }
    }

    private void handleChange(IResourceDelta iResourceDelta) {
        if ((iResourceDelta.getFlags() & 0x40000) != 0) {
            this.handleAdded(iResourceDelta);
        } else if (iResourceDelta.getResource().getType() == 1) {
            this.ensureResourceCovered(iResourceDelta.getResource(), this.changedFiles);
        }
    }

    private void handleCopy(IResourceDelta iResourceDelta) {
        if ((iResourceDelta.getFlags() & 0x800) != 0) {
            IResource iResource = this.createSourceResource(iResourceDelta);
            this.ensureResourceCovered(iResource, this.copiedRoots);
        }
    }

    private void handleMove(IResourceDelta iResourceDelta) {
        if ((iResourceDelta.getFlags() & 0x2000) != 0) {
            this.movedRoots.add(iResourceDelta.getResource());
        } else if ((iResourceDelta.getFlags() & 0x1000) != 0) {
            IResource iResource = this.createSourceResource(iResourceDelta);
            this.ensureResourceCovered(iResource, this.movedRoots);
        }
    }

    private void handleRemoved(IResourceDelta iResourceDelta) {
        if ((iResourceDelta.getFlags() & 0x4000) != 0) {
            this.closedProjects.add(iResourceDelta.getResource());
        } else if ((iResourceDelta.getFlags() & 0x2000) != 0) {
            this.handleMove(iResourceDelta);
        } else {
            this.ensureResourceCovered(iResourceDelta.getResource(), this.removedRoots);
        }
    }

    public boolean recordChange(IResourceDelta iResourceDelta) {
        switch (iResourceDelta.getKind()) {
            case 1: {
                this.handleAdded(iResourceDelta);
                return true;
            }
            case 2: {
                this.handleRemoved(iResourceDelta);
                return false;
            }
            case 4: {
                this.handleChange(iResourceDelta);
                return true;
            }
        }
        return true;
    }
}

