/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ModelProviderDescriptor
implements IModelProviderDescriptor {
    private String id;
    private String[] extendedModels;
    private String label;
    private ModelProvider provider;
    private Expression enablementRule;

    private static EvaluationContext createEvaluationContext(Object object) {
        EvaluationContext evaluationContext = new EvaluationContext(null, object);
        return evaluationContext;
    }

    public ModelProviderDescriptor(IExtension iExtension) throws CoreException {
        this.readExtension(iExtension);
    }

    private boolean convert(EvaluationResult evaluationResult) {
        return evaluationResult != EvaluationResult.FALSE;
    }

    protected void fail(String string) throws CoreException {
        throw new ResourceException((IStatus)new Status(4, "org.eclipse.core.resources", 1, string, null));
    }

    public String[] getExtendedModels() {
        return this.extendedModels;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public IResource[] getMatchingResources(IResource[] iResourceArray) throws CoreException {
        HashSet<IResource> hashSet = new HashSet<IResource>();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            EvaluationContext evaluationContext = ModelProviderDescriptor.createEvaluationContext(iResource);
            if (this.matches((IEvaluationContext)evaluationContext)) {
                hashSet.add(iResource);
            }
            ++n;
        }
        return hashSet.toArray(new IResource[hashSet.size()]);
    }

    public synchronized ModelProvider getModelProvider() throws CoreException {
        if (this.provider == null) {
            IExtension iExtension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "modelProviders", this.id);
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                if (iConfigurationElement.getName().equalsIgnoreCase("modelProvider")) {
                    try {
                        this.provider = (ModelProvider)((Object)iConfigurationElement.createExecutableExtension("class"));
                        this.provider.init(this);
                    }
                    catch (ClassCastException classCastException) {
                        String string = NLS.bind((String)Messages.mapping_wrongType, (Object)this.id);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources", 2, string, (Throwable)classCastException));
                    }
                }
                ++n;
            }
        }
        return this.provider;
    }

    public boolean matches(IEvaluationContext iEvaluationContext) throws CoreException {
        if (this.enablementRule == null) {
            return false;
        }
        return this.convert(this.enablementRule.evaluate(iEvaluationContext));
    }

    protected void readExtension(IExtension iExtension) throws CoreException {
        this.id = iExtension.getUniqueIdentifier();
        if (this.id == null) {
            this.fail(Messages.mapping_noIdentifier);
        }
        this.label = iExtension.getLabel();
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string = iConfigurationElement.getName();
            if (string.equalsIgnoreCase("extends-model")) {
                String string2 = iConfigurationElement.getAttribute("id");
                if (string2 == null) {
                    this.fail(NLS.bind((String)Messages.mapping_invalidDef, (Object)this.id));
                }
                arrayList.add(string2);
            } else if (string.equalsIgnoreCase("enablement")) {
                this.enablementRule = ExpressionConverter.getDefault().perform(iConfigurationElement);
            }
            ++n2;
        }
        this.extendedModels = arrayList.toArray(new String[arrayList.size()]);
    }

    public ResourceTraversal[] getMatchingTraversals(ResourceTraversal[] resourceTraversalArray) throws CoreException {
        ArrayList<ResourceTraversal> arrayList = new ArrayList<ResourceTraversal>();
        int n = 0;
        while (n < resourceTraversalArray.length) {
            ResourceTraversal resourceTraversal = resourceTraversalArray[n];
            if (this.getMatchingResources(resourceTraversal.getResources()).length > 0) {
                arrayList.add(resourceTraversal);
            }
            ++n;
        }
        return arrayList.toArray(new ResourceTraversal[arrayList.size()]);
    }
}

