/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.mapping.ModelProviderDescriptor;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ModelProviderManager {
    private static Map descriptors;
    private static ModelProviderManager instance;

    public static synchronized ModelProviderManager getDefault() {
        if (instance == null) {
            instance = new ModelProviderManager();
        }
        return instance;
    }

    private void detectCycles() {
    }

    public IModelProviderDescriptor getDescriptor(String string) {
        this.lazyInitialize();
        return (IModelProviderDescriptor)descriptors.get(string);
    }

    public IModelProviderDescriptor[] getDescriptors() {
        this.lazyInitialize();
        return descriptors.values().toArray(new IModelProviderDescriptor[descriptors.size()]);
    }

    public ModelProvider getModelProvider(String string) throws CoreException {
        IModelProviderDescriptor iModelProviderDescriptor = this.getDescriptor(string);
        if (iModelProviderDescriptor == null) {
            return null;
        }
        return iModelProviderDescriptor.getModelProvider();
    }

    protected void lazyInitialize() {
        if (descriptors != null) {
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "modelProviders");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        descriptors = new HashMap(iExtensionArray.length * 2 + 1);
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            ModelProviderDescriptor modelProviderDescriptor = null;
            try {
                modelProviderDescriptor = new ModelProviderDescriptor(iExtensionArray[n]);
            }
            catch (CoreException coreException) {
                Policy.log(coreException);
            }
            if (modelProviderDescriptor != null) {
                descriptors.put(modelProviderDescriptor.getId(), modelProviderDescriptor);
            }
            ++n;
        }
        this.detectCycles();
    }
}

