/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public final class ProposedResourceDelta
extends PlatformObject
implements IResourceDelta {
    protected static int KIND_MASK = 255;
    private HashMap children = new HashMap(8);
    private IPath movedFromPath;
    private IPath movedToPath;
    private IResource resource;
    private int status;

    public ProposedResourceDelta(IResource iResource) {
        this.resource = iResource;
    }

    public void accept(IResourceDeltaVisitor iResourceDeltaVisitor) throws CoreException {
        this.accept(iResourceDeltaVisitor, 0);
    }

    public void accept(IResourceDeltaVisitor iResourceDeltaVisitor, boolean bl) throws CoreException {
        this.accept(iResourceDeltaVisitor, bl ? 1 : 0);
    }

    public void accept(IResourceDeltaVisitor iResourceDeltaVisitor, int n) throws CoreException {
        if (!iResourceDeltaVisitor.visit(this)) {
            return;
        }
        Iterator iterator = this.children.values().iterator();
        while (iterator.hasNext()) {
            ProposedResourceDelta proposedResourceDelta = (ProposedResourceDelta)iterator.next();
            proposedResourceDelta.accept(iResourceDeltaVisitor, n);
        }
    }

    protected void add(ProposedResourceDelta proposedResourceDelta) {
        if (this.children.size() == 0 && this.status == 0) {
            this.setKind(4);
        }
        this.children.put(proposedResourceDelta.getResource().getName(), proposedResourceDelta);
    }

    protected void addFlags(int n) {
        this.status |= n & ~KIND_MASK;
    }

    public IResourceDelta findMember(IPath iPath) {
        int n = iPath.segmentCount();
        if (n == 0) {
            return this;
        }
        ProposedResourceDelta proposedResourceDelta = this;
        int n2 = 0;
        while (n2 < n) {
            proposedResourceDelta = (ProposedResourceDelta)proposedResourceDelta.children.get(iPath.segment(n2));
            if (proposedResourceDelta == null) {
                return null;
            }
            ++n2;
        }
        return proposedResourceDelta;
    }

    public IResourceDelta[] getAffectedChildren() {
        return this.getAffectedChildren(7, 0);
    }

    public IResourceDelta[] getAffectedChildren(int n) {
        return this.getAffectedChildren(n, 0);
    }

    public IResourceDelta[] getAffectedChildren(int n, int n2) {
        ArrayList<ProposedResourceDelta> arrayList = new ArrayList<ProposedResourceDelta>();
        Iterator iterator = this.children.values().iterator();
        while (iterator.hasNext()) {
            ProposedResourceDelta proposedResourceDelta = (ProposedResourceDelta)iterator.next();
            if ((proposedResourceDelta.getKind() & n) == 0) continue;
            arrayList.add(proposedResourceDelta);
        }
        return arrayList.toArray(new IResourceDelta[arrayList.size()]);
    }

    ProposedResourceDelta getChild(String string) {
        return (ProposedResourceDelta)this.children.get(string);
    }

    public int getFlags() {
        return this.status & ~KIND_MASK;
    }

    public IPath getFullPath() {
        return this.getResource().getFullPath();
    }

    public int getKind() {
        return this.status & KIND_MASK;
    }

    public IMarkerDelta[] getMarkerDeltas() {
        return new IMarkerDelta[0];
    }

    public IPath getMovedFromPath() {
        return this.movedFromPath;
    }

    public IPath getMovedToPath() {
        return this.movedToPath;
    }

    public IPath getProjectRelativePath() {
        return this.getResource().getProjectRelativePath();
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setFlags(int n) {
        this.status = this.getKind() | n & ~KIND_MASK;
    }

    protected void setKind(int n) {
        this.status = this.getFlags() | n & KIND_MASK;
    }

    protected void setMovedFromPath(IPath iPath) {
        this.movedFromPath = iPath;
    }

    protected void setMovedToPath(IPath iPath) {
        this.movedToPath = iPath;
    }

    public String toString() {
        return "ProposedDelta(" + this.resource + ')';
    }
}

