/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import org.eclipse.core.internal.resources.mapping.ProposedResourceDelta;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ResourceChangeDescriptionFactory
implements IResourceChangeDescriptionFactory {
    private ProposedResourceDelta root = new ProposedResourceDelta(ResourcesPlugin.getWorkspace().getRoot());

    private ProposedResourceDelta buildDeleteDelta(ProposedResourceDelta proposedResourceDelta, IResource iResource) {
        ProposedResourceDelta proposedResourceDelta2 = proposedResourceDelta.getChild(iResource.getName());
        if (proposedResourceDelta2 == null) {
            proposedResourceDelta2 = new ProposedResourceDelta(iResource);
            proposedResourceDelta.add(proposedResourceDelta2);
        }
        proposedResourceDelta2.setKind(2);
        if (iResource.getType() == 1) {
            return proposedResourceDelta2;
        }
        try {
            IResource[] iResourceArray = ((IContainer)iResource).members();
            int n = iResourceArray.length;
            if (n > 0) {
                ProposedResourceDelta[] proposedResourceDeltaArray = new ProposedResourceDelta[n];
                int n2 = 0;
                while (n2 < n) {
                    proposedResourceDeltaArray[n2] = this.buildDeleteDelta(proposedResourceDelta2, iResourceArray[n2]);
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
        return proposedResourceDelta2;
    }

    public void change(IFile iFile) {
        ProposedResourceDelta proposedResourceDelta = this.getDelta(iFile);
        if (proposedResourceDelta.getKind() == 0) {
            proposedResourceDelta.setKind(4);
        }
        if (proposedResourceDelta.getKind() == 4 || (proposedResourceDelta.getFlags() & 0x1000) != 0 || (proposedResourceDelta.getFlags() & 0x800) != 0) {
            proposedResourceDelta.addFlags(256);
        }
    }

    public void close(IProject iProject) {
        this.delete(iProject);
        ProposedResourceDelta proposedResourceDelta = this.getDelta(iProject);
        proposedResourceDelta.addFlags(16384);
    }

    public void copy(IResource iResource, IPath iPath) {
        this.moveOrCopyDeep(iResource, iPath, false);
    }

    public void create(IResource iResource) {
        this.getDelta(iResource).setKind(1);
    }

    public void delete(IResource iResource) {
        if (iResource.getType() == 8) {
            IProject[] iProjectArray = ((IWorkspaceRoot)iResource).getProjects(8);
            int n = 0;
            while (n < iProjectArray.length) {
                this.buildDeleteDelta(this.root, iProjectArray[n]);
                ++n;
            }
        } else {
            this.buildDeleteDelta(this.getDelta(iResource.getParent()), iResource);
        }
    }

    private void fail(CoreException coreException) {
        Policy.log(coreException.getStatus().getSeverity(), "An internal error occurred while accumulating a change description.", coreException);
    }

    public IResourceDelta getDelta() {
        return this.root;
    }

    ProposedResourceDelta getDelta(IResource iResource) {
        ProposedResourceDelta proposedResourceDelta = (ProposedResourceDelta)this.root.findMember(iResource.getFullPath());
        if (proposedResourceDelta != null) {
            return proposedResourceDelta;
        }
        ProposedResourceDelta proposedResourceDelta2 = this.getDelta(iResource.getParent());
        proposedResourceDelta = new ProposedResourceDelta(iResource);
        proposedResourceDelta2.add(proposedResourceDelta);
        return proposedResourceDelta;
    }

    protected IResource getDestinationResource(IResource iResource, IPath iPath, IPath iPath2) {
        IResource iResource2;
        IPath iPath3 = iResource.getFullPath().removeFirstSegments(iPath.segmentCount());
        IPath iPath4 = iPath2.append(iPath3);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        switch (iResource.getType()) {
            case 1: {
                iResource2 = iWorkspaceRoot.getFile(iPath4);
                break;
            }
            case 2: {
                iResource2 = iWorkspaceRoot.getFolder(iPath4);
                break;
            }
            case 4: {
                iResource2 = iWorkspaceRoot.getProject(iPath4.segment(0));
                break;
            }
            default: {
                iResource2 = null;
            }
        }
        return iResource2;
    }

    public void move(IResource iResource, IPath iPath) {
        this.moveOrCopyDeep(iResource, iPath, true);
    }

    boolean moveOrCopy(IResource iResource, IPath iPath, IPath iPath2, boolean bl) {
        ProposedResourceDelta proposedResourceDelta = this.getDelta(iResource);
        if (proposedResourceDelta.getKind() == 2) {
            return false;
        }
        IResource iResource2 = this.getDestinationResource(iResource, iPath, iPath2);
        ProposedResourceDelta proposedResourceDelta2 = this.getDelta(iResource2);
        if ((proposedResourceDelta2.getKind() & 5) > 0) {
            return false;
        }
        IPath iPath3 = iResource.getFullPath();
        boolean bl2 = false;
        int n = proposedResourceDelta.getFlags();
        if (bl) {
            if (proposedResourceDelta.getKind() == 1) {
                if ((n & 0x1000) != 0) {
                    iPath3 = proposedResourceDelta.getMovedFromPath();
                    proposedResourceDelta.setMovedFromPath(null);
                }
                proposedResourceDelta.setKind(0);
                bl2 = true;
            } else {
                proposedResourceDelta.setKind(2);
                proposedResourceDelta.setFlags(8192);
                proposedResourceDelta.setMovedToPath(iPath2.append(iPath3.removeFirstSegments(iPath.segmentCount())));
            }
        }
        if (proposedResourceDelta2.getKind() == 2) {
            proposedResourceDelta2.setKind(4);
            proposedResourceDelta2.addFlags(262144);
        } else {
            proposedResourceDelta2.setKind(1);
        }
        if (!bl2 || !iPath3.equals((Object)iResource.getFullPath())) {
            proposedResourceDelta2.addFlags(bl ? 4096 : 2048);
            proposedResourceDelta2.setMovedFromPath(iPath3);
            if (bl) {
                proposedResourceDelta2.addFlags(n);
            }
        }
        return true;
    }

    private void moveOrCopyDeep(IResource iResource, IPath iPath, final boolean bl) {
        final IPath iPath2 = iResource.getFullPath();
        final IPath iPath3 = iPath;
        try {
            if (iResource.isAccessible()) {
                iResource.accept(new IResourceVisitor(){

                    public boolean visit(IResource iResource) {
                        return ResourceChangeDescriptionFactory.this.moveOrCopy(iResource, iPath2, iPath3, bl);
                    }
                });
            } else {
                this.moveOrCopy(iResource, iPath2, iPath, bl);
            }
        }
        catch (CoreException coreException) {
            this.fail(coreException);
        }
    }
}

