/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import org.eclipse.core.internal.resources.mapping.ShallowContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IProgressMonitor;

public class ShallowResourceMapping
extends ResourceMapping {
    private final ShallowContainer container;

    public ShallowResourceMapping(ShallowContainer shallowContainer) {
        this.container = shallowContainer;
    }

    public Object getModelObject() {
        return this.container;
    }

    public String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    public IProject[] getProjects() {
        return new IProject[]{this.container.getResource().getProject()};
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) {
        return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.container.getResource()}, 1, 0)};
    }

    public boolean contains(ResourceMapping resourceMapping) {
        if (resourceMapping.getModelProviderId().equals(this.getModelProviderId())) {
            Object object = resourceMapping.getModelObject();
            IContainer iContainer = this.container.getResource();
            if (object instanceof ShallowContainer) {
                ShallowContainer shallowContainer = (ShallowContainer)((Object)object);
                return shallowContainer.getResource().equals(iContainer);
            }
            if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                return iResource.getType() == 1 && iContainer.getFullPath().equals((Object)iResource.getFullPath().removeLastSegments(1));
            }
        }
        return false;
    }
}

