/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import org.eclipse.core.internal.resources.mapping.ShallowContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IProgressMonitor;

public class SimpleResourceMapping
extends ResourceMapping {
    private final IResource resource;

    public SimpleResourceMapping(IResource iResource) {
        this.resource = iResource;
    }

    public boolean contains(ResourceMapping resourceMapping) {
        if (resourceMapping.getModelProviderId().equals(this.getModelProviderId())) {
            Object object = resourceMapping.getModelObject();
            if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                return this.resource.getFullPath().isPrefixOf(iResource.getFullPath());
            }
            if (object instanceof ShallowContainer) {
                ShallowContainer shallowContainer = (ShallowContainer)((Object)object);
                IContainer iContainer = shallowContainer.getResource();
                return this.resource.getFullPath().isPrefixOf(iContainer.getFullPath());
            }
        }
        return false;
    }

    public Object getModelObject() {
        return this.resource;
    }

    public String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    public IProject[] getProjects() {
        if (this.resource.getType() == 8) {
            return ((IWorkspaceRoot)this.resource).getProjects();
        }
        return new IProject[]{this.resource.getProject()};
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) {
        if (this.resource.getType() == 8) {
            return new ResourceTraversal[]{new ResourceTraversal(((IWorkspaceRoot)this.resource).getProjects(), 2, 0)};
        }
        return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.resource}, 2, 0)};
    }
}

