/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.projectVariables;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectVariableProvider;
import org.eclipse.core.runtime.IPath;

public class ParentVariableProvider
implements IProjectVariableProvider {
    public static final String NAME = "PARENT";

    public Object[] getExtensions(String string, IProject iProject) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator<String> iterator = Arrays.asList(iProject.getPathVariableManager().getPathVariableNames()).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string2.equals(NAME)) continue;
            linkedList.add("1-" + string2);
        }
        return linkedList.toArray();
    }

    public String getValue(String string, IProject iProject) {
        int n = string.indexOf(45);
        if (n == -1 || n == string.length() - 1) {
            return Messages.parentVariableProvider_noVariableSpecified;
        }
        String string2 = string.substring(n + 1);
        if ((n = string2.indexOf(45)) == -1 || n == string.length() - 1) {
            return Messages.parentVariableProvider_noVariableSpecified;
        }
        String string3 = string2.substring(0, n);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string3);
            if (n2 < 0) {
                return Messages.parentVariableProvider_noVariableSpecified;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return Messages.parentVariableProvider_noVariableSpecified;
        }
        String string4 = string2.substring(n + 1);
        IPath iPath = iProject.getPathVariableManager().getValue(string4);
        if (iPath == null) {
            return null;
        }
        iPath = iProject.getPathVariableManager().resolvePath(iPath);
        iPath = iPath.removeLastSegments(n2);
        return iPath.toPortableString();
    }
}

