/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.refresh.win32;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.refresh.win32.Win32Natives;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

class Win32Monitor
extends Job
implements IRefreshMonitor {
    private static final long RESCHEDULE_DELAY = 1000L;
    private static final String DEBUG_PREFIX = "Win32RefreshMonitor: ";
    private static final int WAIT_FOR_MULTIPLE_OBJECTS_TIMEOUT = 300;
    protected MultiStatus errors;
    protected long[][] fHandleValueArrays;
    protected Map fHandleValueToHandle;
    protected IRefreshResult refreshResult;

    public Win32Monitor(IRefreshResult iRefreshResult) {
        super(Messages.WM_jobName);
        this.refreshResult = iRefreshResult;
        this.setPriority(50);
        this.setSystem(true);
        this.fHandleValueToHandle = new HashMap(1);
        this.setHandleValueArrays(this.createHandleArrays());
    }

    protected synchronized void addException(String string) {
        if (this.errors == null) {
            String string2 = Messages.WM_errors;
            this.errors = new MultiStatus("org.eclipse.core.resources", 1, string2, null);
        }
        this.errors.add((IStatus)new Status(4, "org.eclipse.core.resources", 1, string, null));
    }

    private long[][] balancedSplit(long[] lArray, int n) {
        int n2 = lArray.length;
        int n3 = (n2 - 1) / n + 1;
        int n4 = n2 / n3;
        int n5 = n2 % n3;
        long[][] lArrayArray = new long[n3][];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n4 + (n5-- > 0 ? 1 : 0);
            long[] lArray2 = new long[n8];
            int n9 = 0;
            while (n9 < n8) {
                lArray2[n9] = lArray[n6++];
                ++n9;
            }
            lArrayArray[n7] = lArray2;
            ++n7;
        }
        return lArrayArray;
    }

    private Handle createHandle(IResource iResource) {
        if (iResource.isLinked()) {
            return new LinkedResourceHandle(iResource);
        }
        return new ResourceHandle(iResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[][] createHandleArrays() {
        long[] lArray;
        Map map = this.fHandleValueToHandle;
        synchronized (map) {
            Set set = this.fHandleValueToHandle.keySet();
            int n = set.size();
            if (n == 0) {
                return new long[0][0];
            }
            lArray = new long[n];
            int n2 = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                lArray[n2++] = (Long)iterator.next();
            }
        }
        return this.balancedSplit(lArray, Win32Natives.MAXIMUM_WAIT_OBJECTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handle getHandle(IResource iResource) {
        if (iResource == null) {
            return null;
        }
        Map map = this.fHandleValueToHandle;
        synchronized (map) {
            Iterator iterator = this.fHandleValueToHandle.values().iterator();
            while (iterator.hasNext()) {
                ResourceHandle resourceHandle;
                Handle handle = (Handle)iterator.next();
                if (!(handle instanceof ResourceHandle) || !(resourceHandle = (ResourceHandle)handle).getResource().equals(iResource)) continue;
                return handle;
            }
        }
        return null;
    }

    private long[][] getHandleValueArrays() {
        return this.fHandleValueArrays;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean monitor(IResource iResource) {
        IPath iPath = iResource.getLocation();
        if (iPath == null) {
            return false;
        }
        Handle handle = this.createHandle(iResource);
        Win32Monitor win32Monitor = this;
        synchronized (win32Monitor) {
            handle.open();
        }
        if (!handle.isOpen()) {
            this.errors = null;
            return false;
        }
        this.schedule(1000L);
        if (RefreshManager.DEBUG) {
            System.out.println("Win32RefreshMonitor:  added monitor for: " + iResource);
        }
        return true;
    }

    protected void removeHandle(Handle handle) {
        ArrayList<Handle> arrayList = new ArrayList<Handle>(1);
        arrayList.add(handle);
        this.removeHandles(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHandles(Collection collection) {
        Win32Monitor win32Monitor = this;
        synchronized (win32Monitor) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Handle handle = (Handle)iterator.next();
                this.fHandleValueToHandle.remove(new Long(handle.getHandleValue()));
                handle.destroy();
            }
            this.setHandleValueArrays(this.createHandleArrays());
        }
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        Bundle bundle;
        long l = -System.currentTimeMillis();
        if (RefreshManager.DEBUG) {
            System.out.println("Win32RefreshMonitor: job started.");
        }
        try {
            long[][] lArray = this.getHandleValueArrays();
            iProgressMonitor.beginTask(Messages.WM_beginTask, lArray.length);
            int n = 0;
            int n2 = lArray.length;
            while (n < n2) {
                if (iProgressMonitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                this.waitForNotification(lArray[n]);
                iProgressMonitor.worked(1);
                ++n;
            }
        }
        finally {
            iProgressMonitor.done();
            l += System.currentTimeMillis();
            if (RefreshManager.DEBUG) {
                System.out.println("Win32RefreshMonitor: job finished in: " + l + "ms");
            }
        }
        long l2 = Math.max(1000L, l * 30L);
        if (RefreshManager.DEBUG) {
            System.out.println("Win32RefreshMonitor: rescheduling in: " + l2 / 1000L + " seconds");
        }
        if ((bundle = Platform.getBundle((String)"org.eclipse.core.resources")) == null) {
            return Status.OK_STATUS;
        }
        if (bundle.getState() == 32) {
            this.schedule(l2);
        }
        MultiStatus multiStatus = this.errors;
        this.errors = null;
        if (multiStatus != null && !multiStatus.isOK()) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)multiStatus);
        }
        return Status.OK_STATUS;
    }

    protected void setHandleValueArrays(long[][] lArray) {
        this.fHandleValueArrays = lArray;
    }

    public boolean shouldRun() {
        return !this.fHandleValueToHandle.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmonitor(IResource iResource) {
        if (iResource == null) {
            Map map = this.fHandleValueToHandle;
            synchronized (map) {
                this.removeHandles(new ArrayList(this.fHandleValueToHandle.values()));
            }
        } else {
            Handle handle = this.getHandle(iResource);
            if (handle != null) {
                this.removeHandle(handle);
            }
        }
        if (this.fHandleValueToHandle.isEmpty()) {
            this.cancel();
        }
    }

    private void waitForNotification(long[] lArray) {
        int n = lArray.length;
        int n2 = Win32Natives.WaitForMultipleObjects(n, lArray, false, 300);
        if (n2 == Win32Natives.WAIT_TIMEOUT) {
            return;
        }
        if (n2 == Win32Natives.WAIT_FAILED) {
            int n3 = Win32Natives.GetLastError();
            if (n3 != Win32Natives.ERROR_INVALID_HANDLE && n3 != Win32Natives.ERROR_SUCCESS) {
                this.addException(NLS.bind((String)Messages.WM_nativeErr, (Object)Integer.toString(n3)));
                this.refreshResult.monitorFailed(this, null);
            }
            return;
        }
        Handle handle = (Handle)this.fHandleValueToHandle.get(new Long(lArray[n2 -= Win32Natives.WAIT_OBJECT_0]));
        if (handle != null) {
            handle.handleNotification();
        }
    }

    protected abstract class ChainedHandle
    extends Handle {
        private ChainedHandle next;
        private ChainedHandle previous;

        protected ChainedHandle() {
        }

        public abstract boolean exists();

        public ChainedHandle getNext() {
            return this.next;
        }

        public ChainedHandle getPrevious() {
            return this.previous;
        }

        public void setNext(ChainedHandle chainedHandle) {
            this.next = chainedHandle;
        }

        public void setPrevious(ChainedHandle chainedHandle) {
            this.previous = chainedHandle;
        }
    }

    protected class FileHandle
    extends ChainedHandle {
        private File file;

        public FileHandle(File file) {
            this.file = file;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public void handleNotification() {
            if (!this.isOpen()) {
                return;
            }
            ChainedHandle chainedHandle = this.getNext();
            if (chainedHandle != null) {
                if (chainedHandle.isOpen()) {
                    if (!chainedHandle.exists()) {
                        ChainedHandle chainedHandle2;
                        if (chainedHandle instanceof LinkedResourceHandle) {
                            chainedHandle.close();
                            chainedHandle2 = (LinkedResourceHandle)chainedHandle;
                            ((LinkedResourceHandle)chainedHandle2).postRefreshRequest();
                        } else {
                            chainedHandle.close();
                        }
                        chainedHandle2 = this.getPrevious();
                        if (chainedHandle2 != null) {
                            chainedHandle2.open();
                        }
                    }
                } else {
                    chainedHandle.open();
                    if (chainedHandle.isOpen()) {
                        ChainedHandle chainedHandle3 = this.getPrevious();
                        chainedHandle3.close();
                        if (chainedHandle instanceof LinkedResourceHandle) {
                            ((LinkedResourceHandle)chainedHandle).postRefreshRequest();
                        }
                    }
                }
            }
            this.findNextChange();
        }

        public void open() {
            if (!this.isOpen()) {
                ChainedHandle chainedHandle = this.getNext();
                if (chainedHandle != null && chainedHandle.isOpen()) {
                    this.openHandleOn(this.file);
                } else {
                    ChainedHandle chainedHandle2;
                    if (this.exists()) {
                        this.openHandleOn(this.file);
                    }
                    if ((chainedHandle2 = this.getPrevious()) != null) {
                        chainedHandle2.open();
                    }
                }
            }
        }
    }

    protected abstract class Handle {
        protected long handleValue = Win32Natives.INVALID_HANDLE_VALUE;

        public void close() {
            if (this.isOpen()) {
                int n;
                if (!Win32Natives.FindCloseChangeNotification(this.handleValue) && (n = Win32Natives.GetLastError()) != Win32Natives.ERROR_INVALID_HANDLE) {
                    Win32Monitor.this.addException(NLS.bind((String)Messages.WM_errCloseHandle, (Object)Integer.toString(n)));
                }
                if (RefreshManager.DEBUG) {
                    System.out.println("Win32RefreshMonitor: removed handle: " + this.handleValue);
                }
                this.handleValue = Win32Natives.INVALID_HANDLE_VALUE;
            }
        }

        private long createHandleValue(String string, boolean bl, int n) {
            long l = Win32Natives.FindFirstChangeNotification(string, bl, n);
            if (l == Win32Natives.INVALID_HANDLE_VALUE) {
                int n2 = Win32Natives.GetLastError();
                Win32Monitor.this.addException(NLS.bind((String)Messages.WM_errCreateHandle, (Object)string, (Object)Integer.toString(n2)));
            }
            return l;
        }

        public void destroy() {
            this.close();
        }

        protected void findNextChange() {
            if (!Win32Natives.FindNextChangeNotification(this.handleValue)) {
                int n = Win32Natives.GetLastError();
                if (n != Win32Natives.ERROR_INVALID_HANDLE && n != Win32Natives.ERROR_SUCCESS) {
                    Win32Monitor.this.addException(NLS.bind((String)Messages.WM_errFindChange, (Object)Integer.toString(n)));
                }
                Win32Monitor.this.removeHandle(this);
            }
        }

        public long getHandleValue() {
            return this.handleValue;
        }

        public abstract void handleNotification();

        public boolean isOpen() {
            return this.handleValue != Win32Natives.INVALID_HANDLE_VALUE;
        }

        public abstract void open();

        protected void openHandleOn(File file) {
            this.openHandleOn(file.getAbsolutePath(), false);
        }

        protected void openHandleOn(IResource iResource) {
            this.openHandleOn(iResource.getLocation().toOSString(), true);
        }

        private void openHandleOn(String string, boolean bl) {
            this.setHandleValue(this.createHandleValue(string, bl, Win32Natives.FILE_NOTIFY_CHANGE_FILE_NAME | Win32Natives.FILE_NOTIFY_CHANGE_DIR_NAME | Win32Natives.FILE_NOTIFY_CHANGE_LAST_WRITE | Win32Natives.FILE_NOTIFY_CHANGE_SIZE));
            if (this.isOpen()) {
                Win32Monitor.this.fHandleValueToHandle.put(new Long(this.getHandleValue()), this);
                Win32Monitor.this.setHandleValueArrays(Win32Monitor.this.createHandleArrays());
            } else {
                this.close();
            }
        }

        protected void postRefreshRequest(IResource iResource) {
            if (!iResource.isSynchronized(2)) {
                Win32Monitor.this.refreshResult.refresh(iResource);
            }
        }

        public void setHandleValue(long l) {
            this.handleValue = l;
        }
    }

    protected class LinkedResourceHandle
    extends ChainedHandle {
        private List fileHandleChain;
        private IResource resource;

        public LinkedResourceHandle(IResource iResource) {
            this.resource = iResource;
            this.createFileHandleChain();
        }

        protected void createFileHandleChain() {
            this.fileHandleChain = new ArrayList(1);
            File file = new File(this.resource.getLocation().toOSString());
            file = file.getParentFile();
            while (file != null) {
                this.fileHandleChain.add(0, new FileHandle(file));
                file = file.getParentFile();
            }
            int n = this.fileHandleChain.size();
            int n2 = 0;
            while (n2 < n) {
                ChainedHandle chainedHandle = (ChainedHandle)this.fileHandleChain.get(n2);
                chainedHandle.setPrevious(n2 > 0 ? (ChainedHandle)this.fileHandleChain.get(n2 - 1) : null);
                chainedHandle.setNext(n2 + 1 < n ? (ChainedHandle)this.fileHandleChain.get(n2 + 1) : this);
                ++n2;
            }
            this.setPrevious(n > 0 ? (ChainedHandle)this.fileHandleChain.get(n - 1) : null);
        }

        public void destroy() {
            super.destroy();
            Iterator iterator = this.fileHandleChain.iterator();
            while (iterator.hasNext()) {
                Handle handle = (Handle)iterator.next();
                handle.destroy();
            }
        }

        public boolean exists() {
            IPath iPath = this.resource.getLocation();
            return iPath == null ? false : iPath.toFile().exists();
        }

        public void handleNotification() {
            if (this.isOpen()) {
                this.postRefreshRequest(this.resource);
                this.findNextChange();
            }
        }

        public void open() {
            if (!this.isOpen()) {
                FileHandle fileHandle;
                if (this.exists()) {
                    this.openHandleOn(this.resource);
                }
                if ((fileHandle = (FileHandle)this.getPrevious()) != null && !fileHandle.isOpen()) {
                    fileHandle.open();
                }
            }
        }

        public void postRefreshRequest() {
            this.postRefreshRequest(this.resource);
        }
    }

    protected class ResourceHandle
    extends Handle {
        private IResource resource;

        public ResourceHandle(IResource iResource) {
            this.resource = iResource;
        }

        public IResource getResource() {
            return this.resource;
        }

        public void handleNotification() {
            if (this.isOpen()) {
                this.postRefreshRequest(this.resource);
                this.findNextChange();
            }
        }

        public void open() {
            if (!this.isOpen()) {
                this.openHandleOn(this.resource);
            }
        }
    }
}

