/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import org.eclipse.core.internal.utils.KeyedHashSet;
import org.eclipse.core.runtime.Assert;

public class Cache {
    KeyedHashSet entries;
    Entry head;
    private int maximumCapacity;
    Entry tail;
    private double threshold;

    public Cache(int n) {
        this(Math.min(7, n), n, 0.25);
    }

    public Cache(int n, int n2, double d) {
        Assert.isTrue((n2 >= n ? 1 : 0) != 0, (String)"maximum capacity < initial capacity");
        Assert.isTrue((d >= 0.0 && d <= 1.0 ? 1 : 0) != 0, (String)"threshold should be between 0 and 1");
        Assert.isTrue((n > 0 ? 1 : 0) != 0, (String)"initial capacity must be greater than zero");
        this.entries = new KeyedHashSet(n);
        this.maximumCapacity = n2;
        this.threshold = d;
    }

    public void addEntry(Object object, Object object2) {
        this.addEntry(object, object2, 0L);
    }

    public Entry addEntry(Object object, Object object2, long l) {
        Entry entry = (Entry)this.entries.getByKey(object);
        if (entry == null) {
            entry = new Entry(object, object2, l);
            this.entries.add(entry);
        }
        entry.cached = object2;
        entry.timestamp = l;
        entry.makeHead();
        int n = this.entries.size() - this.maximumCapacity;
        if ((double)n > (double)this.maximumCapacity * this.threshold) {
            this.packEntries(n);
        }
        return entry;
    }

    public Entry getEntry(Object object) {
        return this.getEntry(object, true);
    }

    public Entry getEntry(Object object, boolean bl) {
        Entry entry = (Entry)this.entries.getByKey(object);
        if (entry == null) {
            return null;
        }
        if (!bl) {
            return entry;
        }
        entry.unchain();
        entry.makeHead();
        return entry;
    }

    public Entry getHead() {
        return this.head;
    }

    public Entry getTail() {
        return this.tail;
    }

    private void packEntries(int n) {
        Entry entry = this.tail;
        while (entry != null && n > 0) {
            entry.discard();
            entry = entry.previous;
            --n;
        }
    }

    public long size() {
        return this.entries.size();
    }

    public void discardAll() {
        this.entries.clear();
    }

    public void dispose() {
        this.discardAll();
        this.entries = null;
    }

    public class Entry
    implements KeyedHashSet.KeyedElement {
        Object cached;
        Object key;
        Entry next;
        Entry previous;
        long timestamp;

        public Entry(Object object, Object object2, long l) {
            this.key = object;
            this.cached = object2;
            this.timestamp = l;
        }

        public boolean compare(KeyedHashSet.KeyedElement keyedElement) {
            if (!(keyedElement instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)keyedElement;
            return this.key.equals(entry.key);
        }

        public void discard() {
            this.unchain();
            this.cached = null;
            Cache.this.entries.remove(this);
        }

        public Object getCached() {
            return this.cached;
        }

        public Object getKey() {
            return this.key;
        }

        public int getKeyHashCode() {
            return this.key.hashCode();
        }

        public Entry getNext() {
            return this.next;
        }

        public Entry getPrevious() {
            return this.previous;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean isHead() {
            return this.previous == null;
        }

        public boolean isTail() {
            return this.next == null;
        }

        void makeHead() {
            Entry entry = Cache.this.head;
            Cache.this.head = this;
            this.next = entry;
            this.previous = null;
            if (entry == null) {
                Cache.this.tail = this;
            } else {
                entry.previous = this;
            }
        }

        public void setCached(Object object) {
            this.cached = object;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public String toString() {
            return this.key + " -> " + this.cached + " [" + this.timestamp + ']';
        }

        void unchain() {
            if (Cache.this.tail == this) {
                Cache.this.tail = this.previous;
            } else {
                this.next.previous = this.previous;
            }
            if (Cache.this.head == this) {
                Cache.this.head = this.next;
            } else {
                this.previous.next = this.next;
            }
        }
    }
}

