/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class FileUtil {
    private static final byte[] buffer = new byte[8192];

    public static IFileInfo attributesToFileInfo(ResourceAttributes resourceAttributes) {
        IFileInfo iFileInfo = EFS.createFileInfo();
        iFileInfo.setAttribute(2, resourceAttributes.isReadOnly());
        iFileInfo.setAttribute(4, resourceAttributes.isExecutable());
        iFileInfo.setAttribute(8, resourceAttributes.isArchive());
        iFileInfo.setAttribute(16, resourceAttributes.isHidden());
        return iFileInfo;
    }

    public static IPath canonicalPath(IPath iPath) {
        if (iPath == null) {
            return null;
        }
        try {
            String string = iPath.toOSString();
            String string2 = new File(string).getCanonicalPath();
            if (string2.equals(string)) {
                return iPath;
            }
            return new Path(string2);
        }
        catch (IOException iOException) {
            return iPath;
        }
    }

    public static URI canonicalURI(URI uRI) {
        if (uRI == null) {
            return null;
        }
        if ("file".equals(uRI.getScheme())) {
            IPath iPath;
            IPath iPath2 = URIUtil.toPath((URI)uRI);
            if (iPath2 == (iPath = FileUtil.canonicalPath(iPath2))) {
                return uRI;
            }
            return URIUtil.toURI((IPath)iPath);
        }
        return uRI;
    }

    private static boolean computeOverlap(IPath iPath, IPath iPath2, boolean bl) {
        IPath iPath3 = iPath;
        IPath iPath4 = iPath2;
        if (!Workspace.caseSensitive) {
            iPath3 = new Path(iPath.toOSString().toLowerCase());
            iPath4 = new Path(iPath2.toOSString().toLowerCase());
        }
        return iPath3.isPrefixOf(iPath4) || bl && iPath4.isPrefixOf(iPath3);
    }

    private static boolean computeOverlap(URI uRI, URI uRI2, boolean bl) {
        IFileStore iFileStore;
        if (uRI.equals(uRI2)) {
            return true;
        }
        String string = uRI.getScheme();
        String string2 = uRI2.getScheme();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        if ("file".equals(string) && "file".equals(string2)) {
            return FileUtil.computeOverlap(URIUtil.toPath((URI)uRI), URIUtil.toPath((URI)uRI2), bl);
        }
        IFileSystem iFileSystem = null;
        try {
            iFileSystem = EFS.getFileSystem((String)string);
        }
        catch (CoreException coreException) {}
        if (iFileSystem == null) {
            String string3;
            String string4 = uRI.toString();
            return string4.startsWith(string3 = uRI2.toString()) || bl && string3.startsWith(string4);
        }
        IFileStore iFileStore2 = iFileSystem.getStore(uRI);
        return iFileStore2.equals(iFileStore = iFileSystem.getStore(uRI2)) || iFileStore2.isParentOf(iFileStore) || bl && iFileStore.isParentOf(iFileStore2);
    }

    public static ResourceAttributes fileInfoToAttributes(IFileInfo iFileInfo) {
        ResourceAttributes resourceAttributes = new ResourceAttributes();
        resourceAttributes.setReadOnly(iFileInfo.getAttribute(2));
        resourceAttributes.setArchive(iFileInfo.getAttribute(8));
        resourceAttributes.setExecutable(iFileInfo.getAttribute(4));
        resourceAttributes.setHidden(iFileInfo.getAttribute(16));
        resourceAttributes.setSymbolicLink(iFileInfo.getAttribute(32));
        return resourceAttributes;
    }

    public static boolean isOverlapping(URI uRI, URI uRI2) {
        return FileUtil.computeOverlap(uRI, uRI2, true);
    }

    public static boolean isPrefixOf(IPath iPath, IPath iPath2) {
        return FileUtil.computeOverlap(iPath, iPath2, false);
    }

    public static boolean isPrefixOf(URI uRI, URI uRI2) {
        return FileUtil.computeOverlap(uRI, uRI2, false);
    }

    public static void safeClose(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void safeClose(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static IPath toPath(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string = uRI.getScheme();
        if (string == null || "file".equals(string)) {
            return new Path(uRI.getSchemeSpecificPart());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transferStreams(InputStream inputStream, OutputStream outputStream, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            byte[] byArray = buffer;
            synchronized (buffer) {
                while (true) {
                    int n = -1;
                    try {
                        n = inputStream.read(buffer);
                    }
                    catch (IOException iOException) {
                        String string2 = NLS.bind((String)Messages.localstore_failedReadDuringWrite, (Object)string);
                        throw new ResourceException(271, (IPath)new Path(string), string2, iOException);
                    }
                    if (n == -1) break;
                    try {
                        outputStream.write(buffer, 0, n);
                    }
                    catch (IOException iOException) {
                        String string3 = NLS.bind((String)Messages.localstore_couldNotWrite, (Object)string);
                        throw new ResourceException(272, (IPath)new Path(string), string3, iOException);
                    }
                    iProgressMonitor.worked(1);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        finally {
            FileUtil.safeClose(inputStream);
            FileUtil.safeClose(outputStream);
        }
        {
            return;
        }
    }

    private FileUtil() {
    }
}

