/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

public class KeyedHashSet {
    protected static final int MINIMUM_SIZE = 7;
    private int capacity;
    protected int elementCount = 0;
    protected KeyedElement[] elements;
    protected boolean replace;

    public KeyedHashSet(int n) {
        this(n, true);
    }

    public KeyedHashSet(int n, boolean bl) {
        this.elements = new KeyedElement[Math.max(7, n * 2)];
        this.replace = bl;
        this.capacity = n;
    }

    public boolean add(KeyedElement keyedElement) {
        int n;
        int n2 = n = this.hash(keyedElement);
        while (n2 < this.elements.length) {
            if (this.elements[n2] == null) {
                this.elements[n2] = keyedElement;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (this.elements[n2].compare(keyedElement)) {
                if (this.replace) {
                    this.elements[n2] = keyedElement;
                }
                return this.replace;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            if (this.elements[n2] == null) {
                this.elements[n2] = keyedElement;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (this.elements[n2].compare(keyedElement)) {
                if (this.replace) {
                    this.elements[n2] = keyedElement;
                }
                return this.replace;
            }
            ++n2;
        }
        this.expand();
        return this.add(keyedElement);
    }

    public void clear() {
        this.elements = new KeyedElement[Math.max(7, this.capacity * 2)];
        this.elementCount = 0;
    }

    protected void expand() {
        KeyedElement[] keyedElementArray = this.elements;
        this.elements = new KeyedElement[this.elements.length * 2];
        int n = this.elements.length - 1;
        int n2 = 0;
        while (n2 < keyedElementArray.length) {
            KeyedElement keyedElement = keyedElementArray[n2];
            if (keyedElement != null) {
                int n3 = this.hash(keyedElement);
                while (this.elements[n3] != null) {
                    if (++n3 <= n) continue;
                    n3 = 0;
                }
                this.elements[n3] = keyedElement;
            }
            ++n2;
        }
    }

    public KeyedElement getByKey(Object object) {
        KeyedElement keyedElement;
        int n;
        if (this.elementCount == 0) {
            return null;
        }
        int n2 = n = this.keyHash(object);
        while (n2 < this.elements.length) {
            keyedElement = this.elements[n2];
            if (keyedElement == null) {
                return null;
            }
            if (keyedElement.getKey().equals(object)) {
                return keyedElement;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            keyedElement = this.elements[n2];
            if (keyedElement == null) {
                return null;
            }
            if (keyedElement.getKey().equals(object)) {
                return keyedElement;
            }
            ++n2;
        }
        return null;
    }

    private int hash(KeyedElement keyedElement) {
        return Math.abs(keyedElement.getKeyHashCode()) % this.elements.length;
    }

    private int keyHash(Object object) {
        return Math.abs(object.hashCode()) % this.elements.length;
    }

    protected void rehashTo(int n) {
        int n2 = n;
        int n3 = n + 1;
        if (n3 >= this.elements.length) {
            n3 = 0;
        }
        KeyedElement keyedElement = this.elements[n3];
        while (keyedElement != null) {
            boolean bl;
            int n4 = this.hash(keyedElement);
            if (n3 < n2) {
                bl = n4 <= n2 && n4 > n3;
            } else {
                boolean bl2 = bl = n4 <= n2 || n4 > n3;
            }
            if (bl) {
                this.elements[n2] = keyedElement;
                n2 = n3;
            }
            if (++n3 >= this.elements.length) {
                n3 = 0;
            }
            keyedElement = this.elements[n3];
        }
        this.elements[n2] = null;
    }

    public boolean remove(KeyedElement keyedElement) {
        KeyedElement keyedElement2;
        int n;
        if (this.elementCount == 0) {
            return false;
        }
        int n2 = n = this.hash(keyedElement);
        while (n2 < this.elements.length) {
            keyedElement2 = this.elements[n2];
            if (keyedElement2 == null) {
                return false;
            }
            if (keyedElement2.compare(keyedElement)) {
                this.rehashTo(n2);
                --this.elementCount;
                return true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            keyedElement2 = this.elements[n2];
            if (keyedElement2 == null) {
                return false;
            }
            if (keyedElement2.compare(keyedElement)) {
                this.rehashTo(n2);
                --this.elementCount;
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.elements.length * 0.75;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append('{');
        boolean bl = true;
        int n = 0;
        while (n < this.elements.length) {
            if (this.elements[n] != null) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.elements[n]);
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static interface KeyedElement {
        public boolean compare(KeyedElement var1);

        public Object getKey();

        public int getKeyHashCode();
    }
}

