/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.util.Date;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;

public class Policy {
    public static final boolean buildOnCancel = false;
    public static boolean DEBUG = false;
    public static boolean DEBUG_AUTO_REFRESH = false;
    public static boolean DEBUG_BUILD_DELTA = false;
    public static boolean DEBUG_BUILD_FAILURE = false;
    public static boolean DEBUG_BUILD_INTERRUPT = false;
    public static boolean DEBUG_BUILD_INVOKING = false;
    public static boolean DEBUG_BUILD_NEEDED = false;
    public static boolean DEBUG_BUILD_NEEDED_STACK = false;
    public static boolean DEBUG_BUILD_STACK = false;
    public static boolean DEBUG_CONTENT_TYPE = false;
    public static boolean DEBUG_CONTENT_TYPE_CACHE = false;
    public static boolean DEBUG_HISTORY = false;
    public static boolean DEBUG_NATURES = false;
    public static boolean DEBUG_PREFERENCES = false;
    public static boolean DEBUG_RESTORE = false;
    public static boolean DEBUG_RESTORE_MARKERS = false;
    public static boolean DEBUG_RESTORE_MASTERTABLE = false;
    public static boolean DEBUG_RESTORE_METAINFO = false;
    public static boolean DEBUG_RESTORE_SNAPSHOTS = false;
    public static boolean DEBUG_RESTORE_SYNCINFO = false;
    public static boolean DEBUG_RESTORE_TREE = false;
    public static boolean DEBUG_SAVE = false;
    public static boolean DEBUG_SAVE_MARKERS = false;
    public static boolean DEBUG_SAVE_MASTERTABLE = false;
    public static boolean DEBUG_SAVE_METAINFO = false;
    public static boolean DEBUG_SAVE_SYNCINFO = false;
    public static boolean DEBUG_SAVE_TREE = false;
    public static boolean DEBUG_STRINGS = false;
    public static int endOpWork = 1;
    public static final long MAX_BUILD_DELAY = 1000L;
    public static final long MIN_BUILD_DELAY = 100L;
    public static int opWork = 99;
    public static final int totalWork = 100;

    static {
        if (ResourcesPlugin.getPlugin().isDebugging()) {
            DEBUG = true;
            String string = Boolean.TRUE.toString();
            DEBUG_AUTO_REFRESH = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/refresh"));
            DEBUG_BUILD_DELTA = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/delta"));
            DEBUG_BUILD_FAILURE = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/failure"));
            DEBUG_BUILD_INVOKING = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/invoking"));
            DEBUG_BUILD_INTERRUPT = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/interrupt"));
            DEBUG_BUILD_NEEDED = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/needbuild"));
            DEBUG_BUILD_NEEDED_STACK = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/needbuildstack"));
            DEBUG_BUILD_STACK = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/build/stacktrace"));
            DEBUG_CONTENT_TYPE = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/contenttype"));
            DEBUG_CONTENT_TYPE_CACHE = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/contenttype/cache"));
            DEBUG_HISTORY = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/history"));
            DEBUG_NATURES = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/natures"));
            DEBUG_PREFERENCES = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/preferences"));
            DEBUG_RESTORE = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore"));
            DEBUG_RESTORE_MARKERS = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/markers"));
            DEBUG_RESTORE_MASTERTABLE = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/mastertable"));
            DEBUG_RESTORE_METAINFO = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/metainfo"));
            DEBUG_RESTORE_SNAPSHOTS = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/snapshots"));
            DEBUG_RESTORE_SYNCINFO = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/syncinfo"));
            DEBUG_RESTORE_TREE = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/restore/tree"));
            DEBUG_SAVE = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save"));
            DEBUG_SAVE_MARKERS = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/markers"));
            DEBUG_SAVE_MASTERTABLE = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/mastertable"));
            DEBUG_SAVE_METAINFO = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/metainfo"));
            DEBUG_SAVE_SYNCINFO = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/syncinfo"));
            DEBUG_SAVE_TREE = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/save/tree"));
            DEBUG_STRINGS = string.equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.core.resources/strings"));
        }
    }

    public static void checkCanceled(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void debug(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new Date(System.currentTimeMillis()));
        stringBuffer.append(" - [");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append("] ");
        stringBuffer.append(string);
        System.out.println(stringBuffer.toString());
    }

    public static void log(int n, String string, Throwable throwable) {
        if (string == null) {
            string = "";
        }
        Policy.log((IStatus)new Status(n, "org.eclipse.core.resources", 1, string, throwable));
    }

    public static void log(IStatus iStatus) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
        if (bundle == null) {
            return;
        }
        Platform.getLog((Bundle)bundle).log(iStatus);
    }

    public static void log(Throwable throwable) {
        Policy.log(4, "Internal Error", throwable);
    }

    public static IProgressMonitor monitorFor(IProgressMonitor iProgressMonitor) {
        return iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor iProgressMonitor, int n) {
        if (iProgressMonitor == null) {
            return new NullProgressMonitor();
        }
        if (iProgressMonitor instanceof NullProgressMonitor) {
            return iProgressMonitor;
        }
        return new SubProgressMonitor(iProgressMonitor, n);
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor iProgressMonitor, int n, int n2) {
        if (iProgressMonitor == null) {
            return new NullProgressMonitor();
        }
        if (iProgressMonitor instanceof NullProgressMonitor) {
            return iProgressMonitor;
        }
        return new SubProgressMonitor(iProgressMonitor, n, n2);
    }
}

