/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.internal.utils.ArrayIterator;

public class Queue {
    protected Object[] elements;
    protected int head;
    protected int tail;
    protected boolean reuse;

    public Queue() {
        this(20, false);
    }

    public Queue(int n, boolean bl) {
        this.elements = new Object[n];
        this.tail = 0;
        this.head = 0;
        this.reuse = bl;
    }

    public void add(Object object) {
        int n = this.increment(this.tail);
        if (n == this.head) {
            this.grow();
            n = this.tail + 1;
        }
        this.elements[this.tail] = object;
        this.tail = n;
    }

    public int decrement(int n) {
        return n == 0 ? this.elements.length - 1 : n - 1;
    }

    public Object elementAt(int n) {
        return this.elements[n];
    }

    public Iterator iterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (this.head <= this.tail) {
            return new ArrayIterator(this.elements, this.head, this.tail - 1);
        }
        Object[] objectArray = new Object[this.size()];
        int n = this.elements.length - this.head;
        System.arraycopy(this.elements, this.head, objectArray, 0, n);
        System.arraycopy(this.elements, 0, objectArray, n, this.tail);
        return new ArrayIterator(objectArray);
    }

    public Object getNextAvailableObject() {
        int n = this.tail;
        while (n != this.head) {
            if (this.elements[n] != null) {
                Object object = this.elements[n];
                this.elements[n] = null;
                return object;
            }
            n = this.increment(n);
        }
        return null;
    }

    protected void grow() {
        int n = (int)((double)this.elements.length * 1.5);
        Object[] objectArray = new Object[n];
        if (this.tail >= this.head) {
            System.arraycopy(this.elements, this.head, objectArray, this.head, this.size());
        } else {
            int n2 = n - (this.elements.length - this.head);
            System.arraycopy(this.elements, 0, objectArray, 0, this.tail + 1);
            System.arraycopy(this.elements, this.head, objectArray, n2, n - n2);
            this.head = n2;
        }
        this.elements = objectArray;
    }

    public int increment(int n) {
        return n == this.elements.length - 1 ? 0 : n + 1;
    }

    public int indexOf(Object object) {
        if (this.tail >= this.head) {
            int n = this.head;
            while (n < this.tail) {
                if (object.equals(this.elements[n])) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = this.head;
            while (n < this.elements.length) {
                if (object.equals(this.elements[n])) {
                    return n;
                }
                ++n;
            }
            n = 0;
            while (n < this.tail) {
                if (object.equals(this.elements[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public Object peek() {
        return this.elements[this.head];
    }

    public Object peekTail() {
        return this.elements[this.decrement(this.tail)];
    }

    public Object remove() {
        if (this.isEmpty()) {
            return null;
        }
        Object object = this.peek();
        if (!this.reuse) {
            this.elements[this.head] = null;
        }
        this.head = this.increment(this.head);
        return object;
    }

    public Object removeTail() {
        Object object = this.peekTail();
        this.tail = this.decrement(this.tail);
        if (!this.reuse) {
            this.elements[this.tail] = null;
        }
        return object;
    }

    public void reset() {
        this.head = 0;
        this.tail = 0;
    }

    public int size() {
        return this.tail > this.head ? this.tail - this.head : this.elements.length - this.head + this.tail;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n = 0;
        if (!this.isEmpty()) {
            Iterator iterator = this.iterator();
            while (n < 100) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) break;
                stringBuffer.append(',').append(' ');
            }
        }
        if (n < this.size()) {
            stringBuffer.append('.').append('.').append('.');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

