/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.osgi.framework.Bundle;

public class StringPoolJob
extends Job {
    private static final long INITIAL_DELAY = 10000L;
    private static final long RESCHEDULE_DELAY = 300000L;
    private long lastDuration;
    private Map participants = Collections.synchronizedMap(new HashMap(10));
    private final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");

    public StringPoolJob() {
        super(Messages.utils_stringJobName);
        this.setSystem(true);
        this.setPriority(50);
    }

    public void addStringPoolParticipant(IStringPoolParticipant iStringPoolParticipant, ISchedulingRule iSchedulingRule) {
        this.participants.put(iStringPoolParticipant, iSchedulingRule);
        if (this.getState() == 1) {
            this.wakeUp(10000L);
        } else {
            this.schedule(10000L);
        }
    }

    public void removeStringPoolParticipant(IStringPoolParticipant iStringPoolParticipant) {
        this.participants.remove(iStringPoolParticipant);
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (this.systemBundle.getState() == 16) {
            return Status.OK_STATUS;
        }
        Map.Entry[] entryArray = this.participants.entrySet().toArray(new Map.Entry[0]);
        ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[entryArray.length];
        IStringPoolParticipant[] iStringPoolParticipantArray = new IStringPoolParticipant[entryArray.length];
        int n = 0;
        while (n < iStringPoolParticipantArray.length) {
            iStringPoolParticipantArray[n] = (IStringPoolParticipant)entryArray[n].getKey();
            iSchedulingRuleArray[n] = (ISchedulingRule)entryArray[n].getValue();
            ++n;
        }
        ISchedulingRule iSchedulingRule = MultiRule.combine((ISchedulingRule[])iSchedulingRuleArray);
        long l = -1L;
        int n2 = 0;
        IJobManager iJobManager = Job.getJobManager();
        try {
            iJobManager.beginRule(iSchedulingRule, iProgressMonitor);
            l = System.currentTimeMillis();
            n2 = this.shareStrings(iStringPoolParticipantArray, iProgressMonitor);
        }
        finally {
            iJobManager.endRule(iSchedulingRule);
        }
        if (l > 0L) {
            this.lastDuration = System.currentTimeMillis() - l;
            if (Policy.DEBUG_STRINGS) {
                Policy.debug("String sharing saved " + n2 + " bytes in: " + this.lastDuration);
            }
        }
        long l2 = Math.max(300000L, this.lastDuration * 100L);
        if (Policy.DEBUG_STRINGS) {
            Policy.debug("Rescheduling string sharing job in: " + l2);
        }
        this.schedule(l2);
        return Status.OK_STATUS;
    }

    private int shareStrings(IStringPoolParticipant[] iStringPoolParticipantArray, IProgressMonitor iProgressMonitor) {
        final StringPool stringPool = new StringPool();
        int n = 0;
        while (n < iStringPoolParticipantArray.length) {
            if (iProgressMonitor.isCanceled()) break;
            final IStringPoolParticipant iStringPoolParticipant = iStringPoolParticipantArray[n];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                }

                public void run() {
                    iStringPoolParticipant.shareStrings(stringPool);
                }
            });
            ++n;
        }
        return stringPool.getSavedStringCount();
    }
}

