/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.GregorianCalendar;
import java.util.Random;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.Assert;

public class UniversalUniqueIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] fBits = new byte[16];
    private static BigInteger fgPreviousClockValue;
    private static int fgClockAdjustment;
    private static int fgClockSequence;
    private static byte[] nodeAddress;
    private static Random fgRandomNumberGenerator;
    public static final int BYTES_SIZE = 16;
    public static final byte[] UNDEFINED_UUID_BYTES;
    public static final int MAX_CLOCK_SEQUENCE = 16384;
    public static final int MAX_CLOCK_ADJUSTMENT = Short.MAX_VALUE;
    public static final int TIME_FIELD_START = 0;
    public static final int TIME_FIELD_STOP = 6;
    public static final int TIME_HIGH_AND_VERSION = 7;
    public static final int CLOCK_SEQUENCE_HIGH_AND_RESERVED = 8;
    public static final int CLOCK_SEQUENCE_LOW = 9;
    public static final int NODE_ADDRESS_START = 10;
    public static final int NODE_ADDRESS_BYTE_SIZE = 6;
    public static final int BYTE_MASK = 255;
    public static final int HIGH_NIBBLE_MASK = 240;
    public static final int LOW_NIBBLE_MASK = 15;
    public static final int SHIFT_NIBBLE = 4;
    public static final int ShiftByte = 8;

    static {
        fgClockAdjustment = 0;
        fgClockSequence = -1;
        nodeAddress = UniversalUniqueIdentifier.computeNodeAddress();
        fgRandomNumberGenerator = new Random();
        UNDEFINED_UUID_BYTES = new byte[16];
    }

    public UniversalUniqueIdentifier() {
        this.setVersion(1);
        this.setVariant(1);
        this.setTimeValues();
        this.setNode(UniversalUniqueIdentifier.getNodeAddress());
    }

    public UniversalUniqueIdentifier(byte[] byArray) {
        this.fBits = new byte[16];
        if (byArray.length >= 16) {
            System.arraycopy(byArray, 0, this.fBits, 0, 16);
        }
    }

    private void appendByteString(StringBuffer stringBuffer, byte by) {
        String string = by < 0 ? Integer.toHexString(256 + by) : Integer.toHexString(by);
        if (string.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
    }

    private static BigInteger clockValueNow() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        BigInteger bigInteger = BigInteger.valueOf(gregorianCalendar.getTime().getTime());
        BigInteger bigInteger2 = BigInteger.valueOf(gregorianCalendar.getGregorianChange().getTime());
        return bigInteger.subtract(bigInteger2).multiply(BigInteger.valueOf(10000L));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.isTrue((boolean)false, (String)Messages.utils_clone);
            return null;
        }
    }

    public static int compareTime(byte[] byArray, byte[] byArray2) {
        int n = 6;
        while (n >= 0) {
            if (byArray[n] != byArray2[n]) {
                return (0xFF & byArray[n]) - (0xFF & byArray2[n]);
            }
            --n;
        }
        return 0;
    }

    private static byte[] computeNodeAddress() {
        byte[] byArray = new byte[6];
        int n = Thread.currentThread().hashCode();
        long l = System.currentTimeMillis();
        int n2 = System.identityHashCode(new String());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray2 = UniversalUniqueIdentifier.getIPAddress();
        try {
            if (byArray2 != null) {
                dataOutputStream.write(byArray2);
            }
            dataOutputStream.write(n);
            dataOutputStream.writeLong(l);
            dataOutputStream.write(n2);
            dataOutputStream.close();
        }
        catch (IOException iOException) {}
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        SecureRandom secureRandom = new SecureRandom(byArray3);
        secureRandom.nextBytes(byArray);
        byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        return byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UniversalUniqueIdentifier)) {
            return false;
        }
        byte[] byArray = ((UniversalUniqueIdentifier)object).fBits;
        if (this.fBits == byArray) {
            return true;
        }
        if (this.fBits.length != byArray.length) {
            return false;
        }
        int n = 0;
        while (n < this.fBits.length) {
            if (this.fBits[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected static byte[] getIPAddress() {
        try {
            return InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static byte[] getNodeAddress() {
        return nodeAddress;
    }

    public int hashCode() {
        return this.fBits[0] + this.fBits[3] + this.fBits[7] + this.fBits[11] + this.fBits[15];
    }

    private static int nextClockSequence() {
        if (fgClockSequence == -1) {
            fgClockSequence = (int)(fgRandomNumberGenerator.nextDouble() * 16384.0);
        }
        fgClockSequence = (fgClockSequence + 1) % 16384;
        return fgClockSequence;
    }

    private static BigInteger nextTimestamp() {
        BigInteger bigInteger = UniversalUniqueIdentifier.clockValueNow();
        int n = bigInteger.compareTo(fgPreviousClockValue);
        if (n == 0) {
            if (fgClockAdjustment == Short.MAX_VALUE) {
                while (bigInteger.compareTo(fgPreviousClockValue) == 0) {
                    bigInteger = UniversalUniqueIdentifier.clockValueNow();
                }
                bigInteger = UniversalUniqueIdentifier.nextTimestamp();
            } else {
                ++fgClockAdjustment;
            }
        } else {
            fgClockAdjustment = 0;
            if (n < 0) {
                UniversalUniqueIdentifier.nextClockSequence();
            }
        }
        return bigInteger;
    }

    private void setClockSequence(int n) {
        int n2 = n >>> 8 & 0xF;
        int n3 = this.fBits[8] & 0xF0;
        this.fBits[8] = (byte)(n3 | n2);
        this.fBits[9] = (byte)(n & 0xFF);
    }

    protected void setNode(byte[] byArray) {
        int n = 0;
        while (n < 6) {
            this.fBits[n + 10] = byArray[n];
            ++n;
        }
    }

    private void setTimestamp(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = BigInteger.valueOf(256L);
        int n = 0;
        while (n < 6) {
            BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(bigInteger3);
            bigInteger2 = bigIntegerArray[0];
            this.fBits[n] = (byte)bigIntegerArray[1].intValue();
            ++n;
        }
        int n2 = this.fBits[7] & 0xF0;
        int n3 = bigInteger2.intValue() & 0xF;
        this.fBits[7] = (byte)(n3 | n2);
    }

    protected synchronized void setTimeValues() {
        this.setTimestamp(UniversalUniqueIdentifier.timestamp());
        this.setClockSequence(fgClockSequence);
    }

    protected int setVariant(int n) {
        int n2 = this.fBits[8] & 0xF;
        int n3 = n & 0xF;
        this.fBits[8] = (byte)(n3 << 4 | n2);
        return n3;
    }

    protected void setVersion(int n) {
        int n2 = this.fBits[7] & 0xF;
        int n3 = n & 0xF;
        this.fBits[7] = (byte)(n2 | n3 << 4);
    }

    private static BigInteger timestamp() {
        BigInteger bigInteger;
        if (fgPreviousClockValue == null) {
            fgClockAdjustment = 0;
            UniversalUniqueIdentifier.nextClockSequence();
            bigInteger = UniversalUniqueIdentifier.clockValueNow();
        } else {
            bigInteger = UniversalUniqueIdentifier.nextTimestamp();
        }
        fgPreviousClockValue = bigInteger;
        return fgClockAdjustment == 0 ? bigInteger : bigInteger.add(BigInteger.valueOf(fgClockAdjustment));
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[this.fBits.length];
        System.arraycopy(this.fBits, 0, byArray, 0, this.fBits.length);
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fBits.length) {
            this.appendByteString(stringBuffer, this.fBits[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toStringAsBytes() {
        String string = "{";
        int n = 0;
        while (n < this.fBits.length) {
            string = String.valueOf(string) + this.fBits[n];
            if (n < this.fBits.length + 1) {
                string = String.valueOf(string) + ",";
            }
            ++n;
        }
        return String.valueOf(string) + "}";
    }
}

