/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import java.util.HashMap;
import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeLookup;
import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.internal.watson.DefaultElementComparator;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementComparator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IElementTreeData;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ElementTree {
    protected DeltaDataTree tree;
    protected IElementTreeData userData;
    private volatile ChildIDsCache childIDsCache = null;
    private volatile DataTreeLookup lookupCache = null;
    private volatile DataTreeLookup lookupCacheIgnoreCase = null;
    private static int treeCounter = 0;
    private int treeStamp;

    public ElementTree() {
        this.initialize(new DeltaDataTree());
    }

    protected ElementTree(DataTreeNode dataTreeNode) {
        this.initialize(dataTreeNode);
    }

    protected ElementTree(DeltaDataTree deltaDataTree) {
        this.initialize(deltaDataTree);
    }

    protected ElementTree(ElementTree elementTree) {
        IElementTreeData iElementTreeData;
        if (!elementTree.isImmutable()) {
            elementTree.immutable();
        }
        if ((iElementTreeData = elementTree.getTreeData()) != null) {
            this.userData = (IElementTreeData)iElementTreeData.clone();
        }
        this.initialize(elementTree.tree.newEmptyDeltaTree());
    }

    public synchronized ElementTree collapseTo(ElementTree elementTree) {
        Assert.isTrue((boolean)this.tree.isImmutable());
        if (this == elementTree) {
            return this;
        }
        this.tree.collapseTo(elementTree.tree, DefaultElementComparator.getComparator());
        return this;
    }

    public synchronized void createElement(IPath iPath, Object object) {
        if (iPath.isRoot()) {
            return;
        }
        this.childIDsCache = null;
        IPath iPath2 = iPath.removeLastSegments(1);
        try {
            this.tree.createChild(iPath2, iPath.lastSegment(), object);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(iPath2);
        }
        this.lookupCache = DataTreeLookup.newLookup(iPath, true, object, true);
        this.lookupCacheIgnoreCase = null;
    }

    public synchronized void createSubtree(IPath iPath, ElementTree elementTree) {
        if (iPath.isRoot()) {
            throw new IllegalArgumentException(Messages.watson_noModify);
        }
        this.childIDsCache = null;
        this.lookupCacheIgnoreCase = null;
        this.lookupCache = null;
        try {
            IPath[] iPathArray = elementTree.getChildren(elementTree.getRoot());
            if (iPathArray.length != 1) {
                throw new IllegalArgumentException(Messages.watson_illegalSubtree);
            }
            DataTreeNode dataTreeNode = (DataTreeNode)elementTree.tree.copyCompleteSubtree(iPathArray[0]);
            this.tree.createSubtree(iPath, dataTreeNode);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(iPath);
        }
    }

    public synchronized void deleteElement(IPath iPath) {
        if (iPath.isRoot()) {
            return;
        }
        this.childIDsCache = null;
        this.lookupCacheIgnoreCase = null;
        this.lookupCache = null;
        try {
            this.tree.deleteChild(iPath.removeLastSegments(1), iPath.lastSegment());
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(iPath);
        }
    }

    protected void elementNotFound(IPath iPath) {
        throw new IllegalArgumentException(NLS.bind((String)Messages.watson_elementNotFound, (Object)iPath));
    }

    public static int findOldest(ElementTree[] elementTreeArray) {
        HashMap<ElementTree, ElementTree> hashMap = new HashMap<ElementTree, ElementTree>((int)((double)elementTreeArray.length * 1.5 + 1.0));
        int n = 0;
        while (n < elementTreeArray.length) {
            hashMap.put(elementTreeArray[n], elementTreeArray[n]);
            ++n;
        }
        ElementTree elementTree = null;
        while (hashMap.size() > 0) {
            ElementTree elementTree2 = (ElementTree)hashMap.values().iterator().next();
            hashMap.remove(elementTree2);
            ElementTree elementTree3 = elementTree2.getParent();
            while (elementTree3 != null && elementTree3 != elementTree) {
                hashMap.remove(elementTree3);
                elementTree3 = elementTree3.getParent();
            }
            elementTree = elementTree2;
        }
        Assert.isNotNull(elementTree);
        int n2 = 0;
        while (n2 < elementTreeArray.length) {
            if (elementTreeArray[n2] == elementTree) {
                return n2;
            }
            ++n2;
        }
        Assert.isTrue((boolean)false, (String)"Should not get here");
        return -1;
    }

    public synchronized int getChildCount(IPath iPath) {
        Assert.isNotNull((Object)iPath);
        return this.getChildIDs(iPath).length;
    }

    protected IPath[] getChildIDs(IPath iPath) {
        ChildIDsCache childIDsCache = this.childIDsCache;
        if (childIDsCache != null && childIDsCache.path == iPath) {
            return childIDsCache.childPaths;
        }
        try {
            if (iPath == null) {
                return new IPath[]{this.tree.rootKey()};
            }
            IPath[] iPathArray = this.tree.getChildren(iPath);
            this.childIDsCache = new ChildIDsCache(iPath, iPathArray);
            return iPathArray;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(iPath);
            return null;
        }
    }

    public synchronized IPath[] getChildren(IPath iPath) {
        Assert.isNotNull((Object)iPath);
        return this.getChildIDs(iPath);
    }

    public DeltaDataTree getDataTree() {
        return this.tree;
    }

    public synchronized Object getElementData(IPath iPath) {
        if (iPath.isRoot()) {
            return null;
        }
        DataTreeLookup dataTreeLookup = this.lookupCache;
        if (dataTreeLookup == null || dataTreeLookup.key != iPath) {
            this.lookupCache = dataTreeLookup = this.tree.lookup(iPath);
        }
        if (dataTreeLookup.isPresent) {
            return dataTreeLookup.data;
        }
        this.elementNotFound(iPath);
        return null;
    }

    public synchronized Object getElementDataIgnoreCase(IPath iPath) {
        if (iPath.isRoot()) {
            return null;
        }
        DataTreeLookup dataTreeLookup = this.lookupCacheIgnoreCase;
        if (dataTreeLookup == null || dataTreeLookup.key != iPath) {
            this.lookupCacheIgnoreCase = dataTreeLookup = this.tree.lookupIgnoreCase(iPath);
        }
        if (dataTreeLookup.isPresent) {
            return dataTreeLookup.data;
        }
        this.elementNotFound(iPath);
        return null;
    }

    public synchronized String[] getNamesOfChildren(IPath iPath) {
        try {
            if (iPath == null) {
                return new String[]{""};
            }
            return this.tree.getNamesOfChildren(iPath);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(iPath);
            return null;
        }
    }

    public ElementTree getParent() {
        DeltaDataTree deltaDataTree = this.tree.getParent();
        if (deltaDataTree == null) {
            return null;
        }
        return (ElementTree)deltaDataTree.getData(this.tree.rootKey());
    }

    public IPath getRoot() {
        return this.getChildIDs(null)[0];
    }

    public ElementTree getSubtree(IPath iPath) {
        if (iPath.isRoot()) {
            return this;
        }
        try {
            DataTreeNode dataTreeNode = (DataTreeNode)this.tree.copyCompleteSubtree(iPath);
            return new ElementTree(dataTreeNode);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(iPath);
            return null;
        }
    }

    public IElementTreeData getTreeData() {
        return this.userData;
    }

    public static boolean hasChanges(ElementTree elementTree, ElementTree elementTree2, IElementComparator iElementComparator, boolean bl) {
        ElementTree elementTree3;
        if (elementTree == null || elementTree2 == null) {
            return true;
        }
        if (elementTree == elementTree2) {
            return false;
        }
        if (iElementComparator.compare(elementTree.getTreeData(), elementTree2.getTreeData()) != 0) {
            return true;
        }
        ElementTree elementTree4 = null;
        if (elementTree.isImmutable()) {
            elementTree4 = elementTree.getParent();
        } else {
            elementTree3 = elementTree;
            while (elementTree3 != null && elementTree3.getParent() != null) {
                if (!elementTree3.getDataTree().isEmptyDelta()) {
                    return true;
                }
                elementTree3 = elementTree3.getParent();
            }
        }
        elementTree3 = bl ? elementTree2 : elementTree2.getParent();
        while (elementTree3 != null && elementTree3.getParent() != elementTree4) {
            if (!elementTree3.getDataTree().isEmptyDelta()) {
                return true;
            }
            elementTree3 = elementTree3.getParent();
        }
        return false;
    }

    public synchronized void immutable() {
        if (!this.tree.isImmutable()) {
            this.tree.immutable();
            this.lookupCacheIgnoreCase = null;
            this.lookupCache = null;
            this.tree.reroot();
        }
    }

    public synchronized boolean includes(IPath iPath) {
        DataTreeLookup dataTreeLookup = this.lookupCache;
        if (dataTreeLookup == null || dataTreeLookup.key != iPath) {
            this.lookupCache = dataTreeLookup = this.tree.lookup(iPath);
        }
        return dataTreeLookup.isPresent;
    }

    public boolean includesIgnoreCase(IPath iPath) {
        DataTreeLookup dataTreeLookup = this.lookupCacheIgnoreCase;
        if (dataTreeLookup == null || dataTreeLookup.key != iPath) {
            this.lookupCacheIgnoreCase = dataTreeLookup = this.tree.lookupIgnoreCase(iPath);
        }
        return dataTreeLookup.isPresent;
    }

    protected void initialize(DataTreeNode dataTreeNode) {
        this.initialize(new DeltaDataTree(new DataTreeNode(null, null, new AbstractDataTreeNode[]{dataTreeNode})));
    }

    protected void initialize(DeltaDataTree deltaDataTree) {
        this.treeStamp = treeCounter++;
        deltaDataTree.setData(deltaDataTree.rootKey(), this);
        this.tree = deltaDataTree;
    }

    public boolean isImmutable() {
        return this.tree.isImmutable();
    }

    public ElementTree mergeDeltaChain(IPath iPath, ElementTree[] elementTreeArray) {
        if (iPath == null || elementTreeArray == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.watson_nullArg, (Object)"ElementTree.mergeDeltaChain"));
        }
        if (this.isImmutable()) {
            throw new IllegalArgumentException(Messages.watson_immutable);
        }
        ElementTree elementTree = this;
        if (elementTreeArray.length > 0) {
            ElementTree elementTree2 = elementTreeArray[ElementTree.findOldest(elementTreeArray)];
            while (elementTree2 != null) {
                if (iPath.isRoot()) {
                    IPath[] iPathArray = elementTree2.getChildren((IPath)Path.ROOT);
                    int n = 0;
                    while (n < iPathArray.length) {
                        elementTree.createSubtree(iPathArray[n], elementTree2.getSubtree(iPathArray[n]));
                        ++n;
                    }
                } else {
                    elementTree.createSubtree(iPath, elementTree2.getSubtree(iPath));
                }
                elementTree.immutable();
                int n = 0;
                while (n < elementTreeArray.length) {
                    if (elementTreeArray[n] == elementTree2) {
                        elementTreeArray[n] = elementTree;
                    }
                    ++n;
                }
                elementTree = elementTree.newEmptyDelta();
                elementTree2 = elementTree2.getParent();
            }
        }
        return elementTree;
    }

    public synchronized ElementTree newEmptyDelta() {
        this.lookupCacheIgnoreCase = null;
        this.lookupCache = null;
        return new ElementTree(this);
    }

    public synchronized Object openElementData(IPath iPath) {
        Assert.isTrue((!this.isImmutable() ? 1 : 0) != 0);
        if (iPath.isRoot()) {
            return null;
        }
        DataTreeLookup dataTreeLookup = this.lookupCache;
        if (dataTreeLookup == null || dataTreeLookup.key != iPath) {
            this.lookupCache = dataTreeLookup = this.tree.lookup(iPath);
        }
        if (dataTreeLookup.isPresent) {
            if (dataTreeLookup.foundInFirstDelta) {
                return dataTreeLookup.data;
            }
            IElementTreeData iElementTreeData = (IElementTreeData)dataTreeLookup.data;
            if (iElementTreeData != null) {
                try {
                    Object object = iElementTreeData.clone();
                    this.tree.setData(iPath, object);
                    this.lookupCacheIgnoreCase = null;
                    this.lookupCache = null;
                    return object;
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    this.elementNotFound(iPath);
                }
            }
        } else {
            this.elementNotFound(iPath);
        }
        return null;
    }

    public synchronized void setElementData(IPath iPath, Object object) {
        if (iPath.isRoot()) {
            return;
        }
        Assert.isNotNull((Object)iPath);
        this.lookupCacheIgnoreCase = null;
        this.lookupCache = null;
        try {
            this.tree.setData(iPath, object);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.elementNotFound(iPath);
        }
    }

    public void setTreeData(IElementTreeData iElementTreeData) {
        this.userData = iElementTreeData;
    }

    public void shareStrings(StringPool stringPool) {
        this.tree.storeStrings(stringPool);
    }

    public String toDebugString() {
        final StringBuffer stringBuffer = new StringBuffer("\n");
        IElementContentVisitor iElementContentVisitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree elementTree, IPathRequestor iPathRequestor, Object object) {
                stringBuffer.append(iPathRequestor.requestPath() + " " + object + "\n");
                return true;
            }
        };
        new ElementTreeIterator(this, (IPath)Path.ROOT).iterate(iElementContentVisitor);
        return stringBuffer.toString();
    }

    public String toString() {
        return "ElementTree(" + this.treeStamp + ")";
    }

    private class ChildIDsCache {
        IPath path;
        IPath[] childPaths;

        ChildIDsCache(IPath iPath, IPath[] iPathArray) {
            this.path = iPath;
            this.childPaths = iPathArray;
        }
    }
}

