/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeNode;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ElementTreeIterator
implements IPathRequestor {
    private String[] segments = new String[10];
    private int nextFreeSegment;
    private ElementTree tree;
    private IPath path;
    private DataTreeNode treeRoot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementTreeIterator(ElementTree elementTree, IPath iPath) {
        this.tree = elementTree;
        this.path = iPath;
        ElementTree elementTree2 = elementTree;
        synchronized (elementTree2) {
            this.treeRoot = (DataTreeNode)elementTree.getDataTree().safeCopyCompleteSubtree(iPath);
        }
    }

    private void doIteration(DataTreeNode dataTreeNode, IElementContentVisitor iElementContentVisitor) {
        if (this.nextFreeSegment >= this.segments.length) {
            this.grow();
        }
        this.segments[this.nextFreeSegment++] = dataTreeNode.getName();
        if (iElementContentVisitor.visitElement(this.tree, this, dataTreeNode.getData())) {
            AbstractDataTreeNode[] abstractDataTreeNodeArray = dataTreeNode.getChildren();
            int n = abstractDataTreeNodeArray.length;
            while (--n >= 0) {
                this.doIteration((DataTreeNode)abstractDataTreeNodeArray[n], iElementContentVisitor);
            }
        }
        --this.nextFreeSegment;
        if (this.nextFreeSegment < 0) {
            this.nextFreeSegment = 0;
        }
    }

    private void grow() {
        int n = this.segments.length;
        String[] stringArray = new String[n * 2];
        System.arraycopy(this.segments, 0, stringArray, 0, n);
        this.segments = stringArray;
    }

    public void iterate(IElementContentVisitor iElementContentVisitor) {
        if (this.path.isRoot()) {
            if (iElementContentVisitor.visitElement(this.tree, this, this.tree.getTreeData())) {
                if (this.treeRoot == null) {
                    return;
                }
                AbstractDataTreeNode[] abstractDataTreeNodeArray = this.treeRoot.getChildren();
                int n = abstractDataTreeNodeArray.length;
                while (--n >= 0) {
                    this.doIteration((DataTreeNode)abstractDataTreeNodeArray[n], iElementContentVisitor);
                }
            }
        } else {
            if (this.treeRoot == null) {
                return;
            }
            this.push(this.path, this.path.segmentCount() - 1);
            this.doIteration(this.treeRoot, iElementContentVisitor);
        }
    }

    private void push(IPath iPath, int n) {
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.nextFreeSegment >= this.segments.length) {
                this.grow();
            }
            this.segments[this.nextFreeSegment++] = iPath.segment(n2);
            ++n2;
        }
    }

    public String requestName() {
        if (this.nextFreeSegment == 0) {
            return "";
        }
        return this.segments[this.nextFreeSegment - 1];
    }

    public IPath requestPath() {
        if (this.nextFreeSegment == 0) {
            return Path.ROOT;
        }
        int n = this.nextFreeSegment;
        int n2 = 0;
        while (n2 < this.nextFreeSegment) {
            n += this.segments[n2].length();
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n3 = 0;
        while (n3 < this.nextFreeSegment) {
            stringBuffer.append('/');
            stringBuffer.append(this.segments[n3]);
            ++n3;
        }
        return new Path(null, stringBuffer.toString());
    }
}

