/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.core.internal.dtree.DataTreeReader;
import org.eclipse.core.internal.dtree.IDataFlattener;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReaderImpl_1;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ElementTreeReader {
    protected IElementInfoFlattener elementInfoFlattener;
    protected DataTreeReader dataTreeReader;

    public ElementTreeReader(final IElementInfoFlattener iElementInfoFlattener) {
        Assert.isNotNull((Object)iElementInfoFlattener);
        this.elementInfoFlattener = iElementInfoFlattener;
        IDataFlattener iDataFlattener = new IDataFlattener(){

            public void writeData(IPath iPath, Object object, DataOutput dataOutput) {
            }

            public Object readData(IPath iPath, DataInput dataInput) throws IOException {
                if (!Path.ROOT.equals((Object)iPath)) {
                    return iElementInfoFlattener.readElement(iPath, dataInput);
                }
                return null;
            }
        };
        this.dataTreeReader = new DataTreeReader(iDataFlattener);
    }

    public ElementTreeReader getReader(int n) throws IOException {
        if (n == 1) {
            return new ElementTreeReaderImpl_1(this.elementInfoFlattener);
        }
        throw new IOException(Messages.watson_unknown);
    }

    public ElementTree readDelta(ElementTree elementTree, DataInput dataInput) throws IOException {
        ElementTreeReader elementTreeReader = this.getReader(ElementTreeReader.readNumber(dataInput));
        return elementTreeReader.readDelta(elementTree, dataInput);
    }

    public ElementTree[] readDeltaChain(DataInput dataInput) throws IOException {
        ElementTreeReader elementTreeReader = this.getReader(ElementTreeReader.readNumber(dataInput));
        return elementTreeReader.readDeltaChain(dataInput);
    }

    protected static int readNumber(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        int n = by & 0xFF;
        if (n == 255) {
            n = dataInput.readInt();
        }
        return n;
    }

    public ElementTree readTree(DataInput dataInput) throws IOException {
        ElementTreeReader elementTreeReader = this.getReader(ElementTreeReader.readNumber(dataInput));
        return elementTreeReader.readTree(dataInput);
    }
}

