/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import java.io.DataInput;
import java.io.IOException;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.internal.watson.IElementTreeData;

class ElementTreeReaderImpl_1
extends ElementTreeReader {
    ElementTreeReaderImpl_1(IElementInfoFlattener iElementInfoFlattener) {
        super(iElementInfoFlattener);
    }

    public ElementTree readDelta(ElementTree elementTree, DataInput dataInput) throws IOException {
        DeltaDataTree deltaDataTree = elementTree.getDataTree();
        DeltaDataTree deltaDataTree2 = this.dataTreeReader.readTree(deltaDataTree, dataInput);
        if (deltaDataTree2.isEmptyDelta()) {
            return elementTree;
        }
        ElementTree elementTree2 = new ElementTree(deltaDataTree2);
        IElementTreeData iElementTreeData = elementTree.getTreeData();
        if (iElementTreeData != null) {
            elementTree2.setTreeData((IElementTreeData)iElementTreeData.clone());
        }
        deltaDataTree2.immutable();
        return elementTree2;
    }

    public ElementTree[] readDeltaChain(DataInput dataInput) throws IOException {
        int n = ElementTreeReaderImpl_1.readNumber(dataInput);
        ElementTree[] elementTreeArray = new ElementTree[n];
        if (n <= 0) {
            return elementTreeArray;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = ElementTreeReaderImpl_1.readNumber(dataInput);
            ++n2;
        }
        elementTreeArray[nArray[0]] = super.readTree(dataInput);
        n2 = 1;
        while (n2 < n) {
            elementTreeArray[nArray[n2]] = super.readDelta(elementTreeArray[nArray[n2 - 1]], dataInput);
            ++n2;
        }
        return elementTreeArray;
    }

    public ElementTree readTree(DataInput dataInput) throws IOException {
        ElementTree elementTree = new ElementTree(this.dataTreeReader.readTree(null, dataInput));
        return elementTree;
    }
}

