/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.dtree.DataTreeWriter;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IDataFlattener;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.IElementComparator;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ElementTreeWriter {
    public static final int CURRENT_FORMAT = 1;
    public static final int D_INFINITE = -1;
    protected DataTreeWriter dataTreeWriter;

    public ElementTreeWriter(final IElementInfoFlattener iElementInfoFlattener) {
        IDataFlattener iDataFlattener = new IDataFlattener(){

            public void writeData(IPath iPath, Object object, DataOutput dataOutput) throws IOException {
                if (!Path.ROOT.equals((Object)iPath)) {
                    iElementInfoFlattener.writeElement(iPath, object, dataOutput);
                }
            }

            public Object readData(IPath iPath, DataInput dataInput) {
                return null;
            }
        };
        this.dataTreeWriter = new DataTreeWriter(iDataFlattener);
    }

    protected ElementTree[] sortTrees(ElementTree[] elementTreeArray, DataOutput dataOutput) throws IOException {
        int n = elementTreeArray.length;
        ElementTree[] elementTreeArray2 = new ElementTree[n];
        int[] nArray = new int[n];
        HashMap<ElementTree, ArrayList<Integer>> hashMap = new HashMap<ElementTree, ArrayList<Integer>>(n * 2 + 1);
        int n2 = 0;
        while (n2 < elementTreeArray.length) {
            ArrayList<Integer> arrayList = (ArrayList<Integer>)hashMap.get(elementTreeArray[n2]);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
                hashMap.put(elementTreeArray[n2], arrayList);
            }
            arrayList.add(new Integer(n2));
            ++n2;
        }
        Object object = elementTreeArray[ElementTree.findOldest(elementTreeArray)];
        int n3 = n - 1;
        while (n3 >= 0) {
            List list = (List)hashMap.remove(object);
            Object object2 = Collections.enumeration(list);
            while (object2.hasMoreElements()) {
                Integer n4 = (Integer)object2.nextElement();
                elementTreeArray2[n3] = object;
                nArray[n3] = n4;
                --n3;
            }
            if (n3 < 0) continue;
            object2 = ((ElementTree)object).getParent();
            while (hashMap.get(object2) == null) {
                object2 = ((ElementTree)object2).getParent();
            }
            object = object2;
        }
        n3 = 0;
        while (n3 < n) {
            this.writeNumber(nArray[n3], dataOutput);
            ++n3;
        }
        return elementTreeArray2;
    }

    public void writeDelta(ElementTree elementTree, ElementTree elementTree2, IPath iPath, int n, DataOutput dataOutput, IElementComparator iElementComparator) throws IOException {
        this.writeNumber(1, dataOutput);
        DeltaDataTree deltaDataTree = elementTree2.getDataTree();
        DeltaDataTree deltaDataTree2 = elementTree.getDataTree();
        DeltaDataTree deltaDataTree3 = null;
        deltaDataTree3 = deltaDataTree.forwardDeltaWith(deltaDataTree2, iElementComparator);
        Assert.isTrue((boolean)deltaDataTree3.isImmutable());
        this.dataTreeWriter.writeTree(deltaDataTree3, iPath, n, dataOutput);
    }

    public void writeDeltaChain(ElementTree[] elementTreeArray, IPath iPath, int n, DataOutput dataOutput, IElementComparator iElementComparator) throws IOException {
        this.writeNumber(1, dataOutput);
        int n2 = elementTreeArray.length;
        this.writeNumber(n2, dataOutput);
        if (n2 <= 0) {
            return;
        }
        ElementTree[] elementTreeArray2 = this.sortTrees(elementTreeArray, dataOutput);
        this.writeTree(elementTreeArray2[0], iPath, n, dataOutput);
        int n3 = 1;
        while (n3 < n2) {
            this.writeDelta(elementTreeArray2[n3], elementTreeArray2[n3 - 1], iPath, n, dataOutput, iElementComparator);
            ++n3;
        }
    }

    protected void writeNumber(int n, DataOutput dataOutput) throws IOException {
        if (n >= 0 && n < 255) {
            dataOutput.writeByte(n);
        } else {
            dataOutput.writeByte(255);
            dataOutput.writeInt(n);
        }
    }

    public void writeTree(ElementTree elementTree, IPath iPath, int n, DataOutput dataOutput) throws IOException {
        this.writeNumber(1, dataOutput);
        DeltaDataTree deltaDataTree = new DeltaDataTree(elementTree.getDataTree().copyCompleteSubtree((IPath)Path.ROOT));
        this.dataTreeWriter.writeTree(deltaDataTree, iPath, n, dataOutput);
    }
}

