/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import java.util.HashMap;
import org.eclipse.core.resources.IFilterType;
import org.eclipse.core.resources.IFilterTypeFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;

public class FilterTypeManager {
    private static final String FILTER_PROVIDER = "filterProvider";
    public static final String ARGUMENT_TYPE_NONE = "none";
    public static final String ARGUMENT_TYPE_STRING = "string";
    public static final String ARGUMENT_TYPE_FILTERS = "filters";
    public static final String ARGUMENT_TYPE_FILTER = "filter";
    private HashMap factories = new HashMap();
    private static FilterTypeManager instance = null;

    public static FilterTypeManager getDefault() {
        if (instance == null) {
            instance = new FilterTypeManager();
        }
        return instance;
    }

    protected FilterTypeManager() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "filterProviders");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n];
                this.processExtension(iExtension);
                ++n;
            }
            Platform.getExtensionRegistry().addListener(new IRegistryEventListener(){

                public void added(IExtension[] iExtensionArray) {
                    int n = 0;
                    while (n < iExtensionArray.length) {
                        FilterTypeManager.this.processExtension(iExtensionArray[n]);
                        ++n;
                    }
                }

                public void added(IExtensionPoint[] iExtensionPointArray) {
                }

                public void removed(IExtension[] iExtensionArray) {
                    int n = 0;
                    while (n < iExtensionArray.length) {
                        FilterTypeManager.this.processRemovedExtension(iExtensionArray[n]);
                        ++n;
                    }
                }

                public void removed(IExtensionPoint[] iExtensionPointArray) {
                }
            });
        }
    }

    protected void processExtension(IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equalsIgnoreCase(FILTER_PROVIDER)) {
                try {
                    Descriptor descriptor = new Descriptor(iConfigurationElement);
                    this.factories.put(descriptor.getId(), descriptor);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            ++n;
        }
    }

    protected void processRemovedExtension(IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equalsIgnoreCase(FILTER_PROVIDER)) {
                try {
                    Descriptor descriptor = new Descriptor(iConfigurationElement, false);
                    this.factories.remove(descriptor.getId());
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            ++n;
        }
    }

    public Descriptor[] getDescriptors() {
        return this.factories.values().toArray(new Descriptor[0]);
    }

    public IFilterType instantiate(String string, IProject iProject, String string2) {
        Object v = this.factories.get(string);
        if (v != null) {
            return ((Descriptor)v).getFactory().instantiate(iProject, string2);
        }
        return null;
    }

    public Descriptor findDescriptor(String string) {
        return (Descriptor)this.factories.get(string);
    }

    public class Descriptor {
        private String id;
        private String name;
        private String description;
        private String argumentType;
        private IFilterTypeFactory factory;
        private boolean isFirst = false;

        public Descriptor(IConfigurationElement iConfigurationElement) throws CoreException {
            this(iConfigurationElement, true);
        }

        public Descriptor(IConfigurationElement iConfigurationElement, boolean bl) throws CoreException {
            String string;
            this.id = iConfigurationElement.getAttribute("id");
            this.name = iConfigurationElement.getAttribute("name");
            this.description = iConfigurationElement.getAttribute("description");
            this.argumentType = iConfigurationElement.getAttribute("argumentType");
            if (this.argumentType == null) {
                this.argumentType = FilterTypeManager.ARGUMENT_TYPE_NONE;
            }
            if (bl) {
                this.factory = (IFilterTypeFactory)iConfigurationElement.createExecutableExtension("class");
            }
            if ((string = iConfigurationElement.getAttribute("ordering")) != null) {
                this.isFirst = string.equals("first");
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getArgumentType() {
            return this.argumentType;
        }

        public IFilterTypeFactory getFactory() {
            return this.factory;
        }

        public boolean isFirstOrdering() {
            return this.isFirst;
        }
    }
}

