/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;

public final class ProjectScope
implements IScopeContext {
    public static final String SCOPE = "project";
    private IProject context;

    public ProjectScope(IProject iProject) {
        if (iProject == null) {
            throw new IllegalArgumentException();
        }
        this.context = iProject;
    }

    public IEclipsePreferences getNode(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node(SCOPE).node(this.context.getName()).node(string);
    }

    public IPath getLocation() {
        IProject iProject = this.context.getProject();
        IPath iPath = iProject.getLocation();
        return iPath == null ? null : iPath.append(".settings");
    }

    public String getName() {
        return SCOPE;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof ProjectScope)) {
            return false;
        }
        ProjectScope projectScope = (ProjectScope)object;
        return this.context.equals(projectScope.context);
    }

    public int hashCode() {
        return super.hashCode() + this.context.getFullPath().hashCode();
    }
}

