/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectVariableProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectVariableProviderManager {
    private static Map descriptors;
    private static ProjectVariableProviderManager instance;

    public static synchronized ProjectVariableProviderManager getDefault() {
        if (instance == null) {
            instance = new ProjectVariableProviderManager();
        }
        return instance;
    }

    public Descriptor[] getDescriptors() {
        this.lazyInitialize();
        return descriptors.values().toArray(new Descriptor[descriptors.size()]);
    }

    protected void lazyInitialize() {
        if (descriptors != null) {
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "variableProviders");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        descriptors = new HashMap(iExtensionArray.length * 2 + 1);
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n4];
                String string = iConfigurationElement.getName();
                if (string.equalsIgnoreCase("variableProvider")) {
                    Descriptor descriptor = null;
                    try {
                        descriptor = new Descriptor(iExtensionArray[n], iConfigurationElement);
                    }
                    catch (CoreException coreException) {
                        Policy.log(coreException);
                    }
                    if (descriptor != null) {
                        descriptors.put(descriptor.getName(), descriptor);
                    }
                }
                ++n4;
            }
            ++n;
        }
    }

    public Descriptor findDescriptor(String string) {
        Object v = descriptors.get(string);
        if (v != null) {
            return (Descriptor)v;
        }
        return null;
    }

    public static class Descriptor {
        IProjectVariableProvider provider = null;
        String name = null;
        String value = null;

        public Descriptor(IExtension iExtension, IConfigurationElement iConfigurationElement) throws RuntimeException, CoreException {
            this.name = iConfigurationElement.getAttribute("name");
            this.value = iConfigurationElement.getAttribute("value");
            try {
                this.provider = (IProjectVariableProvider)iConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
            if (this.name == null) {
                this.fail(NLS.bind((String)Messages.mapping_invalidDef, (Object)iExtension.getUniqueIdentifier()));
            }
        }

        protected void fail(String string) throws CoreException {
            throw new ResourceException((IStatus)new Status(4, "org.eclipse.core.resources", 1, string, null));
        }

        public String getName() {
            return this.name;
        }

        public String getValue(String string, IProject iProject) {
            if (this.value != null) {
                return this.value;
            }
            return this.provider.getValue(string, iProject);
        }

        public Object[] getExtensions(String string, IProject iProject) {
            if (this.provider != null) {
                return this.provider.getExtensions(string, iProject);
            }
            return null;
        }
    }
}

