/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.runtime.CoreException;

public class ResourceAttributes {
    private int attributes;

    public static ResourceAttributes fromFile(File file) {
        try {
            return FileUtil.fileInfoToAttributes(EFS.getStore((URI)file.toURI()).fetchInfo());
        }
        catch (CoreException coreException) {
            return new ResourceAttributes();
        }
    }

    public boolean isArchive() {
        return (this.attributes & 8) != 0;
    }

    public boolean isExecutable() {
        return (this.attributes & 4) != 0;
    }

    public boolean isHidden() {
        return (this.attributes & 0x10) != 0;
    }

    public boolean isReadOnly() {
        return (this.attributes & 2) != 0;
    }

    public boolean isSymbolicLink() {
        return (this.attributes & 0x20) != 0;
    }

    public void setArchive(boolean bl) {
        this.set(8, bl);
    }

    private void set(int n, boolean bl) {
        this.attributes = bl ? (this.attributes |= n) : (this.attributes &= ~n);
    }

    public void setExecutable(boolean bl) {
        this.set(4, bl);
    }

    public void setHidden(boolean bl) {
        this.set(16, bl);
    }

    public void setReadOnly(boolean bl) {
        this.set(2, bl);
    }

    public void setSymbolicLink(boolean bl) {
        this.set(32, bl);
    }

    public String toString() {
        return "ResourceAttributes(" + this.attributes + ')';
    }
}

