/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class CompositeResourceMapping
extends ResourceMapping {
    private final ResourceMapping[] mappings;
    private final Object modelObject;
    private IProject[] projects;
    private String providerId;

    public CompositeResourceMapping(String string, Object object, ResourceMapping[] resourceMappingArray) {
        this.modelObject = object;
        this.mappings = resourceMappingArray;
        this.providerId = string;
    }

    public boolean contains(ResourceMapping resourceMapping) {
        int n = 0;
        while (n < this.mappings.length) {
            ResourceMapping resourceMapping2 = this.mappings[n];
            if (resourceMapping2.contains(resourceMapping)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ResourceMapping[] getMappings() {
        return this.mappings;
    }

    public Object getModelObject() {
        return this.modelObject;
    }

    public String getModelProviderId() {
        return this.providerId;
    }

    public IProject[] getProjects() {
        if (this.projects == null) {
            HashSet<IProject> hashSet = new HashSet<IProject>();
            int n = 0;
            while (n < this.mappings.length) {
                ResourceMapping resourceMapping = this.mappings[n];
                hashSet.addAll(Arrays.asList(resourceMapping.getProjects()));
                ++n;
            }
            this.projects = hashSet.toArray(new IProject[hashSet.size()]);
        }
        return this.projects;
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("", 100 * this.mappings.length);
            ArrayList<ResourceTraversal> arrayList = new ArrayList<ResourceTraversal>();
            int n = 0;
            while (n < this.mappings.length) {
                ResourceMapping resourceMapping = this.mappings[n];
                arrayList.addAll(Arrays.asList(resourceMapping.getTraversals(resourceMappingContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100))));
                ++n;
            }
            ResourceTraversal[] resourceTraversalArray = arrayList.toArray(new ResourceTraversal[arrayList.size()]);
            return resourceTraversalArray;
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

