/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.internal.resources.mapping.ModelProviderManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelStatus;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class ModelProvider
extends PlatformObject {
    public static final String RESOURCE_MODEL_PROVIDER_ID = "org.eclipse.core.resources.modelProvider";
    private IModelProviderDescriptor descriptor;

    public static IModelProviderDescriptor getModelProviderDescriptor(String string) {
        IModelProviderDescriptor[] iModelProviderDescriptorArray = ModelProviderManager.getDefault().getDescriptors();
        int n = 0;
        while (n < iModelProviderDescriptorArray.length) {
            IModelProviderDescriptor iModelProviderDescriptor = iModelProviderDescriptorArray[n];
            if (iModelProviderDescriptor.getId().equals(string)) {
                return iModelProviderDescriptor;
            }
            ++n;
        }
        return null;
    }

    public static IModelProviderDescriptor[] getModelProviderDescriptors() {
        return ModelProviderManager.getDefault().getDescriptors();
    }

    public boolean equals(Object object) {
        if (object instanceof ModelProvider) {
            ModelProvider modelProvider = (ModelProvider)((Object)object);
            return modelProvider.getDescriptor().getId().equals(this.getDescriptor().getId());
        }
        return super.equals(object);
    }

    public final IModelProviderDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final String getId() {
        return this.descriptor.getId();
    }

    public ResourceMapping[] getMappings(IResource iResource, ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
        return new ResourceMapping[0];
    }

    public ResourceMapping[] getMappings(IResource[] iResourceArray, ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
        HashSet<ResourceMapping> hashSet = new HashSet<ResourceMapping>();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            ResourceMapping[] resourceMappingArray = this.getMappings(iResource, resourceMappingContext, iProgressMonitor);
            if (resourceMappingArray.length > 0) {
                hashSet.addAll(Arrays.asList(resourceMappingArray));
            }
            ++n;
        }
        return hashSet.toArray(new ResourceMapping[hashSet.size()]);
    }

    public ResourceMapping[] getMappings(ResourceTraversal[] resourceTraversalArray, ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
        HashSet<ResourceMapping> hashSet = new HashSet<ResourceMapping>();
        int n = 0;
        while (n < resourceTraversalArray.length) {
            ResourceTraversal resourceTraversal = resourceTraversalArray[n];
            ResourceMapping[] resourceMappingArray = this.getMappings(resourceTraversal.getResources(), resourceMappingContext, iProgressMonitor);
            int n2 = 0;
            while (n2 < resourceMappingArray.length) {
                hashSet.add(resourceMappingArray[n2]);
                ++n2;
            }
            ++n;
        }
        return hashSet.toArray(new ResourceMapping[hashSet.size()]);
    }

    public ResourceTraversal[] getTraversals(ResourceMapping[] resourceMappingArray, ResourceMappingContext resourceMappingContext, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iProgressMonitor.beginTask("", 100 * resourceMappingArray.length);
            ArrayList<ResourceTraversal> arrayList = new ArrayList<ResourceTraversal>();
            int n = 0;
            while (n < resourceMappingArray.length) {
                ResourceMapping resourceMapping = resourceMappingArray[n];
                arrayList.addAll(Arrays.asList(resourceMapping.getTraversals(resourceMappingContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100))));
                ++n;
            }
            ResourceTraversal[] resourceTraversalArray = arrayList.toArray(new ResourceTraversal[arrayList.size()]);
            return resourceTraversalArray;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public int hashCode() {
        return this.getDescriptor().getId().hashCode();
    }

    public final void init(IModelProviderDescriptor iModelProviderDescriptor) {
        if (this.descriptor != null) {
            return;
        }
        this.descriptor = iModelProviderDescriptor;
        this.initialize();
    }

    protected void initialize() {
    }

    public IStatus validateChange(IResourceDelta iResourceDelta, IProgressMonitor iProgressMonitor) {
        return new ModelStatus(0, "org.eclipse.core.resources", this.descriptor.getId(), Status.OK_STATUS.getMessage());
    }
}

