/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.mapping;

import java.util.ArrayList;
import org.eclipse.core.internal.resources.mapping.ChangeDescription;
import org.eclipse.core.internal.resources.mapping.ResourceChangeDescriptionFactory;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class ResourceChangeValidator {
    private static ResourceChangeValidator instance;

    public static ResourceChangeValidator getValidator() {
        if (instance == null) {
            instance = new ResourceChangeValidator();
        }
        return instance;
    }

    private ResourceChangeValidator() {
    }

    private IStatus combineResults(IStatus[] iStatusArray) {
        ArrayList<IStatus> arrayList = new ArrayList<IStatus>();
        int n = 0;
        while (n < iStatusArray.length) {
            IStatus iStatus = iStatusArray[n];
            if (!iStatus.isOK()) {
                arrayList.add(iStatus);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (arrayList.size() == 1) {
            return (IStatus)arrayList.get(0);
        }
        return new MultiStatus("org.eclipse.core.resources", 0, arrayList.toArray(new IStatus[arrayList.size()]), Messages.mapping_multiProblems, null);
    }

    public IResourceChangeDescriptionFactory createDeltaFactory() {
        return new ResourceChangeDescriptionFactory();
    }

    private ModelProvider[] getProviders(IResource[] iResourceArray) {
        IModelProviderDescriptor[] iModelProviderDescriptorArray = ModelProvider.getModelProviderDescriptors();
        ArrayList<ModelProvider> arrayList = new ArrayList<ModelProvider>();
        int n = 0;
        while (n < iModelProviderDescriptorArray.length) {
            IModelProviderDescriptor iModelProviderDescriptor = iModelProviderDescriptorArray[n];
            try {
                IResource[] iResourceArray2 = iModelProviderDescriptor.getMatchingResources(iResourceArray);
                if (iResourceArray2.length > 0) {
                    arrayList.add(iModelProviderDescriptor.getModelProvider());
                }
            }
            catch (CoreException coreException) {
                Policy.log(coreException.getStatus().getSeverity(), NLS.bind((String)"Could not instantiate provider {0}", (Object)iModelProviderDescriptor.getId()), coreException);
            }
            ++n;
        }
        return arrayList.toArray(new ModelProvider[arrayList.size()]);
    }

    private IResource[] getRootResources(IResourceDelta iResourceDelta) {
        final ChangeDescription changeDescription = new ChangeDescription();
        try {
            iResourceDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta iResourceDelta) {
                    return changeDescription.recordChange(iResourceDelta);
                }
            });
        }
        catch (CoreException coreException) {
            Policy.log(4, "Internal error", coreException);
        }
        return changeDescription.getRootResources();
    }

    public IStatus validateChange(IResourceDelta iResourceDelta, IProgressMonitor iProgressMonitor) {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            IResource[] iResourceArray = this.getRootResources(iResourceDelta);
            ModelProvider[] modelProviderArray = this.getProviders(iResourceArray);
            if (modelProviderArray.length == 0) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            iProgressMonitor.beginTask(Messages.mapping_validate, modelProviderArray.length);
            IStatus[] iStatusArray = new IStatus[modelProviderArray.length];
            int n = 0;
            while (n < modelProviderArray.length) {
                iStatusArray[n] = modelProviderArray[n].validateChange(iResourceDelta, Policy.subMonitorFor(iProgressMonitor, 1));
                ++n;
            }
            IStatus iStatus = this.combineResults(iStatusArray);
            return iStatus;
        }
        finally {
            iProgressMonitor.done();
        }
    }
}

