/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.mapping;

import java.util.ArrayList;
import org.eclipse.core.internal.resources.mapping.ModelProviderManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class ResourceMapping
extends PlatformObject {
    public void accept(ResourceMappingContext resourceMappingContext, IResourceVisitor iResourceVisitor, IProgressMonitor iProgressMonitor) throws CoreException {
        ResourceTraversal[] resourceTraversalArray = this.getTraversals(resourceMappingContext, iProgressMonitor);
        int n = 0;
        while (n < resourceTraversalArray.length) {
            resourceTraversalArray[n].accept(iResourceVisitor);
            ++n;
        }
    }

    public boolean contains(ResourceMapping resourceMapping) {
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ResourceMapping) {
            ResourceMapping resourceMapping = (ResourceMapping)((Object)object);
            return resourceMapping.getModelObject().equals(this.getModelObject());
        }
        return false;
    }

    public IMarker[] findMarkers(String string, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        ResourceTraversal[] resourceTraversalArray = this.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, iProgressMonitor);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < resourceTraversalArray.length) {
            resourceTraversalArray[n].doFindMarkers(arrayList, string, bl);
            ++n;
        }
        return arrayList.toArray(new IMarker[arrayList.size()]);
    }

    public abstract Object getModelObject();

    public final ModelProvider getModelProvider() {
        try {
            return ModelProviderManager.getDefault().getModelProvider(this.getModelProviderId());
        }
        catch (CoreException coreException) {
            throw new IllegalStateException(coreException.getMessage());
        }
    }

    public abstract String getModelProviderId();

    public abstract IProject[] getProjects();

    public abstract ResourceTraversal[] getTraversals(ResourceMappingContext var1, IProgressMonitor var2) throws CoreException;

    public int hashCode() {
        return this.getModelObject().hashCode();
    }
}

