/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.mapping;

import java.util.ArrayList;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ResourceTraversal {
    private final int depth;
    private final int flags;
    private final IResource[] resources;

    public ResourceTraversal(IResource[] iResourceArray, int n, int n2) {
        if (iResourceArray == null) {
            throw new NullPointerException();
        }
        this.resources = iResourceArray;
        this.depth = n;
        this.flags = n2;
    }

    public void accept(IResourceVisitor iResourceVisitor) throws CoreException {
        int n = 0;
        int n2 = this.resources.length;
        while (n < n2) {
            block4: {
                try {
                    if (this.resources[n].exists()) {
                        this.resources[n].accept(iResourceVisitor, this.depth, this.flags);
                    }
                }
                catch (CoreException coreException) {
                    if (coreException.getStatus().getCode() == 368) break block4;
                    throw coreException;
                }
            }
            ++n;
        }
    }

    public boolean contains(IResource iResource) {
        int n = 0;
        while (n < this.resources.length) {
            IResource iResource2 = this.resources[n];
            if (this.contains(iResource2, iResource)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean contains(IResource iResource, IResource iResource2) {
        if (iResource.equals(iResource2)) {
            return true;
        }
        if (this.depth == 0) {
            return false;
        }
        if (iResource2.getParent().equals(iResource)) {
            return true;
        }
        if (this.depth == 2) {
            return iResource.getFullPath().isPrefixOf(iResource2.getFullPath());
        }
        return false;
    }

    void doFindMarkers(ArrayList arrayList, String string, boolean bl) {
        MarkerManager markerManager = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager();
        int n = 0;
        while (n < this.resources.length) {
            markerManager.doFindMarkers(this.resources[n], arrayList, string, bl, this.depth);
            ++n;
        }
    }

    public IMarker[] findMarkers(String string, boolean bl) throws CoreException {
        if (this.resources.length == 0) {
            return new IMarker[0];
        }
        ArrayList arrayList = new ArrayList();
        this.doFindMarkers(arrayList, string, bl);
        return arrayList.toArray(new IMarker[arrayList.size()]);
    }

    public int getDepth() {
        return this.depth;
    }

    public int getFlags() {
        return this.flags;
    }

    public IResource[] getResources() {
        return this.resources;
    }
}

